/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.relational.core.mapping.SqlIdentifierSanitizer;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.spel.EvaluationContextProvider;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.util.Assert;

class SqlIdentifierExpressionEvaluator {
    private EvaluationContextProvider provider;
    private SqlIdentifierSanitizer sanitizer = SqlIdentifierSanitizer.words();
    private Environment environment = new StandardEnvironment();

    public SqlIdentifierExpressionEvaluator(EvaluationContextProvider provider) {
        this.provider = provider;
    }

    public SqlIdentifier evaluate(ValueExpression expression, boolean isForceQuote) throws EvaluationException {
        Assert.notNull((Object)expression, (String)"Expression must not be null.");
        EvaluationContext evaluationContext = this.provider.getEvaluationContext(null);
        ValueEvaluationContext valueEvaluationContext = ValueEvaluationContext.of((Environment)this.environment, (EvaluationContext)evaluationContext);
        Object value = expression.evaluate(valueEvaluationContext);
        if (value instanceof SqlIdentifier) {
            SqlIdentifier sqlIdentifier = (SqlIdentifier)value;
            return sqlIdentifier;
        }
        if (value == null) {
            throw new EvaluationException("Expression '%s' evaluated to 'null'".formatted(expression));
        }
        String sanitizedResult = this.sanitizer.sanitize(value.toString());
        return isForceQuote ? SqlIdentifier.quoted(sanitizedResult) : SqlIdentifier.unquoted(sanitizedResult);
    }

    public void setSanitizer(SqlIdentifierSanitizer sanitizer) {
        Assert.notNull((Object)sanitizer, (String)"SqlIdentifierSanitizer must not be null");
        this.sanitizer = sanitizer;
    }

    public void setProvider(EvaluationContextProvider provider) {
        Assert.notNull((Object)provider, (String)"EvaluationContextProvider must not be null");
        this.provider = provider;
    }

    public void setEnvironment(Environment environment) {
        Assert.notNull((Object)environment, (String)"Environment must not be null");
        this.environment = environment;
    }
}

