/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.Aliased;
import org.springframework.data.relational.core.sql.AnalyticFunction;
import org.springframework.data.relational.core.sql.AsteriskFromTable;
import org.springframework.data.relational.core.sql.BindMarker;
import org.springframework.data.relational.core.sql.CaseExpression;
import org.springframework.data.relational.core.sql.Cast;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.InlineQuery;
import org.springframework.data.relational.core.sql.Named;
import org.springframework.data.relational.core.sql.SimpleFunction;
import org.springframework.data.relational.core.sql.SubselectExpression;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.data.relational.core.sql.TupleExpression;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.AnalyticFunctionVisitor;
import org.springframework.data.relational.core.sql.render.CaseExpressionVisitor;
import org.springframework.data.relational.core.sql.render.CastVisitor;
import org.springframework.data.relational.core.sql.render.ConditionVisitor;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.NameRenderer;
import org.springframework.data.relational.core.sql.render.NoopVisitor;
import org.springframework.data.relational.core.sql.render.PartRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.SelectStatementVisitor;
import org.springframework.data.relational.core.sql.render.SimpleFunctionVisitor;
import org.springframework.data.relational.core.sql.render.TupleVisitor;
import org.springframework.data.relational.core.sql.render.TypedSubtreeVisitor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class ExpressionVisitor
extends TypedSubtreeVisitor<Expression>
implements PartRenderer {
    private final RenderContext context;
    private final AliasHandling aliasHandling;
    private CharSequence value = "";
    @Nullable
    private PartRenderer partRenderer;

    ExpressionVisitor(RenderContext context) {
        this(context, AliasHandling.IGNORE);
    }

    ExpressionVisitor(RenderContext context, AliasHandling aliasHandling) {
        Assert.notNull((Object)context, (String)"The render context must not be null");
        Assert.notNull((Object)((Object)aliasHandling), (String)"The aliasHandling must not be null");
        this.context = context;
        this.aliasHandling = aliasHandling;
    }

    @Override
    DelegatingVisitor.Delegation enterMatched(Expression segment) {
        if (segment instanceof SubselectExpression) {
            SelectStatementVisitor visitor = new SelectStatementVisitor(this.context);
            this.partRenderer = visitor;
            return DelegatingVisitor.Delegation.delegateTo(visitor);
        }
        if (segment instanceof SimpleFunction) {
            SimpleFunctionVisitor visitor = new SimpleFunctionVisitor(this.context);
            this.partRenderer = visitor;
            return DelegatingVisitor.Delegation.delegateTo(visitor);
        }
        if (segment instanceof TupleExpression) {
            TupleVisitor visitor = new TupleVisitor(this.context);
            this.partRenderer = visitor;
            return DelegatingVisitor.Delegation.delegateTo(visitor);
        }
        if (segment instanceof AnalyticFunction) {
            AnalyticFunctionVisitor visitor = new AnalyticFunctionVisitor(this.context);
            this.partRenderer = visitor;
            return DelegatingVisitor.Delegation.delegateTo(visitor);
        }
        if (segment instanceof Column) {
            Column column = (Column)segment;
            this.value = this.aliasHandling == AliasHandling.USE ? NameRenderer.fullyQualifiedReference(this.context, column) : NameRenderer.fullyQualifiedUnaliasedReference(this.context, column);
        } else if (segment instanceof BindMarker) {
            this.value = segment instanceof Named ? NameRenderer.render(this.context, (Named)((Object)segment)) : segment.toString();
        } else if (segment instanceof AsteriskFromTable) {
            CharSequence charSequence;
            AsteriskFromTable asteriskFromTable = (AsteriskFromTable)segment;
            TableLike table = asteriskFromTable.getTable();
            if (table instanceof Aliased) {
                Aliased aliasedTable = (Aliased)((Object)table);
                charSequence = NameRenderer.render(this.context, aliasedTable);
            } else {
                charSequence = NameRenderer.render(this.context, table);
            }
            CharSequence renderedTable = charSequence;
            this.value = String.valueOf(renderedTable) + ".*";
        } else {
            if (segment instanceof Cast) {
                CastVisitor visitor = new CastVisitor(this.context);
                this.partRenderer = visitor;
                return DelegatingVisitor.Delegation.delegateTo(visitor);
            }
            if (segment instanceof CaseExpression) {
                CaseExpressionVisitor visitor = new CaseExpressionVisitor(this.context);
                this.partRenderer = visitor;
                return DelegatingVisitor.Delegation.delegateTo(visitor);
            }
            this.value = segment.toString();
        }
        return DelegatingVisitor.Delegation.retain();
    }

    @Override
    DelegatingVisitor.Delegation enterNested(Visitable segment) {
        if (segment instanceof Condition) {
            ConditionVisitor visitor = new ConditionVisitor(this.context);
            this.partRenderer = visitor;
            return DelegatingVisitor.Delegation.delegateTo(visitor);
        }
        if (segment instanceof InlineQuery) {
            NoopVisitor<InlineQuery> partRenderer = new NoopVisitor<InlineQuery>(InlineQuery.class);
            return DelegatingVisitor.Delegation.delegateTo(partRenderer);
        }
        return super.enterNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(Expression segment) {
        if (this.partRenderer != null) {
            this.value = this.partRenderer.getRenderedPart();
            this.partRenderer = null;
        }
        return super.leaveMatched(segment);
    }

    @Override
    public CharSequence getRenderedPart() {
        return this.value;
    }

    static enum AliasHandling {
        IGNORE,
        USE;

    }
}

