/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class Identifier {
    private static final Identifier EMPTY = new Identifier(Collections.emptyList());
    private final List<SingleIdentifierValue> parts;

    private Identifier(List<SingleIdentifierValue> parts) {
        this.parts = parts;
    }

    public static Identifier empty() {
        return EMPTY;
    }

    public static Identifier of(SqlIdentifier name, Object value, Class<?> targetType) {
        Assert.notNull((Object)name, (String)"Name must not be empty!");
        Assert.notNull(targetType, (String)"Target type must not be null!");
        return new Identifier(Collections.singletonList(new SingleIdentifierValue(name, value, targetType)));
    }

    public static Identifier from(Map<SqlIdentifier, Object> map) {
        Assert.notNull(map, (String)"Map must not be null!");
        if (map.isEmpty()) {
            return Identifier.empty();
        }
        ArrayList values = new ArrayList();
        map.forEach((? super K k, ? super V v) -> values.add(new SingleIdentifierValue((SqlIdentifier)k, v, v != null ? ClassUtils.getUserClass((Object)v) : Object.class)));
        return new Identifier(Collections.unmodifiableList(values));
    }

    public Identifier withPart(SqlIdentifier name, Object value, Class<?> targetType) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull(targetType, (String)"Target type must not be null!");
        boolean overwritten = false;
        ArrayList<SingleIdentifierValue> keys = new ArrayList<SingleIdentifierValue>(this.parts.size() + 1);
        for (SingleIdentifierValue singleValue : this.parts) {
            if (singleValue.getName().equals(name)) {
                overwritten = true;
                keys.add(new SingleIdentifierValue(singleValue.getName(), value, targetType));
                continue;
            }
            keys.add(singleValue);
        }
        if (!overwritten) {
            keys.add(new SingleIdentifierValue(name, value, targetType));
        }
        return new Identifier(Collections.unmodifiableList(keys));
    }

    public Map<SqlIdentifier, Object> toMap() {
        LinkedHashMap<SqlIdentifier, Object> result = new LinkedHashMap<SqlIdentifier, Object>();
        this.forEach((name, value, type) -> result.put(name, value));
        return result;
    }

    public Collection<SingleIdentifierValue> getParts() {
        return this.parts;
    }

    public void forEach(IdentifierConsumer consumer) {
        Assert.notNull((Object)consumer, (String)"IdentifierConsumer must not be null");
        this.getParts().forEach((? super T it) -> consumer.accept(((SingleIdentifierValue)it).name, ((SingleIdentifierValue)it).value, ((SingleIdentifierValue)it).targetType));
    }

    public int size() {
        return this.parts.size();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Identifier)) {
            return false;
        }
        Identifier other = (Identifier)o;
        Collection<SingleIdentifierValue> this$parts = this.getParts();
        Collection<SingleIdentifierValue> other$parts = other.getParts();
        return !(this$parts == null ? other$parts != null : !((Object)this$parts).equals(other$parts));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<SingleIdentifierValue> $parts = this.getParts();
        result = result * 59 + ($parts == null ? 43 : ((Object)$parts).hashCode());
        return result;
    }

    public String toString() {
        return "Identifier(parts=" + this.getParts() + ")";
    }

    @FunctionalInterface
    public static interface IdentifierConsumer {
        public void accept(SqlIdentifier var1, Object var2, Class<?> var3);
    }

    static final class SingleIdentifierValue {
        private final SqlIdentifier name;
        private final Object value;
        private final Class<?> targetType;

        public SqlIdentifier getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public Class<?> getTargetType() {
            return this.targetType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SingleIdentifierValue)) {
                return false;
            }
            SingleIdentifierValue other = (SingleIdentifierValue)o;
            SqlIdentifier this$name = this.getName();
            SqlIdentifier other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            Class<?> this$targetType = this.getTargetType();
            Class<?> other$targetType = other.getTargetType();
            return !(this$targetType == null ? other$targetType != null : !this$targetType.equals(other$targetType));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SqlIdentifier $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            Class<?> $targetType = this.getTargetType();
            result = result * 59 + ($targetType == null ? 43 : $targetType.hashCode());
            return result;
        }

        public String toString() {
            return "Identifier.SingleIdentifierValue(name=" + this.getName() + ", value=" + this.getValue() + ", targetType=" + this.getTargetType() + ")";
        }

        private SingleIdentifierValue(SqlIdentifier name, Object value, Class<?> targetType) {
            this.name = name;
            this.value = value;
            this.targetType = targetType;
        }
    }
}

