/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface ListOperations<K, V> {
    @Nullable
    public List<V> range(K var1, long var2, long var4);

    public void trim(K var1, long var2, long var4);

    @Nullable
    public Long size(K var1);

    @Nullable
    public Long leftPush(K var1, V var2);

    @Nullable
    public Long leftPushAll(K var1, V ... var2);

    @Nullable
    public Long leftPushAll(K var1, Collection<V> var2);

    @Nullable
    public Long leftPushIfPresent(K var1, V var2);

    @Nullable
    public Long leftPush(K var1, V var2, V var3);

    @Nullable
    public Long rightPush(K var1, V var2);

    @Nullable
    public Long rightPushAll(K var1, V ... var2);

    @Nullable
    public Long rightPushAll(K var1, Collection<V> var2);

    @Nullable
    public Long rightPushIfPresent(K var1, V var2);

    @Nullable
    public Long rightPush(K var1, V var2, V var3);

    @Nullable
    default public V move(MoveFrom<K> from, MoveTo<K> to) {
        Assert.notNull(from, (String)"Move from must not be null");
        Assert.notNull(to, (String)"Move to must not be null");
        return this.move(from.key, from.direction, to.key, to.direction);
    }

    @Nullable
    public V move(K var1, RedisListCommands.Direction var2, K var3, RedisListCommands.Direction var4);

    @Nullable
    default public V move(MoveFrom<K> from, MoveTo<K> to, Duration timeout) {
        Assert.notNull(from, (String)"Move from must not be null");
        Assert.notNull(to, (String)"Move to must not be null");
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.move(from.key, from.direction, to.key, to.direction, TimeoutUtils.toMillis(timeout.toMillis(), TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    @Nullable
    default public V move(K sourceKey, RedisListCommands.Direction from, K destinationKey, RedisListCommands.Direction to, Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.move(sourceKey, from, destinationKey, to, TimeoutUtils.toMillis(timeout.toMillis(), TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    @Nullable
    public V move(K var1, RedisListCommands.Direction var2, K var3, RedisListCommands.Direction var4, long var5, TimeUnit var7);

    public void set(K var1, long var2, V var4);

    @Nullable
    public Long remove(K var1, long var2, Object var4);

    @Nullable
    default public V getFirst(K key) {
        return this.index(key, 0L);
    }

    @Nullable
    default public V getLast(K key) {
        return this.index(key, -1L);
    }

    @Nullable
    public V index(K var1, long var2);

    @Nullable
    public Long indexOf(K var1, V var2);

    @Nullable
    public Long lastIndexOf(K var1, V var2);

    @Nullable
    public V leftPop(K var1);

    @Nullable
    public List<V> leftPop(K var1, long var2);

    @Nullable
    public V leftPop(K var1, long var2, TimeUnit var4);

    @Nullable
    default public V leftPop(K key, Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.leftPop(key, TimeoutUtils.toSeconds(timeout), TimeUnit.SECONDS);
    }

    @Nullable
    public V rightPop(K var1);

    @Nullable
    public List<V> rightPop(K var1, long var2);

    @Nullable
    public V rightPop(K var1, long var2, TimeUnit var4);

    @Nullable
    default public V rightPop(K key, Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.rightPop(key, TimeoutUtils.toSeconds(timeout), TimeUnit.SECONDS);
    }

    @Nullable
    public V rightPopAndLeftPush(K var1, K var2);

    @Nullable
    public V rightPopAndLeftPush(K var1, K var2, long var3, TimeUnit var5);

    @Nullable
    default public V rightPopAndLeftPush(K sourceKey, K destinationKey, Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.rightPopAndLeftPush(sourceKey, destinationKey, TimeoutUtils.toSeconds(timeout), TimeUnit.SECONDS);
    }

    public RedisOperations<K, V> getOperations();

    public static class MoveFrom<K> {
        final K key;
        final RedisListCommands.Direction direction;

        MoveFrom(K key, RedisListCommands.Direction direction) {
            this.key = key;
            this.direction = direction;
        }

        public static <K> MoveFrom<K> fromHead(K key) {
            return new MoveFrom<K>(key, RedisListCommands.Direction.first());
        }

        public static <K> MoveFrom<K> fromTail(K key) {
            return new MoveFrom<K>(key, RedisListCommands.Direction.last());
        }
    }

    public static class MoveTo<K> {
        final K key;
        final RedisListCommands.Direction direction;

        MoveTo(K key, RedisListCommands.Direction direction) {
            this.key = key;
            this.direction = direction;
        }

        public static <K> MoveTo<K> toHead(K key) {
            return new MoveTo<K>(key, RedisListCommands.Direction.first());
        }

        public static <K> MoveTo<K> toTail(K key) {
            return new MoveTo<K>(key, RedisListCommands.Direction.last());
        }
    }
}

