/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Arrays;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.lang.Nullable;

public class DefaultTypedTuple<V>
implements ZSetOperations.TypedTuple<V> {
    @Nullable
    private final Double score;
    @Nullable
    private final V value;

    public DefaultTypedTuple(@Nullable V value, @Nullable Double score) {
        this.score = score;
        this.value = value;
    }

    @Override
    @Nullable
    public Double getScore() {
        return this.score;
    }

    @Override
    @Nullable
    public V getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.score == null ? 0 : this.score.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultTypedTuple)) {
            return false;
        }
        DefaultTypedTuple other = (DefaultTypedTuple)obj;
        if (this.score == null ? other.score != null : !this.score.equals(other.score)) {
            return false;
        }
        if (this.value == null) {
            if (other.value != null) {
                return false;
            }
        } else {
            V v = this.value;
            if (v instanceof byte[]) {
                byte[] bytes = (byte[])v;
                V v2 = other.value;
                if (!(v2 instanceof byte[])) {
                    return false;
                }
                byte[] otherBytes = (byte[])v2;
                return Arrays.equals(bytes, otherBytes);
            }
            if (!this.value.equals(other.value)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(Double o) {
        double thisScore = this.score == null ? 0.0 : this.score;
        double otherScore = o == null ? 0.0 : o;
        return Double.compare(thisScore, otherScore);
    }

    @Override
    public int compareTo(ZSetOperations.TypedTuple<V> o) {
        if (o == null) {
            return this.compareTo(0.0);
        }
        return this.compareTo(o.getScore());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [score=").append(this.score);
        sb.append(", value=").append(this.value);
        sb.append(']');
        return sb.toString();
    }
}

