/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.commands.HashPipelineBinaryCommands;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;

class JedisHashCommands
implements RedisHashCommands {
    private final JedisConnection connection;

    JedisHashCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.connection.invoke().from(Jedis::hset, HashPipelineBinaryCommands::hset, key, field, value).get(JedisConverters.longToBoolean());
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.connection.invoke().from(Jedis::hsetnx, HashPipelineBinaryCommands::hsetnx, key, field, value).get(JedisConverters.longToBoolean());
    }

    @Override
    public Long hDel(byte[] key, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)fields, (String)"Fields must not be null");
        return this.connection.invoke().just(Jedis::hdel, HashPipelineBinaryCommands::hdel, key, fields);
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Fields must not be null");
        return this.connection.invoke().just(Jedis::hexists, HashPipelineBinaryCommands::hexists, key, field);
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        return this.connection.invoke().just(Jedis::hget, HashPipelineBinaryCommands::hget, key, field);
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::hgetAll, HashPipelineBinaryCommands::hgetAll, key);
    }

    @Override
    @Nullable
    public byte[] hRandField(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::hrandfield, HashPipelineBinaryCommands::hrandfield, key);
    }

    @Override
    @Nullable
    public Map.Entry<byte[], byte[]> hRandFieldWithValues(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Map.Entry)this.connection.invoke().from(Jedis::hrandfieldWithValues, HashPipelineBinaryCommands::hrandfieldWithValues, key, 1L).get(mapEntryList -> mapEntryList.isEmpty() ? null : (Map.Entry)mapEntryList.get(0));
    }

    @Override
    @Nullable
    public List<byte[]> hRandField(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::hrandfield, HashPipelineBinaryCommands::hrandfield, key, count);
    }

    @Override
    @Nullable
    public List<Map.Entry<byte[], byte[]>> hRandFieldWithValues(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (List)this.connection.invoke().from(Jedis::hrandfieldWithValues, HashPipelineBinaryCommands::hrandfieldWithValues, key, count).get(mapEntryList -> {
            ArrayList convertedMapEntryList = new ArrayList(mapEntryList.size());
            mapEntryList.forEach(entry -> convertedMapEntryList.add(Converters.entryOf((byte[])entry.getKey(), (byte[])entry.getValue())));
            return convertedMapEntryList;
        });
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        return this.connection.invoke().just(Jedis::hincrBy, HashPipelineBinaryCommands::hincrBy, key, field, delta);
    }

    @Override
    public Double hIncrBy(byte[] key, byte[] field, double delta) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        return this.connection.invoke().just(Jedis::hincrByFloat, HashPipelineBinaryCommands::hincrByFloat, key, field, delta);
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::hkeys, HashPipelineBinaryCommands::hkeys, key);
    }

    @Override
    public Long hLen(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::hlen, HashPipelineBinaryCommands::hlen, key);
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)fields, (String)"Fields must not be null");
        return this.connection.invoke().just(Jedis::hmget, HashPipelineBinaryCommands::hmget, key, fields);
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> hashes) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(hashes, (String)"Hashes must not be null");
        this.connection.invokeStatus().just(Jedis::hmset, HashPipelineBinaryCommands::hmset, key, hashes);
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::hvals, HashPipelineBinaryCommands::hvals, key);
    }

    @Override
    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] key, ScanOptions options) {
        return this.hScan(key, 0L, options);
    }

    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] key, long cursorId, ScanOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return new KeyBoundCursor<Map.Entry<byte[], byte[]>>(key, cursorId, options){

            @Override
            protected ScanIteration<Map.Entry<byte[], byte[]>> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (JedisHashCommands.this.isQueueing() || JedisHashCommands.this.isPipelined()) {
                    throw new InvalidDataAccessApiUsageException("'HSCAN' cannot be called in pipeline / transaction mode");
                }
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = JedisHashCommands.this.connection.getJedis().hscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<Map.Entry<byte[], byte[]>>(Long.valueOf(result.getCursor()), result.getResult());
            }

            @Override
            protected void doClose() {
                JedisHashCommands.this.connection.close();
            }
        }.open();
    }

    @Override
    @Nullable
    public Long hStrLen(byte[] key, byte[] field) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        return this.connection.invoke().just(Jedis::hstrlen, HashPipelineBinaryCommands::hstrlen, key, field);
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }
}

