/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.function.Supplier;
import org.springframework.cache.support.NullValue;
import org.springframework.core.KotlinDetector;
import org.springframework.data.redis.serializer.JacksonObjectReader;
import org.springframework.data.redis.serializer.JacksonObjectWriter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class GenericJackson2JsonRedisSerializer
implements RedisSerializer<Object> {
    private final ObjectMapper mapper;
    private final JacksonObjectReader reader;
    private final JacksonObjectWriter writer;
    private final Lazy<Boolean> defaultTypingEnabled;
    private final TypeResolver typeResolver;

    public GenericJackson2JsonRedisSerializer() {
        this((String)null);
    }

    public GenericJackson2JsonRedisSerializer(@Nullable String classPropertyTypeName) {
        this(classPropertyTypeName, JacksonObjectReader.create(), JacksonObjectWriter.create());
    }

    public GenericJackson2JsonRedisSerializer(@Nullable String classPropertyTypeName, JacksonObjectReader reader, JacksonObjectWriter writer) {
        this(new ObjectMapper(), reader, writer, classPropertyTypeName);
        GenericJackson2JsonRedisSerializer.registerNullValueSerializer(this.mapper, classPropertyTypeName);
        TypeResolverBuilder typer = new TypeResolverBuilder(ObjectMapper.DefaultTyping.EVERYTHING, this.mapper.getPolymorphicTypeValidator());
        typer = typer.init(JsonTypeInfo.Id.CLASS, null);
        typer = typer.inclusion(JsonTypeInfo.As.PROPERTY);
        if (StringUtils.hasText((String)classPropertyTypeName)) {
            typer = typer.typeProperty(classPropertyTypeName);
        }
        this.mapper.setDefaultTyping((com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder)typer);
    }

    public GenericJackson2JsonRedisSerializer(ObjectMapper mapper) {
        this(mapper, JacksonObjectReader.create(), JacksonObjectWriter.create());
    }

    public GenericJackson2JsonRedisSerializer(ObjectMapper mapper, JacksonObjectReader reader, JacksonObjectWriter writer) {
        this(mapper, reader, writer, null);
    }

    private GenericJackson2JsonRedisSerializer(ObjectMapper mapper, JacksonObjectReader reader, JacksonObjectWriter writer, @Nullable String typeHintPropertyName) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null");
        Assert.notNull((Object)reader, (String)"Reader must not be null");
        Assert.notNull((Object)writer, (String)"Writer must not be null");
        this.mapper = mapper;
        this.reader = reader;
        this.writer = writer;
        this.defaultTypingEnabled = Lazy.of(() -> mapper.getSerializationConfig().getDefaultTyper(null) != null);
        Lazy typeHintPropertyNameSupplier = typeHintPropertyName == null ? Lazy.of(() -> {
            if (((Boolean)this.defaultTypingEnabled.get()).booleanValue()) {
                return null;
            }
            return mapper.getDeserializationConfig().getDefaultTyper(null).buildTypeDeserializer(mapper.getDeserializationConfig(), mapper.getTypeFactory().constructType(Object.class), Collections.emptyList()).getPropertyName();
        }).or((Object)"@class") : () -> typeHintPropertyName;
        this.typeResolver = new TypeResolver((Supplier<TypeFactory>)Lazy.of(() -> ((ObjectMapper)mapper).getTypeFactory()), (Supplier<String>)typeHintPropertyNameSupplier);
    }

    public static void registerNullValueSerializer(ObjectMapper objectMapper, @Nullable String classPropertyTypeName) {
        objectMapper.registerModule((Module)new SimpleModule().addSerializer((JsonSerializer)new NullValueSerializer(classPropertyTypeName)));
    }

    @Override
    public byte[] serialize(@Nullable Object source) throws SerializationException {
        if (source == null) {
            return SerializationUtils.EMPTY_ARRAY;
        }
        try {
            return this.writer.write(this.mapper, source);
        }
        catch (IOException e) {
            throw new SerializationException("Could not write JSON: " + e.getMessage(), e);
        }
    }

    @Override
    public Object deserialize(@Nullable byte[] source) throws SerializationException {
        return this.deserialize(source, Object.class);
    }

    @Nullable
    public <T> T deserialize(@Nullable byte[] source, Class<T> type) throws SerializationException {
        Assert.notNull(type, (String)"Deserialization type must not be null Please provide Object.class to make use of Jackson2 default typing.");
        if (SerializationUtils.isEmpty(source)) {
            return null;
        }
        try {
            return (T)this.reader.read(this.mapper, source, this.resolveType(source, type));
        }
        catch (Exception ex) {
            throw new SerializationException("Could not read JSON: " + ex.getMessage(), ex);
        }
    }

    protected JavaType resolveType(byte[] source, Class<?> type) throws IOException {
        if (!type.equals(Object.class) || !((Boolean)this.defaultTypingEnabled.get()).booleanValue()) {
            return this.typeResolver.constructType(type);
        }
        return this.typeResolver.resolveType(source, type);
    }

    private static class TypeResolverBuilder
    extends ObjectMapper.DefaultTypeResolverBuilder {
        public TypeResolverBuilder(ObjectMapper.DefaultTyping t, PolymorphicTypeValidator ptv) {
            super(t, ptv);
        }

        public ObjectMapper.DefaultTypeResolverBuilder withDefaultImpl(Class<?> defaultImpl) {
            return this;
        }

        public boolean useForType(JavaType t) {
            if (t.isJavaLangObject()) {
                return true;
            }
            if ((t = this.resolveArrayOrWrapper(t)).isEnumType() || ClassUtils.isPrimitiveOrWrapper((Class)t.getRawClass())) {
                return false;
            }
            if (t.isFinal() && !KotlinDetector.isKotlinType((Class)t.getRawClass()) && t.getRawClass().getPackageName().startsWith("java")) {
                return false;
            }
            return !TreeNode.class.isAssignableFrom(t.getRawClass());
        }

        private JavaType resolveArrayOrWrapper(JavaType type) {
            while (type.isArrayType()) {
                if (!(type = type.getContentType()).isReferenceType()) continue;
                type = this.resolveArrayOrWrapper(type);
            }
            while (type.isReferenceType()) {
                if (!(type = type.getReferencedType()).isArrayType()) continue;
                type = this.resolveArrayOrWrapper(type);
            }
            return type;
        }
    }

    static class TypeResolver {
        private final ObjectMapper mapper = new ObjectMapper();
        private final Supplier<TypeFactory> typeFactory;
        private final Supplier<String> hintName;

        TypeResolver(Supplier<TypeFactory> typeFactory, Supplier<String> hintName) {
            this.typeFactory = typeFactory;
            this.hintName = hintName;
        }

        protected JavaType constructType(Class<?> type) {
            return this.typeFactory.get().constructType(type);
        }

        protected JavaType resolveType(byte[] source, Class<?> type) throws IOException {
            JsonNode root = this.mapper.readTree(source);
            JsonNode jsonNode = root.get(this.hintName.get());
            if (jsonNode instanceof TextNode && jsonNode.asText() != null) {
                return this.typeFactory.get().constructFromCanonical(jsonNode.asText());
            }
            return this.constructType(type);
        }
    }

    private static class NullValueSerializer
    extends StdSerializer<NullValue> {
        private static final long serialVersionUID = 1999052150548658808L;
        private final String classIdentifier;

        NullValueSerializer(@Nullable String classIdentifier) {
            super(NullValue.class);
            this.classIdentifier = StringUtils.hasText((String)classIdentifier) ? classIdentifier : "@class";
        }

        public void serialize(NullValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeStringField(this.classIdentifier, NullValue.class.getName());
            jgen.writeEndObject();
        }

        public void serializeWithType(NullValue value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            this.serialize(value, gen, serializers);
        }
    }
}

