/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.KeyValue;
import io.lettuce.core.LPosArgs;
import io.lettuce.core.api.async.RedisListAsyncCommands;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class LettuceListCommands
implements RedisListCommands {
    private final LettuceConnection connection;

    LettuceListCommands(LettuceConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long rPush(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (Long)this.connection.invoke().just(RedisListAsyncCommands::rpush, key, values);
    }

    @Override
    public List<Long> lPos(byte[] key, byte[] element, @Nullable Integer rank, @Nullable Integer count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)element, (String)"Element must not be null!");
        LPosArgs args = new LPosArgs();
        if (rank != null) {
            args.rank((long)rank.intValue());
        }
        if (count != null) {
            return (List)this.connection.invoke().just(RedisListAsyncCommands::lpos, key, element, count, args);
        }
        return this.connection.invoke().from(RedisListAsyncCommands::lpos, key, element, args).getOrElse(Collections::singletonList, Collections::emptyList);
    }

    @Override
    public Long lPush(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)values, (String)"Values must not be null!");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements!");
        return (Long)this.connection.invoke().just(RedisListAsyncCommands::lpush, key, values);
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return (Long)this.connection.invoke().just((rec$, x$0, xva$1) -> rec$.rpushx(x$0, (Object[])new byte[][]{xva$1}), key, value);
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return (Long)this.connection.invoke().just((rec$, x$0, xva$1) -> rec$.lpushx(x$0, (Object[])new byte[][]{xva$1}), key, value);
    }

    @Override
    public Long lLen(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (Long)this.connection.invoke().just(RedisListAsyncCommands::llen, key);
    }

    @Override
    public List<byte[]> lRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (List)this.connection.invoke().just(RedisListAsyncCommands::lrange, key, start, end);
    }

    @Override
    public void lTrim(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        this.connection.invokeStatus().just(RedisListAsyncCommands::ltrim, key, start, end);
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (byte[])this.connection.invoke().just(RedisListAsyncCommands::lindex, key, index);
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (Long)this.connection.invoke().just(RedisListAsyncCommands::linsert, key, LettuceConverters.toBoolean(where), pivot, value);
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        this.connection.invokeStatus().just(RedisListAsyncCommands::lset, key, index, value);
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return (Long)this.connection.invoke().just(RedisListAsyncCommands::lrem, key, count, value);
    }

    @Override
    public byte[] lPop(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (byte[])this.connection.invoke().just(RedisListAsyncCommands::lpop, key);
    }

    @Override
    public byte[] rPop(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (byte[])this.connection.invoke().just(RedisListAsyncCommands::rpop, key);
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Key must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        return (List)this.connection.invoke(this.connection.getAsyncDedicatedConnection()).from(RedisListAsyncCommands::blpop, timeout, keys).get(LettuceListCommands::toBytesList);
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Key must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        return (List)this.connection.invoke(this.connection.getAsyncDedicatedConnection()).from(RedisListAsyncCommands::brpop, timeout, keys).get(LettuceListCommands::toBytesList);
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        Assert.notNull((Object)srcKey, (String)"Source key must not be null!");
        Assert.notNull((Object)dstKey, (String)"Destination key must not be null!");
        return (byte[])this.connection.invoke().just(RedisListAsyncCommands::rpoplpush, srcKey, dstKey);
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        Assert.notNull((Object)srcKey, (String)"Source key must not be null!");
        Assert.notNull((Object)dstKey, (String)"Destination key must not be null!");
        return (byte[])this.connection.invoke(this.connection.getAsyncDedicatedConnection()).just(RedisListAsyncCommands::brpoplpush, timeout, srcKey, dstKey);
    }

    private static List<byte[]> toBytesList(KeyValue<byte[], byte[]> source) {
        ArrayList<byte[]> list = new ArrayList<byte[]>(2);
        list.add((byte[])source.getKey());
        list.add((byte[])source.getValue());
        return list;
    }
}

