/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public interface RedisZSetCommands {
    @Nullable
    default public Boolean zAdd(byte[] key, double score, byte[] value) {
        return this.zAdd(key, score, value, ZAddArgs.NONE);
    }

    @Nullable
    public Boolean zAdd(byte[] var1, double var2, byte[] var4, ZAddArgs var5);

    @Nullable
    default public Long zAdd(byte[] key, Set<Tuple> tuples) {
        return this.zAdd(key, tuples, ZAddArgs.NONE);
    }

    public Long zAdd(byte[] var1, Set<Tuple> var2, ZAddArgs var3);

    @Nullable
    public Long zRem(byte[] var1, byte[] ... var2);

    @Nullable
    public Double zIncrBy(byte[] var1, double var2, byte[] var4);

    @Nullable
    public Long zRank(byte[] var1, byte[] var2);

    @Nullable
    public Long zRevRank(byte[] var1, byte[] var2);

    @Nullable
    public Set<byte[]> zRange(byte[] var1, long var2, long var4);

    @Nullable
    public Set<Tuple> zRangeWithScores(byte[] var1, long var2, long var4);

    @Nullable
    default public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        return this.zRangeByScore(key, new Range().gte(min).lte(max));
    }

    @Nullable
    default public Set<Tuple> zRangeByScoreWithScores(byte[] key, Range range) {
        return this.zRangeByScoreWithScores(key, range, Limit.unlimited());
    }

    @Nullable
    default public Set<Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        return this.zRangeByScoreWithScores(key, new Range().gte(min).lte(max));
    }

    @Nullable
    default public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        return this.zRangeByScore(key, new Range().gte(min).lte(max), new Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    @Nullable
    default public Set<Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        return this.zRangeByScoreWithScores(key, new Range().gte(min).lte(max), new Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    @Nullable
    public Set<Tuple> zRangeByScoreWithScores(byte[] var1, Range var2, Limit var3);

    @Nullable
    public Set<byte[]> zRevRange(byte[] var1, long var2, long var4);

    @Nullable
    public Set<Tuple> zRevRangeWithScores(byte[] var1, long var2, long var4);

    @Nullable
    default public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        return this.zRevRangeByScore(key, new Range().gte(min).lte(max));
    }

    @Nullable
    default public Set<byte[]> zRevRangeByScore(byte[] key, Range range) {
        return this.zRevRangeByScore(key, range, Limit.unlimited());
    }

    @Nullable
    default public Set<Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        return this.zRevRangeByScoreWithScores(key, new Range().gte(min).lte(max), Limit.unlimited());
    }

    @Nullable
    default public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        return this.zRevRangeByScore(key, new Range().gte(min).lte(max), new Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    @Nullable
    public Set<byte[]> zRevRangeByScore(byte[] var1, Range var2, Limit var3);

    @Nullable
    default public Set<Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        return this.zRevRangeByScoreWithScores(key, new Range().gte(min).lte(max), new Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    @Nullable
    default public Set<Tuple> zRevRangeByScoreWithScores(byte[] key, Range range) {
        return this.zRevRangeByScoreWithScores(key, range, Limit.unlimited());
    }

    @Nullable
    public Set<Tuple> zRevRangeByScoreWithScores(byte[] var1, Range var2, Limit var3);

    @Nullable
    default public Long zCount(byte[] key, double min, double max) {
        return this.zCount(key, new Range().gte(min).lte(max));
    }

    @Nullable
    public Long zCount(byte[] var1, Range var2);

    @Nullable
    public Long zLexCount(byte[] var1, Range var2);

    @Nullable
    public Long zCard(byte[] var1);

    @Nullable
    public Double zScore(byte[] var1, byte[] var2);

    @Nullable
    public Long zRemRange(byte[] var1, long var2, long var4);

    public Long zRemRangeByLex(byte[] var1, Range var2);

    @Nullable
    default public Long zRemRangeByScore(byte[] key, double min, double max) {
        return this.zRemRangeByScore(key, new Range().gte(min).lte(max));
    }

    @Nullable
    public Long zRemRangeByScore(byte[] var1, Range var2);

    @Nullable
    public Long zUnionStore(byte[] var1, byte[] ... var2);

    @Nullable
    default public Long zUnionStore(byte[] destKey, Aggregate aggregate, int[] weights, byte[] ... sets) {
        return this.zUnionStore(destKey, aggregate, Weights.of(weights), sets);
    }

    @Nullable
    public Long zUnionStore(byte[] var1, Aggregate var2, Weights var3, byte[] ... var4);

    @Nullable
    public Long zInterStore(byte[] var1, byte[] ... var2);

    @Nullable
    default public Long zInterStore(byte[] destKey, Aggregate aggregate, int[] weights, byte[] ... sets) {
        return this.zInterStore(destKey, aggregate, Weights.of(weights), sets);
    }

    @Nullable
    public Long zInterStore(byte[] var1, Aggregate var2, Weights var3, byte[] ... var4);

    public Cursor<Tuple> zScan(byte[] var1, ScanOptions var2);

    @Nullable
    default public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        return this.zRangeByScore(key, new Range().gte(min).lte(max));
    }

    @Nullable
    default public Set<byte[]> zRangeByScore(byte[] key, Range range) {
        return this.zRangeByScore(key, range, Limit.unlimited());
    }

    @Nullable
    public Set<byte[]> zRangeByScore(byte[] var1, String var2, String var3, long var4, long var6);

    @Nullable
    public Set<byte[]> zRangeByScore(byte[] var1, Range var2, Limit var3);

    @Nullable
    default public Set<byte[]> zRangeByLex(byte[] key) {
        return this.zRangeByLex(key, Range.unbounded());
    }

    @Nullable
    default public Set<byte[]> zRangeByLex(byte[] key, Range range) {
        return this.zRangeByLex(key, range, Limit.unlimited());
    }

    @Nullable
    public Set<byte[]> zRangeByLex(byte[] var1, Range var2, Limit var3);

    @Nullable
    default public Set<byte[]> zRevRangeByLex(byte[] key) {
        return this.zRevRangeByLex(key, Range.unbounded());
    }

    @Nullable
    default public Set<byte[]> zRevRangeByLex(byte[] key, Range range) {
        return this.zRevRangeByLex(key, range, Limit.unlimited());
    }

    @Nullable
    public Set<byte[]> zRevRangeByLex(byte[] var1, Range var2, Limit var3);

    public static class ZAddArgs {
        private static final ZAddArgs NONE = new ZAddArgs(EnumSet.noneOf(Flag.class));
        private final Set<Flag> flags;

        private ZAddArgs(Set<Flag> flags) {
            this.flags = flags;
        }

        public static ZAddArgs empty() {
            return new ZAddArgs(EnumSet.noneOf(Flag.class));
        }

        public static ZAddArgs ifNotExists() {
            return ZAddArgs.empty().nx();
        }

        public static ZAddArgs ifExists() {
            return ZAddArgs.empty().xx();
        }

        public ZAddArgs nx() {
            this.flags.add(Flag.NX);
            return this;
        }

        public ZAddArgs xx() {
            this.flags.add(Flag.XX);
            return this;
        }

        public ZAddArgs lt() {
            this.flags.add(Flag.LT);
            return this;
        }

        public ZAddArgs gt() {
            this.flags.add(Flag.GT);
            return this;
        }

        public ZAddArgs ch() {
            this.flags.add(Flag.CH);
            return this;
        }

        public boolean contains(Flag flag) {
            return this.flags.contains((Object)flag);
        }

        public boolean isEmpty() {
            return !this.flags.isEmpty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ZAddArgs zAddArgs = (ZAddArgs)o;
            return ObjectUtils.nullSafeEquals(this.flags, zAddArgs.flags);
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode(this.flags);
        }

        public static enum Flag {
            XX,
            NX,
            GT,
            LT,
            CH;

        }
    }

    public static class Limit {
        private static final Limit UNLIMITED = new Limit(){

            @Override
            public int getCount() {
                return -1;
            }

            @Override
            public int getOffset() {
                return super.getOffset();
            }
        };
        int offset;
        int count;

        public static Limit limit() {
            return new Limit();
        }

        public Limit offset(int offset) {
            this.offset = offset;
            return this;
        }

        public Limit count(int count) {
            this.count = count;
            return this;
        }

        public int getCount() {
            return this.count;
        }

        public int getOffset() {
            return this.offset;
        }

        public boolean isUnlimited() {
            return this.equals(UNLIMITED);
        }

        public static Limit unlimited() {
            return UNLIMITED;
        }
    }

    public static class Range {
        @Nullable
        Boundary min;
        @Nullable
        Boundary max;

        public static Range range() {
            return new Range();
        }

        public static Range unbounded() {
            Range range = new Range();
            range.min = Boundary.infinite();
            range.max = Boundary.infinite();
            return range;
        }

        public Range gte(Object min) {
            Assert.notNull((Object)min, (String)"Min already set for range.");
            this.min = new Boundary(min, true);
            return this;
        }

        public Range gt(Object min) {
            Assert.notNull((Object)min, (String)"Min already set for range.");
            this.min = new Boundary(min, false);
            return this;
        }

        public Range lte(Object max) {
            Assert.notNull((Object)max, (String)"Max already set for range.");
            this.max = new Boundary(max, true);
            return this;
        }

        public Range lt(Object max) {
            Assert.notNull((Object)max, (String)"Max already set for range.");
            this.max = new Boundary(max, false);
            return this;
        }

        @Nullable
        public Boundary getMin() {
            return this.min;
        }

        @Nullable
        public Boundary getMax() {
            return this.max;
        }

        public static class Boundary {
            @Nullable
            Object value;
            boolean including;

            static Boundary infinite() {
                return new Boundary(null, true);
            }

            Boundary(@Nullable Object value, boolean including) {
                this.value = value;
                this.including = including;
            }

            @Nullable
            public Object getValue() {
                return this.value;
            }

            public boolean isIncluding() {
                return this.including;
            }
        }
    }

    public static interface Tuple
    extends Comparable<Double> {
        public byte[] getValue();

        public Double getScore();
    }

    public static class Weights {
        private final List<Double> weights;

        private Weights(List<Double> weights) {
            this.weights = weights;
        }

        public static Weights of(int ... weights) {
            Assert.notNull((Object)weights, (String)"Weights must not be null!");
            return new Weights(Arrays.stream(weights).mapToDouble(value -> value).boxed().collect(Collectors.toList()));
        }

        public static Weights of(double ... weights) {
            Assert.notNull((Object)weights, (String)"Weights must not be null!");
            return new Weights(DoubleStream.of(weights).boxed().collect(Collectors.toList()));
        }

        public static Weights fromSetCount(int count) {
            Assert.isTrue((count >= 0 ? 1 : 0) != 0, (String)"Count of input sorted sets must be greater or equal to zero!");
            return new Weights(IntStream.range(0, count).mapToDouble(value -> 1.0).boxed().collect(Collectors.toList()));
        }

        public Weights multiply(int multiplier) {
            return this.apply(it -> it * (double)multiplier);
        }

        public Weights multiply(double multiplier) {
            return this.apply(it -> it * multiplier);
        }

        public Weights apply(Function<Double, Double> operator) {
            return new Weights(this.weights.stream().map(operator).collect(Collectors.toList()));
        }

        public double getWeight(int index) {
            return this.weights.get(index);
        }

        public int size() {
            return this.weights.size();
        }

        public double[] toArray() {
            return this.weights.stream().mapToDouble(Double::doubleValue).toArray();
        }

        public List<Double> toList() {
            return Collections.unmodifiableList(this.weights);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Weights)) {
                return false;
            }
            Weights that = (Weights)o;
            return ObjectUtils.nullSafeEquals(this.weights, that.weights);
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode(this.weights);
        }
    }

    public static enum Aggregate {
        SUM,
        MIN,
        MAX;

    }
}

