/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RedisPassword {
    private static final RedisPassword NONE = new RedisPassword(new char[0]);
    private final char[] thePassword;

    private RedisPassword(char[] thePassword) {
        this.thePassword = thePassword;
    }

    public static RedisPassword of(@Nullable String passwordAsString) {
        return Optional.ofNullable(passwordAsString).filter(StringUtils::hasText).map((? super T it) -> new RedisPassword(it.toCharArray())).orElseGet(RedisPassword::none);
    }

    public static RedisPassword of(@Nullable char[] passwordAsChars) {
        return Optional.ofNullable(passwordAsChars).filter(it -> !ObjectUtils.isEmpty((Object)passwordAsChars)).map((? super T it) -> new RedisPassword(Arrays.copyOf(it, ((char[])it).length))).orElseGet(RedisPassword::none);
    }

    public static RedisPassword none() {
        return NONE;
    }

    public boolean isPresent() {
        return !ObjectUtils.isEmpty((Object)this.thePassword);
    }

    public char[] get() throws NoSuchElementException {
        if (this.isPresent()) {
            return Arrays.copyOf(this.thePassword, this.thePassword.length);
        }
        throw new NoSuchElementException("No password present.");
    }

    public <R> Optional<R> map(Function<char[], R> mapper) {
        Assert.notNull(mapper, (String)"Mapper function must not be null!");
        return this.toOptional().map(mapper);
    }

    public Optional<char[]> toOptional() {
        if (this.isPresent()) {
            return Optional.of(this.get());
        }
        return Optional.empty();
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.isPresent() ? "*****" : "<none>");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisPassword password = (RedisPassword)o;
        return ObjectUtils.nullSafeEquals((Object)this.thePassword, (Object)password.thePassword);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((char[])this.thePassword);
    }
}

