/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import java.util.Map;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ObjectRecord;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface Record<S, V> {
    @Nullable
    public S getStream();

    public RecordId getId();

    public V getValue();

    public static <S, K, V> MapRecord<S, K, V> of(Map<K, V> map) {
        Assert.notNull(map, (String)"Map must not be null!");
        return StreamRecords.mapBacked(map);
    }

    public static <S, V> ObjectRecord<S, V> of(V value) {
        Assert.notNull(value, (String)"Value must not be null!");
        return StreamRecords.objectBacked(value);
    }

    public Record<S, V> withId(RecordId var1);

    public <SK> Record<SK, V> withStreamKey(SK var1);
}

