/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisScriptingCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceResult;
import org.springframework.util.Assert;

class LettuceScriptingCommands
implements RedisScriptingCommands {
    private final LettuceConnection connection;

    LettuceScriptingCommands(LettuceConnection connection) {
        this.connection = connection;
    }

    @Override
    public void scriptFlush() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult(this.getAsyncConnection().scriptFlush()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceStatusResult(this.getAsyncConnection().scriptFlush()));
                return;
            }
            this.getConnection().scriptFlush();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void scriptKill() {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException("Script kill not permitted in a transaction");
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult(this.getAsyncConnection().scriptKill()));
                return;
            }
            this.getConnection().scriptKill();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public String scriptLoad(byte[] script) {
        Assert.notNull((Object)script, (String)"Script must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().scriptLoad(script)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().scriptLoad(script)));
                return null;
            }
            return this.getConnection().scriptLoad(script);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<Boolean> scriptExists(String ... scriptSha1) {
        Assert.notNull((Object)scriptSha1, (String)"Script digests must not be null!");
        Assert.noNullElements((Object[])scriptSha1, (String)"Script digests must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().scriptExists(scriptSha1)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().scriptExists(scriptSha1)));
                return null;
            }
            return this.getConnection().scriptExists(scriptSha1);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public <T> T eval(byte[] script, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        Assert.notNull((Object)script, (String)"Script must not be null!");
        try {
            byte[][] keys = LettuceScriptingCommands.extractScriptKeys(numKeys, keysAndArgs);
            byte[][] args = LettuceScriptingCommands.extractScriptArgs(numKeys, keysAndArgs);
            String convertedScript = LettuceConverters.toString(script);
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().eval(convertedScript, LettuceConverters.toScriptOutputType(returnType), (Object[])keys, (Object[])args), new LettuceEvalResultsConverter(returnType)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().eval(convertedScript, LettuceConverters.toScriptOutputType(returnType), (Object[])keys, (Object[])args), new LettuceEvalResultsConverter(returnType)));
                return null;
            }
            return new LettuceEvalResultsConverter(returnType).convert(this.getConnection().eval(convertedScript, LettuceConverters.toScriptOutputType(returnType), (Object[])keys, (Object[])args));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public <T> T evalSha(String scriptSha1, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        Assert.notNull((Object)scriptSha1, (String)"Script digest must not be null!");
        try {
            byte[][] keys = LettuceScriptingCommands.extractScriptKeys(numKeys, keysAndArgs);
            byte[][] args = LettuceScriptingCommands.extractScriptArgs(numKeys, keysAndArgs);
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().evalsha(scriptSha1, LettuceConverters.toScriptOutputType(returnType), (Object[])keys, (Object[])args), new LettuceEvalResultsConverter(returnType)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().evalsha(scriptSha1, LettuceConverters.toScriptOutputType(returnType), (Object[])keys, (Object[])args), new LettuceEvalResultsConverter(returnType)));
                return null;
            }
            return new LettuceEvalResultsConverter(returnType).convert(this.getConnection().evalsha(scriptSha1, LettuceConverters.toScriptOutputType(returnType), (Object[])keys, (Object[])args));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public <T> T evalSha(byte[] scriptSha1, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        Assert.notNull((Object)scriptSha1, (String)"Script digest must not be null!");
        return this.evalSha(LettuceConverters.toString(scriptSha1), returnType, numKeys, keysAndArgs);
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void pipeline(LettuceResult result) {
        this.connection.pipeline(result);
    }

    private void transaction(LettuceResult result) {
        this.connection.transaction(result);
    }

    private RedisClusterAsyncCommands<byte[], byte[]> getAsyncConnection() {
        return this.connection.getAsyncConnection();
    }

    public RedisClusterCommands<byte[], byte[]> getConnection() {
        return this.connection.getConnection();
    }

    private DataAccessException convertLettuceAccessException(Exception ex) {
        return this.connection.convertLettuceAccessException(ex);
    }

    private static byte[][] extractScriptKeys(int numKeys, byte[] ... keysAndArgs) {
        if (numKeys > 0) {
            return (byte[][])Arrays.copyOfRange(keysAndArgs, 0, numKeys);
        }
        return new byte[0][0];
    }

    private static byte[][] extractScriptArgs(int numKeys, byte[] ... keysAndArgs) {
        if (keysAndArgs.length > numKeys) {
            return (byte[][])Arrays.copyOfRange(keysAndArgs, numKeys, keysAndArgs.length);
        }
        return new byte[0][0];
    }

    private class LettuceEvalResultsConverter<T>
    implements Converter<Object, T> {
        private ReturnType returnType;

        public LettuceEvalResultsConverter(ReturnType returnType) {
            this.returnType = returnType;
        }

        public T convert(Object source) {
            if (this.returnType == ReturnType.MULTI) {
                List resultList = (List)source;
                for (Object obj : resultList) {
                    if (!(obj instanceof Exception)) continue;
                    throw LettuceScriptingCommands.this.convertLettuceAccessException((Exception)obj);
                }
            }
            return (T)source;
        }
    }
}

