/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RedisSocketConfiguration
implements RedisConfiguration,
RedisConfiguration.DomainSocketConfiguration {
    private static final String DEFAULT_SOCKET = "/tmp/redis.sock";
    private String socket = "/tmp/redis.sock";
    private int database;
    @Nullable
    private String username = null;
    private RedisPassword password = RedisPassword.none();

    public RedisSocketConfiguration() {
    }

    public RedisSocketConfiguration(String socket) {
        Assert.hasText((String)socket, (String)"Socket path must not be null nor empty!");
        this.socket = socket;
    }

    @Override
    public String getSocket() {
        return this.socket;
    }

    @Override
    public void setSocket(String socket) {
        Assert.hasText((String)socket, (String)"Socket must not be null nor empty!");
        this.socket = socket;
    }

    @Override
    public int getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, () -> String.format("Invalid DB index '%s' (a positive index required)", index));
        this.database = index;
    }

    @Override
    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    @Override
    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Override
    public RedisPassword getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(RedisPassword password) {
        Assert.notNull((Object)password, (String)"RedisPassword must not be null!");
        this.password = password;
    }
}

