/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.support;

import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.core.R2dbcEntityOperations;
import org.springframework.data.r2dbc.core.R2dbcEntityTemplate;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.repository.query.PartTreeR2dbcQuery;
import org.springframework.data.r2dbc.repository.query.R2dbcQueryMethod;
import org.springframework.data.r2dbc.repository.query.StringBasedR2dbcQuery;
import org.springframework.data.r2dbc.repository.support.CachingExpressionParser;
import org.springframework.data.r2dbc.repository.support.SimpleR2dbcRepository;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.repository.query.RelationalEntityInformation;
import org.springframework.data.relational.repository.support.MappingRelationalEntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.ReactiveRepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ReactiveQueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.util.Assert;

public class R2dbcRepositoryFactory
extends ReactiveRepositoryFactorySupport {
    private static final SpelExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private final DatabaseClient databaseClient;
    private final ReactiveDataAccessStrategy dataAccessStrategy;
    private final MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext;
    private final R2dbcConverter converter;
    private final R2dbcEntityOperations operations;

    public R2dbcRepositoryFactory(DatabaseClient databaseClient, ReactiveDataAccessStrategy dataAccessStrategy) {
        Assert.notNull((Object)databaseClient, (String)"DatabaseClient must not be null");
        Assert.notNull((Object)dataAccessStrategy, (String)"ReactiveDataAccessStrategy must not be null");
        this.databaseClient = databaseClient;
        this.dataAccessStrategy = dataAccessStrategy;
        this.converter = dataAccessStrategy.getConverter();
        this.mappingContext = this.converter.getMappingContext();
        this.operations = new R2dbcEntityTemplate(this.databaseClient, this.dataAccessStrategy);
        this.setEvaluationContextProvider((QueryMethodEvaluationContextProvider)ReactiveQueryMethodEvaluationContextProvider.DEFAULT);
    }

    public R2dbcRepositoryFactory(R2dbcEntityOperations operations) {
        Assert.notNull((Object)operations, (String)"R2dbcEntityOperations must not be null");
        this.databaseClient = operations.getDatabaseClient();
        this.dataAccessStrategy = operations.getDataAccessStrategy();
        this.converter = this.dataAccessStrategy.getConverter();
        this.mappingContext = this.converter.getMappingContext();
        this.operations = operations;
        this.setEvaluationContextProvider((QueryMethodEvaluationContextProvider)ReactiveQueryMethodEvaluationContextProvider.DEFAULT);
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleR2dbcRepository.class;
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        RelationalEntityInformation entityInformation = this.getEntityInformation(information.getDomainType(), information);
        return this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.operations, this.converter});
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new R2dbcQueryLookupStrategy(this.operations, (ReactiveQueryMethodEvaluationContextProvider)evaluationContextProvider, this.converter, this.dataAccessStrategy));
    }

    public <T, ID> RelationalEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return this.getEntityInformation(domainClass, null);
    }

    private <T, ID> RelationalEntityInformation<T, ID> getEntityInformation(Class<T> domainClass, @Nullable RepositoryInformation information) {
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
        return new MappingRelationalEntityInformation(entity);
    }

    private static class R2dbcQueryLookupStrategy
    implements QueryLookupStrategy {
        private final R2dbcEntityOperations entityOperations;
        private final ReactiveQueryMethodEvaluationContextProvider evaluationContextProvider;
        private final R2dbcConverter converter;
        private final ReactiveDataAccessStrategy dataAccessStrategy;
        private final ExpressionParser parser = new CachingExpressionParser((ExpressionParser)EXPRESSION_PARSER);

        R2dbcQueryLookupStrategy(R2dbcEntityOperations entityOperations, ReactiveQueryMethodEvaluationContextProvider evaluationContextProvider, R2dbcConverter converter, ReactiveDataAccessStrategy dataAccessStrategy) {
            this.entityOperations = entityOperations;
            this.evaluationContextProvider = evaluationContextProvider;
            this.converter = converter;
            this.dataAccessStrategy = dataAccessStrategy;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            R2dbcQueryMethod queryMethod = new R2dbcQueryMethod(method, metadata, factory, this.converter.getMappingContext());
            String namedQueryName = queryMethod.getNamedQueryName();
            if (namedQueries.hasQuery(namedQueryName)) {
                String namedQuery = namedQueries.getQuery(namedQueryName);
                return new StringBasedR2dbcQuery(namedQuery, queryMethod, this.entityOperations, this.converter, this.dataAccessStrategy, this.parser, this.evaluationContextProvider);
            }
            if (queryMethod.hasAnnotatedQuery()) {
                return new StringBasedR2dbcQuery(queryMethod, this.entityOperations, this.converter, this.dataAccessStrategy, this.parser, this.evaluationContextProvider);
            }
            return new PartTreeR2dbcQuery(queryMethod, this.entityOperations, this.converter, this.dataAccessStrategy);
        }
    }
}

