/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import org.springframework.data.r2dbc.repository.query.R2dbcSpELExpressionEvaluator;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.r2dbc.core.Parameter;

class DefaultR2dbcSpELExpressionEvaluator
implements R2dbcSpELExpressionEvaluator {
    private final ExpressionParser parser;
    private final EvaluationContext context;

    DefaultR2dbcSpELExpressionEvaluator(ExpressionParser parser, EvaluationContext context) {
        this.parser = parser;
        this.context = context;
    }

    public static R2dbcSpELExpressionEvaluator unsupported() {
        return NoOpExpressionEvaluator.INSTANCE;
    }

    @Override
    public Parameter evaluate(String expression) {
        Expression expr = this.parser.parseExpression(expression);
        Object value = expr.getValue(this.context, Object.class);
        Class<Object> valueType = expr.getValueType(this.context);
        return Parameter.fromOrEmpty((Object)value, valueType != null ? valueType : Object.class);
    }

    static enum NoOpExpressionEvaluator implements R2dbcSpELExpressionEvaluator
    {
        INSTANCE;


        @Override
        public Parameter evaluate(String expression) {
            throw new UnsupportedOperationException("Expression evaluation not supported");
        }
    }
}

