/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Formattable;
import java.util.Formatter;
import java.util.Locale;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.neo4j.driver.types.MapAccessor;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;

@API(status=API.Status.INTERNAL, since="6.0.2")
public final class NoRootNodeMappingException
extends MappingException
implements Formattable {
    private static final long serialVersionUID = 5742846435191601546L;
    private final transient @Nullable MapAccessor mapAccessor;
    private final transient @Nullable Neo4jPersistentEntity<?> entity;

    public NoRootNodeMappingException(MapAccessor mapAccessor, Neo4jPersistentEntity<?> entity) {
        super(String.format("Could not find mappable nodes or relationships inside %s for %s", mapAccessor, entity));
        this.mapAccessor = mapAccessor;
        this.entity = entity;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        if (this.mapAccessor != null && this.entity != null) {
            String className = this.entity.getUnderlyingClass().getSimpleName();
            formatter.format("Could not find mappable nodes or relationships inside %s for %s:%s", this.mapAccessor, className.substring(0, 1).toLowerCase(Locale.ROOT), String.join((CharSequence)":", this.entity.getStaticLabels()));
        } else {
            formatter.format("Could not find mappable nodes or relationships inside a record", new Object[0]);
        }
    }
}

