/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Collection;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.neo4j.core.convert.Neo4jConversionService;
import org.springframework.data.neo4j.core.convert.Neo4jConversions;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverter;
import org.springframework.data.neo4j.core.mapping.NullSafeNeo4jPersistentPropertyConverter;

final class DefaultNeo4jConversionService
implements Neo4jConversionService {
    private final ConversionService conversionService;
    private final Predicate<Class<?>> hasCustomWriteTargetPredicate;
    private final SimpleTypeHolder simpleTypes;

    DefaultNeo4jConversionService(Neo4jConversions neo4jConversions) {
        DefaultConversionService configurableConversionService = new DefaultConversionService();
        neo4jConversions.registerConvertersIn((ConverterRegistry)configurableConversionService);
        this.conversionService = configurableConversionService;
        this.hasCustomWriteTargetPredicate = arg_0 -> ((Neo4jConversions)neo4jConversions).hasCustomWriteTarget(arg_0);
        this.simpleTypes = neo4jConversions.getSimpleTypeHolder();
    }

    private static boolean isCollection(TypeInformation<?> type) {
        return Collection.class.isAssignableFrom(type.getType());
    }

    @Override
    public <T> @Nullable T convert(Object source, Class<T> targetType) {
        return (T)this.conversionService.convert(source, targetType);
    }

    @Override
    public boolean hasCustomWriteTarget(Class<?> sourceType) {
        return this.hasCustomWriteTargetPredicate.test(sourceType);
    }

    @Override
    public @Nullable Object readValue(@Nullable Value source, TypeInformation<?> targetType, @Nullable Neo4jPersistentPropertyConverter<?> conversionOverride) {
        BiFunction<Value, Class<?>, Object> conversion;
        boolean applyConversionToCompleteCollection = false;
        if (conversionOverride == null) {
            conversion = (arg_0, arg_1) -> ((ConversionService)this.conversionService).convert(arg_0, arg_1);
        } else {
            applyConversionToCompleteCollection = conversionOverride instanceof NullSafeNeo4jPersistentPropertyConverter && ((NullSafeNeo4jPersistentPropertyConverter)conversionOverride).isForCollection();
            conversion = (v, t) -> conversionOverride.read((Value)v);
        }
        return this.readValueImpl(source, targetType, conversion, applyConversionToCompleteCollection);
    }

    private @Nullable Object readValueImpl(@Nullable Value value, TypeInformation<?> type, BiFunction<Value, Class<?>, Object> conversion, boolean applyConversionToCompleteCollection) {
        boolean valueIsLiteralNullOrNullValue = value == null || value == Values.NULL;
        try {
            Class rawType = type.getType();
            if (!valueIsLiteralNullOrNullValue && DefaultNeo4jConversionService.isCollection(type) && !applyConversionToCompleteCollection) {
                Collection target = CollectionFactory.createCollection((Class)rawType, (Class)Objects.requireNonNull(type.getComponentType()).getType(), (int)value.size());
                value.values().forEach(element -> target.add(conversion.apply((Value)element, type.getComponentType().getType())));
                return target;
            }
            return valueIsLiteralNullOrNullValue ? null : conversion.apply(value, rawType);
        }
        catch (Exception ex) {
            String msg = String.format("Could not convert %s into %s", value, type);
            throw new TypeMismatchDataAccessException(msg, (Throwable)ex);
        }
    }

    @Override
    public Value writeValue(@Nullable Object value, TypeInformation<?> sourceType, @Nullable Neo4jPersistentPropertyConverter<?> writingConverter) {
        Function<Object, Value> conversion;
        boolean applyConversionToCompleteCollection = false;
        if (writingConverter == null) {
            conversion = v -> (Value)this.conversionService.convert(v, Value.class);
        } else {
            Neo4jPersistentPropertyConverter<?> hlp = writingConverter;
            applyConversionToCompleteCollection = writingConverter instanceof NullSafeNeo4jPersistentPropertyConverter && ((NullSafeNeo4jPersistentPropertyConverter)writingConverter).isForCollection();
            conversion = hlp::write;
        }
        return this.writeValueImpl(value, sourceType, conversion, applyConversionToCompleteCollection);
    }

    private Value writeValueImpl(@Nullable Object value, TypeInformation<?> type, Function<Object, Value> conversion, boolean applyConversionToCompleteCollection) {
        if (value == null) {
            try {
                return conversion.apply(null);
            }
            catch (NullPointerException ex) {
                return Values.NULL;
            }
        }
        if (DefaultNeo4jConversionService.isCollection(type) && !applyConversionToCompleteCollection) {
            Collection sourceCollection = (Collection)value;
            Object[] targetCollection = sourceCollection.stream().map(conversion::apply).toArray();
            return Values.value((Object)targetCollection);
        }
        return conversion.apply(value);
    }

    @Override
    public boolean isSimpleType(Class<?> type) {
        return this.simpleTypes.isSimpleType(type);
    }
}

