/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.schema;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.UUID;
import org.apiguardian.api.API;
import org.springframework.core.annotation.AliasFor;
import org.springframework.data.neo4j.core.schema.IdGenerator;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.ANNOTATION_TYPE})
@Documented
@Inherited
@API(status=API.Status.STABLE, since="6.0")
public @interface GeneratedValue {
    @AliasFor(value="generatorClass")
    public Class<? extends IdGenerator<?>> value() default InternalIdGenerator.class;

    @AliasFor(value="value")
    public Class<? extends IdGenerator<?>> generatorClass() default InternalIdGenerator.class;

    public String generatorRef() default "";

    public static final class UUIDGenerator
    implements IdGenerator<UUID> {
        @Override
        public UUID generateId(String primaryLabel, Object entity) {
            return UUID.randomUUID();
        }
    }

    public static final class InternalIdGenerator
    implements IdGenerator<Void> {
        @Override
        public Void generateId(String primaryLabel, Object entity) {
            return null;
        }
    }
}

