/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Iterator;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.ExposesRelationships;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.neo4j.core.schema.TargetNode;
import org.springframework.lang.Nullable;

class PropertyPathWrapper {
    private static final String NAME_OF_RELATED_FILTER_ENTITY = "m";
    private static final String NAME_OF_RELATED_FILTER_RELATIONSHIP = "r";
    private final int index;
    private final PersistentPropertyPath<?> persistentPropertyPath;
    private final int lengthModification;

    PropertyPathWrapper(int index, PersistentPropertyPath<?> persistentPropertyPath) {
        this(index, persistentPropertyPath, true);
    }

    PropertyPathWrapper(int index, PersistentPropertyPath<?> persistentPropertyPath, boolean hasPropertyEnding) {
        this.index = index;
        this.persistentPropertyPath = persistentPropertyPath;
        this.lengthModification = hasPropertyEnding ? 0 : 1;
    }

    public PersistentPropertyPath<?> getPersistentPropertyPath() {
        return this.persistentPropertyPath;
    }

    String getNodeName() {
        return "m_" + this.index;
    }

    String getRelationshipName() {
        return "r_" + this.index;
    }

    ExposesRelationships<?> createRelationshipChain(ExposesRelationships<?> existingRelationshipChain) {
        RelationshipDescription relationshipDescription;
        PersistentProperty persistentProperty;
        RelationshipPattern cypherRelationship = existingRelationshipChain;
        int cnt = 0;
        Iterator iterator = this.persistentPropertyPath.iterator();
        while (!(!iterator.hasNext() || (persistentProperty = (PersistentProperty)iterator.next()).isAssociation() && persistentProperty.isAnnotationPresent(TargetNode.class) || (relationshipDescription = (RelationshipDescription)persistentProperty.getAssociation()) == null)) {
            NodeDescription<?> relationshipPropertiesEntity = relationshipDescription.getRelationshipPropertiesEntity();
            boolean isRelationshipPropertiesEntity = this.isRelationshipPropertiesEntity(relationshipPropertiesEntity);
            NodeDescription<?> targetEntity = relationshipDescription.getTarget();
            Node relatedNode = Cypher.node((String)targetEntity.getPrimaryLabel(), targetEntity.getAdditionalLabels());
            boolean lastNode = cnt > this.persistentPropertyPath.getLength() - 3 + this.lengthModification;
            boolean lastRelationship = cnt + 1 > this.persistentPropertyPath.getLength() - 4 + this.lengthModification;
            ++cnt;
            if (lastNode || isRelationshipPropertiesEntity && lastRelationship) {
                relatedNode = relatedNode.named(this.getNodeName());
            }
            switch (relationshipDescription.getDirection()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case OUTGOING: {
                    RelationshipPattern relationshipPattern = cypherRelationship.relationshipTo(relatedNode, new String[]{relationshipDescription.getType()});
                    break;
                }
                case INCOMING: {
                    RelationshipPattern relationshipPattern = cypherRelationship = cypherRelationship.relationshipFrom(relatedNode, new String[]{relationshipDescription.getType()});
                }
            }
            if (!lastNode && (!isRelationshipPropertiesEntity || !lastRelationship)) continue;
            cypherRelationship = cypherRelationship.named(this.getRelationshipName());
        }
        return cypherRelationship;
    }

    private boolean isRelationshipPropertiesEntity(@Nullable NodeDescription<?> relationshipPropertiesEntity) {
        return relationshipPropertiesEntity != null && ((Neo4jPersistentEntity)relationshipPropertiesEntity).getPersistentProperty(TargetNode.class) != null;
    }

    boolean hasRelationships() {
        return this.persistentPropertyPath.getLength() > 1;
    }
}

