/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.renderer.Dialect;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.Entity;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.neo4j.core.mapping.Constants;
import org.springframework.data.neo4j.core.mapping.EntityInstanceWithSource;
import org.springframework.data.neo4j.core.mapping.IdDescription;
import org.springframework.data.neo4j.core.mapping.IdentitySupport;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.PropertyFilter;
import org.springframework.data.neo4j.core.mapping.PropertyTraverser;
import org.springframework.data.neo4j.core.mapping.SpringDataCypherDsl;
import org.springframework.data.neo4j.repository.query.QueryFragments;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@API(status=API.Status.INTERNAL, since="6.0.9")
public final class TemplateSupport {
    @Nullable
    public static Class<?> findCommonElementType(Iterable<?> collection) {
        if (collection == null) {
            return null;
        }
        Collection allClasses = StreamSupport.stream(collection.spliterator(), true).filter(o -> o != null).map(Object::getClass).collect(Collectors.toSet());
        if (allClasses.isEmpty()) {
            return EmptyIterable.class;
        }
        Class candidate = null;
        for (Class type : allClasses) {
            if (candidate == null) {
                candidate = type;
                continue;
            }
            if (candidate == type) continue;
            candidate = null;
            break;
        }
        if (candidate != null) {
            return candidate;
        }
        Predicate<Class> moveUp = c -> c != null && c != Object.class;
        HashSet mostAbstractClasses = new HashSet();
        for (Class type : allClasses) {
            while (moveUp.test(type.getSuperclass())) {
                type = type.getSuperclass();
            }
            mostAbstractClasses.add(type);
        }
        Class clazz = candidate = mostAbstractClasses.size() == 1 ? (Class)mostAbstractClasses.iterator().next() : null;
        if (candidate != null) {
            return candidate;
        }
        List<Set> interfacesPerClass = allClasses.stream().map(c -> Arrays.stream(c.getInterfaces()).collect(Collectors.toSet())).collect(Collectors.toList());
        Set allInterfaces = interfacesPerClass.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        interfacesPerClass.forEach(setOfInterfaces -> allInterfaces.removeIf(iface -> !setOfInterfaces.contains(iface)));
        candidate = allInterfaces.size() == 1 ? (Class)allInterfaces.iterator().next() : null;
        return candidate;
    }

    static PropertyFilter computeIncludePropertyPredicate(Collection<PropertyFilter.ProjectedPath> includedProperties, NodeDescription<?> nodeDescription) {
        return PropertyFilter.from(includedProperties, nodeDescription);
    }

    static void updateVersionPropertyIfPossible(Neo4jPersistentEntity<?> entityMetaData, PersistentPropertyAccessor<?> propertyAccessor, Entity newOrUpdatedNode) {
        if (entityMetaData.hasVersionProperty()) {
            propertyAccessor.setProperty(entityMetaData.getVersionProperty(), (Object)newOrUpdatedNode.get(((Neo4jPersistentProperty)entityMetaData.getVersionProperty()).getPropertyName()).asLong());
        }
    }

    static Map<String, Object> mergeParameters(Statement statement, @Nullable Map<String, Object> parameters) {
        HashMap<String, Object> mergedParameters = new HashMap<String, Object>(statement.getCatalog().getParameters());
        if (parameters != null) {
            mergedParameters.putAll(parameters);
        }
        return mergedParameters;
    }

    static <T> Supplier<BiFunction<TypeSystem, MapAccessor, ?>> getAndDecorateMappingFunction(Neo4jMappingContext mappingContext, Class<T> domainType, @Nullable Class<?> resultType) {
        Assert.notNull((Object)mappingContext.getPersistentEntity(domainType), (String)"Cannot get or create persistent entity");
        return () -> {
            BiFunction<TypeSystem, MapAccessor, ?> mappingFunction = mappingContext.getRequiredMappingFunctionFor(domainType);
            if (resultType != null && domainType != resultType && !resultType.isInterface()) {
                mappingFunction = EntityInstanceWithSource.decorateMappingFunction(mappingFunction);
            }
            return mappingFunction;
        };
    }

    static <T> FilteredBinderFunction<T> createAndApplyPropertyFilter(Collection<PropertyFilter.ProjectedPath> includedProperties, Neo4jPersistentEntity<?> entityMetaData, Function<T, Map<String, Object>> binderFunction) {
        PropertyFilter includeProperty = TemplateSupport.computeIncludePropertyPredicate(includedProperties, entityMetaData);
        return new FilteredBinderFunction<T>(includeProperty, binderFunction.andThen(tree -> {
            boolean assignedId;
            Map properties = (Map)tree.get("__properties__");
            String idPropertyName = ((Neo4jPersistentProperty)entityMetaData.getIdProperty()).getPropertyName();
            IdDescription idDescription = entityMetaData.getIdDescription();
            boolean bl = assignedId = idDescription.isAssignedId() || idDescription.isExternallyGeneratedId();
            if (!includeProperty.isNotFiltering()) {
                properties.entrySet().removeIf(e -> {
                    boolean isIdProperty = ((String)e.getKey()).equals(idPropertyName);
                    return (!assignedId || !isIdProperty) && !includeProperty.contains((String)e.getKey(), entityMetaData.getUnderlyingClass());
                });
            }
            return tree;
        }));
    }

    static <T> Collection<PropertyFilter.ProjectedPath> computeIncludedPropertiesFromPredicate(Neo4jMappingContext mappingContext, Class<T> domainType, @Nullable BiPredicate<PropertyPath, Neo4jPersistentProperty> predicate) {
        if (predicate == null) {
            return Collections.emptySet();
        }
        HashSet<PropertyFilter.ProjectedPath> pps = new HashSet<PropertyFilter.ProjectedPath>();
        PropertyTraverser traverser = new PropertyTraverser(mappingContext);
        traverser.traverse(domainType, predicate, (path, property) -> pps.add(new PropertyFilter.ProjectedPath(PropertyFilter.RelaxedPropertyPath.withRootType(domainType).append(path.toDotPath()), false)));
        return pps;
    }

    static <T> void setGeneratedIdIfNecessary(Neo4jPersistentEntity<?> entityMetaData, PersistentPropertyAccessor<T> propertyAccessor, Object elementId, Optional<Entity> databaseEntity) {
        if (!entityMetaData.isUsingInternalIds()) {
            return;
        }
        Neo4jPersistentProperty requiredIdProperty = (Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty();
        Class idPropertyType = requiredIdProperty.getType();
        if (entityMetaData.isUsingDeprecatedInternalId()) {
            propertyAccessor.setProperty((PersistentProperty)requiredIdProperty, (Object)databaseEntity.map(IdentitySupport::getInternalId).orElseThrow());
        } else if (idPropertyType.equals(String.class)) {
            propertyAccessor.setProperty((PersistentProperty)requiredIdProperty, elementId);
        } else {
            throw new IllegalArgumentException("Unsupported generated id property " + idPropertyType);
        }
    }

    static <T> Object retrieveOrSetRelatedId(Neo4jPersistentEntity<?> entityMetadata, PersistentPropertyAccessor<T> propertyAccessor, Optional<Entity> databaseEntity, @Nullable Object relatedInternalId) {
        if (!entityMetadata.isUsingInternalIds()) {
            return Objects.requireNonNull(relatedInternalId);
        }
        Neo4jPersistentProperty requiredIdProperty = (Neo4jPersistentProperty)entityMetadata.getRequiredIdProperty();
        Object current = propertyAccessor.getProperty((PersistentProperty)requiredIdProperty);
        if (entityMetadata.isUsingDeprecatedInternalId()) {
            if (relatedInternalId == null && current != null) {
                relatedInternalId = current.toString();
            } else if (current == null) {
                long internalId = databaseEntity.map(Entity::id).orElseThrow();
                propertyAccessor.setProperty((PersistentProperty)requiredIdProperty, (Object)internalId);
            }
        } else if (relatedInternalId == null && current != null) {
            relatedInternalId = current;
        } else if (current == null) {
            propertyAccessor.setProperty((PersistentProperty)requiredIdProperty, relatedInternalId);
        }
        return Objects.requireNonNull(relatedInternalId);
    }

    static boolean rendererCanUseElementIdIfPresent(Renderer renderer, Neo4jPersistentEntity<?> targetEntity) {
        return !targetEntity.isUsingDeprecatedInternalId() && TemplateSupport.rendererRendersElementId(renderer);
    }

    static boolean rendererRendersElementId(Renderer renderer) {
        return renderer.render(Cypher.returning((Expression[])new Expression[]{Cypher.elementId((Node)Cypher.anyNode((String)"n"))}).build()).equals("RETURN elementId(n)");
    }

    public static String convertIdOrElementIdToString(Object value) {
        if (value instanceof Value) {
            Value driverValue = (Value)value;
            if (driverValue.hasType(TypeSystem.getDefault().NUMBER())) {
                return driverValue.asNumber().toString();
            }
            return driverValue.asString();
        }
        return value.toString();
    }

    static Object convertToLongIdOrStringElementId(Collection<String> ids) {
        try {
            return ids.stream().map(Long::valueOf).collect(Collectors.toSet());
        }
        catch (Exception e) {
            return ids;
        }
    }

    private TemplateSupport() {
    }

    public static final class EmptyIterable {
        private EmptyIterable() {
        }
    }

    static class FilteredBinderFunction<T>
    implements Function<T, Map<String, Object>> {
        final PropertyFilter filter;
        final Function<T, Map<String, Object>> binderFunction;

        FilteredBinderFunction(PropertyFilter filter, Function<T, Map<String, Object>> binderFunction) {
            this.filter = filter;
            this.binderFunction = binderFunction;
        }

        @Override
        public Map<String, Object> apply(T t) {
            return this.binderFunction.apply(t);
        }
    }

    static final class NodesAndRelationshipsByIdStatementProvider {
        private static final String ROOT_NODE_IDS = "rootNodeIds";
        private static final String RELATIONSHIP_IDS = "relationshipIds";
        private static final String RELATED_NODE_IDS = "relatedNodeIds";
        static final NodesAndRelationshipsByIdStatementProvider EMPTY = new NodesAndRelationshipsByIdStatementProvider(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), new QueryFragments(), SpringDataCypherDsl.elementIdOrIdFunction.apply(Dialect.NEO4J_4));
        private final Map<String, Collection<String>> parameters = new HashMap<String, Collection<String>>(3);
        private final QueryFragments queryFragments;
        private final Function<Named, FunctionInvocation> elementIdFunction;

        NodesAndRelationshipsByIdStatementProvider(Collection<String> rootNodeIds, Collection<String> relationshipsIds, Collection<String> relatedNodeIds, QueryFragments queryFragments, Function<Named, FunctionInvocation> elementIdFunction) {
            this.elementIdFunction = elementIdFunction;
            this.parameters.put(ROOT_NODE_IDS, rootNodeIds);
            this.parameters.put(RELATIONSHIP_IDS, relationshipsIds);
            this.parameters.put(RELATED_NODE_IDS, relatedNodeIds);
            this.queryFragments = queryFragments;
        }

        boolean hasRootNodeIds() {
            return this.parameters.get(ROOT_NODE_IDS).isEmpty();
        }

        Statement toStatement(NodeDescription<?> nodeDescription) {
            String primaryLabel = nodeDescription.getPrimaryLabel();
            Node rootNodes = Cypher.node((String)primaryLabel, (String[])new String[0]).named(ROOT_NODE_IDS);
            Node relatedNodes = Cypher.anyNode((String)RELATED_NODE_IDS);
            ArrayList<Object> projection = new ArrayList<Object>();
            projection.add(Constants.NAME_OF_TYPED_ROOT_NODE.apply(nodeDescription).as("__sn__"));
            projection.add(Cypher.name((String)"__sr__"));
            projection.add(Cypher.name((String)"__srn__"));
            projection.addAll(this.queryFragments.getAdditionalReturnExpressions());
            Relationship relationships = ((Relationship)Cypher.anyNode().relationshipBetween(Cypher.anyNode(), new String[0])).named(RELATIONSHIP_IDS);
            return ((StatementBuilder.OngoingReadingWithWhere)((StatementBuilder.OngoingReadingWithWhere)((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{rootNodes}).where(this.elementIdFunction.apply((Named)rootNodes).in((Expression)Cypher.parameter((String)ROOT_NODE_IDS, (Object)TemplateSupport.convertToLongIdOrStringElementId(this.parameters.get(ROOT_NODE_IDS)))))).with(new IdentifiableElement[]{Cypher.collect((Named)rootNodes).as(Constants.NAME_OF_ROOT_NODE)}).optionalMatch(new PatternElement[]{relationships}).where(this.elementIdFunction.apply((Named)relationships).in((Expression)Cypher.parameter((String)RELATIONSHIP_IDS, (Object)TemplateSupport.convertToLongIdOrStringElementId(this.parameters.get(RELATIONSHIP_IDS)))))).with(new IdentifiableElement[]{Constants.NAME_OF_ROOT_NODE, Cypher.collectDistinct((Named)relationships).as("__sr__")}).optionalMatch(new PatternElement[]{relatedNodes}).where(this.elementIdFunction.apply((Named)relatedNodes).in((Expression)Cypher.parameter((String)RELATED_NODE_IDS, (Object)TemplateSupport.convertToLongIdOrStringElementId(this.parameters.get(RELATED_NODE_IDS)))))).with(new IdentifiableElement[]{Constants.NAME_OF_ROOT_NODE, Cypher.name((String)"__sr__").as("__sr__"), Cypher.collectDistinct((Named)relatedNodes).as("__srn__")}).unwind((Expression)Constants.NAME_OF_ROOT_NODE).as(ROOT_NODE_IDS).with(new IdentifiableElement[]{Cypher.name((String)ROOT_NODE_IDS).as(Constants.NAME_OF_TYPED_ROOT_NODE.apply(nodeDescription).getValue()), Cypher.name((String)"__sr__"), Cypher.name((String)"__srn__")}).orderBy(this.queryFragments.getOrderBy()).returning(projection).skip((Number)this.queryFragments.getSkip()).limit(this.queryFragments.getLimit()).build();
        }
    }

    static enum FetchType {
        ONE,
        ALL;

    }
}

