/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.lang.reflect.Method;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.renderer.Configuration;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.springframework.data.neo4j.core.ReactiveNeo4jOperations;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.repository.query.ReactiveCypherdslBasedQuery;
import org.springframework.data.neo4j.repository.query.ReactiveNeo4jQueryMethod;
import org.springframework.data.neo4j.repository.query.ReactivePartTreeNeo4jQuery;
import org.springframework.data.neo4j.repository.query.ReactiveStringBasedNeo4jQuery;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;

@API(status=API.Status.INTERNAL, since="6.0")
public final class ReactiveNeo4jQueryLookupStrategy
implements QueryLookupStrategy {
    private final ReactiveNeo4jOperations neo4jOperations;
    private final Neo4jMappingContext mappingContext;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private final Configuration configuration;

    public ReactiveNeo4jQueryLookupStrategy(ReactiveNeo4jOperations neo4jOperations, Neo4jMappingContext mappingContext, QueryMethodEvaluationContextProvider evaluationContextProvider, Configuration configuration) {
        this.neo4jOperations = neo4jOperations;
        this.mappingContext = mappingContext;
        this.evaluationContextProvider = evaluationContextProvider;
        this.configuration = configuration;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
        ReactiveNeo4jQueryMethod queryMethod = new ReactiveNeo4jQueryMethod(method, metadata, projectionFactory);
        String namedQueryName = queryMethod.getNamedQueryName();
        if (namedQueries.hasQuery(namedQueryName)) {
            return ReactiveStringBasedNeo4jQuery.create(this.neo4jOperations, this.mappingContext, this.evaluationContextProvider, queryMethod, namedQueries.getQuery(namedQueryName), projectionFactory);
        }
        if (queryMethod.hasQueryAnnotation()) {
            return ReactiveStringBasedNeo4jQuery.create(this.neo4jOperations, this.mappingContext, this.evaluationContextProvider, queryMethod, projectionFactory);
        }
        if (queryMethod.isCypherBasedProjection()) {
            return ReactiveCypherdslBasedQuery.create(this.neo4jOperations, this.mappingContext, queryMethod, projectionFactory, arg_0 -> ((Renderer)Renderer.getRenderer((Configuration)this.configuration)).render(arg_0));
        }
        return ReactivePartTreeNeo4jQuery.create(this.neo4jOperations, this.mappingContext, queryMethod, projectionFactory);
    }
}

