/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.Entity;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Relationship;
import org.neo4j.driver.types.Type;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.core.CollectionFactory;
import org.springframework.core.KotlinDetector;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.InstanceCreatorMetadata;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.Parameter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.neo4j.core.convert.Neo4jConversionService;
import org.springframework.data.neo4j.core.mapping.AssociationHandlerSupport;
import org.springframework.data.neo4j.core.mapping.IdentitySupport;
import org.springframework.data.neo4j.core.mapping.MapValueWrapper;
import org.springframework.data.neo4j.core.mapping.MappingSupport;
import org.springframework.data.neo4j.core.mapping.Neo4jEntityConverter;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NoRootNodeMappingException;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.NodeDescriptionAndLabels;
import org.springframework.data.neo4j.core.mapping.NodeDescriptionStore;
import org.springframework.data.neo4j.core.mapping.PropertyHandlerSupport;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.neo4j.core.mapping.callback.EventSupport;
import org.springframework.data.neo4j.core.schema.TargetNode;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

final class DefaultNeo4jEntityConverter
implements Neo4jEntityConverter {
    private final EntityInstantiators entityInstantiators;
    private final NodeDescriptionStore nodeDescriptionStore;
    private final Neo4jConversionService conversionService;
    private final EventSupport eventSupport;
    private final KnownObjects knownObjects = new KnownObjects();
    private final Type nodeType;
    private final Type relationshipType;
    private final Type mapType;
    private final Type listType;
    private final Type pathType;
    private final Map<String, Collection<Node>> labelNodeCache = new HashMap<String, Collection<Node>>();

    DefaultNeo4jEntityConverter(EntityInstantiators entityInstantiators, NodeDescriptionStore nodeDescriptionStore, Neo4jConversionService conversionService, EventSupport eventSupport, TypeSystem typeSystem) {
        Assert.notNull((Object)entityInstantiators, (String)"EntityInstantiators must not be null");
        Assert.notNull((Object)conversionService, (String)"Neo4jConversionService must not be null");
        Assert.notNull((Object)nodeDescriptionStore, (String)"NodeDescriptionStore must not be null");
        Assert.notNull((Object)typeSystem, (String)"TypeSystem must not be null");
        this.entityInstantiators = entityInstantiators;
        this.conversionService = conversionService;
        this.nodeDescriptionStore = nodeDescriptionStore;
        this.eventSupport = eventSupport;
        this.nodeType = typeSystem.NODE();
        this.relationshipType = typeSystem.RELATIONSHIP();
        this.mapType = typeSystem.MAP();
        this.listType = typeSystem.LIST();
        this.pathType = typeSystem.PATH();
    }

    @Nullable
    public <R> R read(Class<R> targetType, MapAccessor mapAccessor) {
        this.knownObjects.nextRecord();
        this.labelNodeCache.clear();
        Neo4jPersistentEntity rootNodeDescription = (Neo4jPersistentEntity)this.nodeDescriptionStore.getNodeDescription(targetType);
        MapAccessor queryRoot = this.determineQueryRoot(mapAccessor, rootNodeDescription, true);
        try {
            return queryRoot == null ? null : (R)this.map(queryRoot, queryRoot, rootNodeDescription);
        }
        catch (Exception e) {
            throw new MappingException("Error mapping " + String.valueOf(mapAccessor), (Throwable)e);
        }
    }

    @Nullable
    private <R> MapAccessor determineQueryRoot(MapAccessor mapAccessor, @Nullable Neo4jPersistentEntity<R> rootNodeDescription, boolean firstTry) {
        ArrayList<Node> finalCandidates;
        if (rootNodeDescription == null) {
            return null;
        }
        ArrayList<String> primaryLabels = new ArrayList<String>();
        primaryLabels.add(rootNodeDescription.getPrimaryLabel());
        rootNodeDescription.getChildNodeDescriptionsInHierarchy().forEach(nodeDescription -> primaryLabels.add(nodeDescription.getPrimaryLabel()));
        List<Value> recordValues = mapAccessor instanceof Value && ((Value)mapAccessor).hasType(this.nodeType) ? Collections.singletonList((Value)mapAccessor) : mapAccessor.values();
        ArrayList<Node> matchingNodes = new ArrayList<Node>();
        ArrayList<Node> seenMatchingNodes = new ArrayList<Node>();
        for (Value value : recordValues) {
            if (!value.hasType(this.nodeType)) continue;
            Node node = value.asNode();
            if (!primaryLabels.stream().anyMatch(arg_0 -> ((Node)node).hasLabel(arg_0))) continue;
            if (this.knownObjects.getObject("N" + IdentitySupport.getElementId((Entity)node)) == null) {
                matchingNodes.add(node);
                continue;
            }
            seenMatchingNodes.add(node);
        }
        ArrayList<Node> arrayList = finalCandidates = matchingNodes.isEmpty() ? seenMatchingNodes : matchingNodes;
        if (finalCandidates.size() > 1) {
            throw new MappingException("More than one matching node in the record");
        }
        if (!finalCandidates.isEmpty()) {
            if (mapAccessor.size() > 1) {
                return DefaultNeo4jEntityConverter.mergeRootNodeWithRecord((Node)finalCandidates.get(0), mapAccessor);
            }
            return (MapAccessor)finalCandidates.get(0);
        }
        int cnt = 0;
        Value firstValue = Values.NULL;
        for (Value value : recordValues) {
            if (cnt == 0) {
                firstValue = value;
            }
            if (value.hasType(this.mapType) && !value.hasType(this.nodeType) && !value.hasType(this.relationshipType)) {
                return value;
            }
            ++cnt;
        }
        if (cnt == 1 && firstValue.isNull()) {
            return null;
        }
        boolean isSynthesized = this.isSynthesized(mapAccessor);
        if (!isSynthesized) {
            if (mapAccessor instanceof Value && ((Value)mapAccessor).hasType(this.mapType)) {
                return mapAccessor;
            }
            if (firstTry && !this.canBeAggregated(mapAccessor)) {
                Value value = Values.value(Collections.singletonMap("_", mapAccessor.asMap(Function.identity())));
                return this.determineQueryRoot((MapAccessor)value, rootNodeDescription, false);
            }
        }
        throw new NoRootNodeMappingException(mapAccessor, rootNodeDescription);
    }

    private boolean canBeAggregated(MapAccessor mapAccessor) {
        if (mapAccessor instanceof Record) {
            Record r = (Record)mapAccessor;
            return r.values().stream().anyMatch(arg_0 -> ((Type)this.pathType).isTypeOf(arg_0));
        }
        return false;
    }

    private boolean isSynthesized(MapAccessor mapAccessor) {
        return mapAccessor.containsKey("__sn__") && mapAccessor.containsKey("__sr__") && mapAccessor.containsKey("__srn__");
    }

    private Collection<String> createDynamicLabelsProperty(TypeInformation<?> type, Collection<String> dynamicLabels) {
        Collection target = CollectionFactory.createCollection((Class)type.getType(), String.class, (int)dynamicLabels.size());
        target.addAll(dynamicLabels);
        return target;
    }

    public void write(Object source, Map<String, Object> parameters) {
        HashMap<String, String> properties = new HashMap<String, String>();
        Neo4jPersistentEntity nodeDescription = (Neo4jPersistentEntity)this.nodeDescriptionStore.getNodeDescription(source.getClass());
        if (nodeDescription.hasRelationshipPropertyPersistTypeInfoFlag()) {
            properties.put("__relationshipType__", nodeDescription.getPrimaryLabel());
        }
        PersistentPropertyAccessor propertyAccessor = nodeDescription.getPropertyAccessor(source);
        PropertyHandlerSupport.of(nodeDescription).doWithProperties((PropertyHandler<Neo4jPersistentProperty>)((PropertyHandler)p -> {
            if (p.isInternalIdProperty() || p.isDynamicLabels() || p.isEntity() || p.isVersionProperty() || p.isReadOnly()) {
                return;
            }
            Value value = this.conversionService.writeValue(propertyAccessor.getProperty(p), p.getTypeInformation(), p.getOptionalConverter());
            if (p.isComposite()) {
                properties.put(p.getPropertyName(), (String)((Object)new MapValueWrapper(value)));
            } else {
                properties.put(p.getPropertyName(), (String)value);
            }
        }));
        parameters.put("__properties__", properties);
        if (nodeDescription.hasIdProperty()) {
            Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)nodeDescription.getRequiredIdProperty();
            parameters.put("__id__", this.conversionService.writeValue(propertyAccessor.getProperty((PersistentProperty)idProperty), idProperty.getTypeInformation(), idProperty.getOptionalConverter()));
        }
        if (nodeDescription.hasVersionProperty()) {
            Long versionProperty = (Long)propertyAccessor.getProperty(nodeDescription.getRequiredVersionProperty());
            parameters.put("__version__", versionProperty);
        }
    }

    private static MapAccessor mergeRootNodeWithRecord(Node node, MapAccessor record) {
        HashMap<String, Object> mergedAttributes = new HashMap<String, Object>(node.size() + record.size() + 1);
        mergedAttributes.put("__internalNeo4jId__", IdentitySupport.getInternalId((MapAccessor)node));
        mergedAttributes.put("__elementId__", node.elementId());
        mergedAttributes.put("__nodeLabels__", node.labels());
        mergedAttributes.putAll(node.asMap(Function.identity()));
        mergedAttributes.putAll(record.asMap(Function.identity()));
        return Values.value(mergedAttributes);
    }

    private <ET> ET map(MapAccessor queryResult, MapAccessor allValues, Neo4jPersistentEntity<ET> nodeDescription) {
        Collection<Relationship> relationshipsFromResult = this.extractRelationships(allValues);
        Collection<Node> nodesFromResult = this.extractNodes(allValues);
        return this.map(queryResult, nodeDescription, nodeDescription, null, null, relationshipsFromResult, nodesFromResult);
    }

    private <ET> ET map(MapAccessor queryResult, Neo4jPersistentEntity<ET> nodeDescription, NodeDescription<?> genericTargetNodeDescription, @Nullable Object lastMappedEntity, @Nullable RelationshipDescription relationshipDescription, Collection<Relationship> relationshipsFromResult, Collection<Node> nodesFromResult) {
        String direction = relationshipDescription != null ? relationshipDescription.getDirection().name() : null;
        String internalId = IdentitySupport.getPrefixedElementId(queryResult, direction);
        Supplier<Object> mappedObjectSupplier = () -> {
            this.knownObjects.setInCreation(internalId);
            List<String> allLabels = this.getLabels(queryResult, nodeDescription);
            NodeDescriptionAndLabels nodeDescriptionAndLabels = this.nodeDescriptionStore.deriveConcreteNodeDescription(nodeDescription, allLabels);
            Neo4jPersistentEntity concreteNodeDescription = (Neo4jPersistentEntity)nodeDescriptionAndLabels.getNodeDescription();
            Object instance = this.instantiate(concreteNodeDescription, genericTargetNodeDescription, queryResult, nodeDescriptionAndLabels.getDynamicLabels(), lastMappedEntity, relationshipsFromResult, nodesFromResult);
            this.knownObjects.removeFromInCreation(internalId);
            this.populateProperties(queryResult, (Neo4jPersistentEntity)genericTargetNodeDescription, nodeDescription, internalId, instance, lastMappedEntity, relationshipsFromResult, nodesFromResult, false);
            PersistentPropertyAccessor propertyAccessor = concreteNodeDescription.getPropertyAccessor(this.getMostCurrentInstance(internalId, instance));
            Object bean = propertyAccessor.getBean();
            bean = this.eventSupport.maybeCallAfterConvert(bean, concreteNodeDescription, queryResult);
            this.knownObjects.storeObject(internalId, bean);
            this.knownObjects.mappedWithQueryResult(internalId, queryResult);
            return bean;
        };
        Object mappedObject = this.knownObjects.getObject(internalId);
        if (mappedObject == null) {
            mappedObject = mappedObjectSupplier.get();
            this.knownObjects.storeObject(internalId, mappedObject);
            this.knownObjects.mappedWithQueryResult(internalId, queryResult);
        } else if (this.knownObjects.alreadyMappedInPreviousRecord(internalId) || this.hasMoreFields(queryResult.asMap(), this.knownObjects.getQueryResultsFor(internalId))) {
            this.populateProperties(queryResult, (Neo4jPersistentEntity)genericTargetNodeDescription, nodeDescription, internalId, mappedObject, lastMappedEntity, relationshipsFromResult, nodesFromResult, true);
        }
        return (ET)this.getMostCurrentInstance(internalId, mappedObject);
    }

    private boolean hasMoreFields(Map<String, Object> currentQueryResult, Set<Map<String, Object>> savedQueryResults) {
        if (savedQueryResults.isEmpty()) {
            return true;
        }
        HashSet<String> currentFields = new HashSet<String>(currentQueryResult.keySet());
        HashSet<String> alreadyProcessedFields = new HashSet<String>();
        for (Map<String, Object> savedQueryResult : savedQueryResults) {
            alreadyProcessedFields.addAll(savedQueryResult.keySet());
        }
        currentFields.removeAll(alreadyProcessedFields);
        return !currentFields.isEmpty();
    }

    @Nullable
    private <ET> ET getMostCurrentInstance(String internalId, ET fallbackInstance) {
        return (ET)(this.knownObjects.getObject(internalId) != null ? this.knownObjects.getObject(internalId) : fallbackInstance);
    }

    private <ET> void populateProperties(MapAccessor queryResult, Neo4jPersistentEntity<ET> baseNodeDescription, Neo4jPersistentEntity<ET> moreConcreteNodeDescription, String internalId, ET mappedObject, @Nullable Object lastMappedEntity, Collection<Relationship> relationshipsFromResult, Collection<Node> nodesFromResult, boolean objectAlreadyMapped) {
        List<String> allLabels = this.getLabels(queryResult, moreConcreteNodeDescription);
        NodeDescriptionAndLabels nodeDescriptionAndLabels = this.nodeDescriptionStore.deriveConcreteNodeDescription(moreConcreteNodeDescription, allLabels);
        Neo4jPersistentEntity concreteNodeDescription = (Neo4jPersistentEntity)nodeDescriptionAndLabels.getNodeDescription();
        if (!concreteNodeDescription.requiresPropertyPopulation()) {
            return;
        }
        PersistentPropertyAccessor propertyAccessor = concreteNodeDescription.getPropertyAccessor(mappedObject);
        Predicate<Neo4jPersistentProperty> isConstructorParameter = arg_0 -> ((InstanceCreatorMetadata)concreteNodeDescription.getInstanceCreatorMetadata()).isCreatorParameter(arg_0);
        boolean isKotlinType = KotlinDetector.isKotlinType((Class)concreteNodeDescription.getType());
        PropertyHandler<Neo4jPersistentProperty> handler = this.populateFrom(queryResult, propertyAccessor, isConstructorParameter, nodeDescriptionAndLabels.getDynamicLabels(), lastMappedEntity, isKotlinType, objectAlreadyMapped);
        PropertyHandlerSupport.of(concreteNodeDescription).doWithProperties(handler);
        this.knownObjects.storeObject(internalId, propertyAccessor.getBean());
        this.knownObjects.mappedWithQueryResult(internalId, queryResult);
        AssociationHandlerSupport.of(concreteNodeDescription).doWithAssociations(this.populateFrom(queryResult, baseNodeDescription, propertyAccessor, isConstructorParameter, objectAlreadyMapped, relationshipsFromResult, nodesFromResult, internalId));
    }

    @NonNull
    private Neo4jPersistentEntity<?> getMostConcreteTargetNodeDescription(Neo4jPersistentEntity<?> genericTargetNodeDescription, MapAccessor possibleValueNode) {
        List<String> allLabels = this.getLabels(possibleValueNode, null);
        NodeDescriptionAndLabels nodeDescriptionAndLabels = this.nodeDescriptionStore.deriveConcreteNodeDescription(genericTargetNodeDescription, allLabels);
        return (Neo4jPersistentEntity)nodeDescriptionAndLabels.getNodeDescription();
    }

    @NonNull
    private List<String> getLabels(MapAccessor queryResult, @Nullable NodeDescription<?> nodeDescription) {
        Value labelsValue = queryResult.get("__nodeLabels__");
        ArrayList<String> labels = new ArrayList();
        if (!labelsValue.isNull()) {
            labels = labelsValue.asList(Value::asString);
        } else if (queryResult instanceof Node) {
            Node nodeRepresentation = (Node)queryResult;
            nodeRepresentation.labels().forEach(labels::add);
        } else if (queryResult instanceof Relationship) {
            Value value = queryResult.get("__relationshipType__");
            if (value.isNull()) {
                labels.addAll(nodeDescription.getStaticLabels());
            } else {
                labels.add(value.asString());
            }
        } else if (this.containsOnePlainNode(queryResult)) {
            for (Value value : queryResult.values()) {
                if (!value.hasType(this.nodeType)) continue;
                Node node = value.asNode();
                for (String label : node.labels()) {
                    labels.add(label);
                }
            }
        } else if (!queryResult.get("__sn__").isNull()) {
            queryResult.get("__sn__").asNode().labels().forEach(labels::add);
        } else if (nodeDescription != null) {
            labels.addAll(nodeDescription.getStaticLabels());
        }
        return labels;
    }

    private boolean containsOnePlainNode(MapAccessor queryResult) {
        return StreamSupport.stream(queryResult.values().spliterator(), false).filter(value -> value.hasType(this.nodeType)).count() == 1L;
    }

    private <ET> ET instantiate(final Neo4jPersistentEntity<ET> nodeDescription, final NodeDescription<?> genericNodeDescription, final MapAccessor values, final Collection<String> surplusLabels, final @Nullable Object lastMappedEntity, final Collection<Relationship> relationshipsFromResult, final Collection<Node> nodesFromResult) {
        ParameterValueProvider<Neo4jPersistentProperty> parameterValueProvider = new ParameterValueProvider<Neo4jPersistentProperty>(){

            public <T> T getParameterValue(Parameter<T, Neo4jPersistentProperty> parameter) {
                Object result;
                Neo4jPersistentProperty matchingProperty = (Neo4jPersistentProperty)nodeDescription.getRequiredPersistentProperty(parameter.getName());
                if (matchingProperty.isRelationship()) {
                    RelationshipDescription relationshipDescription = nodeDescription.getRelationships().stream().filter(r -> {
                        String propertyFieldName = matchingProperty.getFieldName();
                        return r.getFieldName().equals(propertyFieldName);
                    }).findFirst().get();
                    result = DefaultNeo4jEntityConverter.this.createInstanceOfRelationships(matchingProperty, values, relationshipDescription, genericNodeDescription, relationshipsFromResult, nodesFromResult).orElseGet(() -> {
                        Object resultValue = null;
                        for (NodeDescription<?> parentNodeDescription = nodeDescription.getParentNodeDescription(); parentNodeDescription != null; parentNodeDescription = parentNodeDescription.getParentNodeDescription()) {
                            Optional<Object> value = DefaultNeo4jEntityConverter.this.createInstanceOfRelationships(matchingProperty, values, relationshipDescription, parentNodeDescription, relationshipsFromResult, nodesFromResult);
                            if (!value.isPresent()) continue;
                            resultValue = value.get();
                            break;
                        }
                        return resultValue;
                    });
                } else {
                    result = matchingProperty.isDynamicLabels() ? DefaultNeo4jEntityConverter.this.createDynamicLabelsProperty(matchingProperty.getTypeInformation(), surplusLabels) : (matchingProperty.isEntityWithRelationshipProperties() ? lastMappedEntity : DefaultNeo4jEntityConverter.this.conversionService.readValue(DefaultNeo4jEntityConverter.extractValueOf(matchingProperty, values), parameter.getType(), matchingProperty.getOptionalConverter()));
                }
                return (T)result;
            }
        };
        return (ET)this.entityInstantiators.getInstantiatorFor(nodeDescription).createInstance(nodeDescription, (ParameterValueProvider)parameterValueProvider);
    }

    private PropertyHandler<Neo4jPersistentProperty> populateFrom(MapAccessor queryResult, PersistentPropertyAccessor<?> propertyAccessor, Predicate<Neo4jPersistentProperty> isConstructorParameter, Collection<String> surplusLabels, @Nullable Object targetNode, boolean ownerIsKotlinType, boolean objectAlreadyMapped) {
        return property -> {
            Object value;
            if (isConstructorParameter.test((Neo4jPersistentProperty)property)) {
                return;
            }
            TypeInformation typeInformation = property.getTypeInformation();
            if (!objectAlreadyMapped) {
                if (property.isDynamicLabels()) {
                    propertyAccessor.setProperty(property, this.createDynamicLabelsProperty(typeInformation, surplusLabels));
                } else if (property.isAnnotationPresent(TargetNode.class) && queryResult instanceof Relationship) {
                    propertyAccessor.setProperty(property, targetNode);
                }
            }
            if (!property.isDynamicLabels() && !property.isAnnotationPresent(TargetNode.class) && (value = this.conversionService.readValue(DefaultNeo4jEntityConverter.extractValueOf(property, queryResult), typeInformation, property.getOptionalConverter())) != null) {
                Class rawType = typeInformation.getType();
                propertyAccessor.setProperty(property, DefaultNeo4jEntityConverter.getValueOrDefault(ownerIsKotlinType, rawType, value));
            }
        };
    }

    @Nullable
    private static Object getValueOrDefault(boolean ownerIsKotlinType, Class<?> rawType, @Nullable Object value) {
        return value == null && !ownerIsKotlinType && rawType.isPrimitive() ? ReflectionUtils.getPrimitiveDefault(rawType) : value;
    }

    private AssociationHandler<Neo4jPersistentProperty> populateFrom(MapAccessor queryResult, NodeDescription<?> baseDescription, PersistentPropertyAccessor<?> propertyAccessor, Predicate<Neo4jPersistentProperty> isConstructorParameter, boolean objectAlreadyMapped, Collection<Relationship> relationshipsFromResult, Collection<Node> nodesFromResult, String internalId) {
        return association -> {
            boolean propertyAlreadyPopulated;
            boolean populatedScalarValue;
            Object propertyValue;
            Neo4jPersistentProperty persistentProperty = (Neo4jPersistentProperty)association.getInverse();
            if (isConstructorParameter.test(persistentProperty)) {
                return;
            }
            if (objectAlreadyMapped) {
                boolean willCreateNewInstance;
                boolean bl = willCreateNewInstance = persistentProperty.getWither() != null;
                if (willCreateNewInstance) {
                    throw new MappingException("Cannot create a new instance of an already existing object");
                }
            }
            boolean propertyValueNotNull = (propertyValue = propertyAccessor.getProperty((PersistentProperty)persistentProperty)) != null;
            boolean populatedCollection = objectAlreadyMapped && persistentProperty.isCollectionLike() && propertyValueNotNull && !((Collection)propertyValue).isEmpty();
            boolean populatedMap = objectAlreadyMapped && persistentProperty.isMap() && propertyValueNotNull && !((Map)propertyValue).isEmpty();
            boolean bl = populatedScalarValue = objectAlreadyMapped && !persistentProperty.isCollectionLike() && !persistentProperty.isMap() && propertyValueNotNull;
            if (populatedCollection) {
                this.createInstanceOfRelationships(persistentProperty, queryResult, (RelationshipDescription)association, baseDescription, relationshipsFromResult, nodesFromResult, false).ifPresent(value -> {
                    Collection providedCollection = (Collection)value;
                    Collection existingValue = (Collection)propertyValue;
                    Collection newValue = CollectionFactory.createCollection(existingValue.getClass(), (int)(providedCollection.size() + existingValue.size()));
                    RelationshipDescription relationshipDescription = (RelationshipDescription)association;
                    HashMap<Object, Object> mergedValues = new HashMap<Object, Object>();
                    this.mergeCollections(relationshipDescription, existingValue, mergedValues);
                    this.mergeCollections(relationshipDescription, providedCollection, mergedValues);
                    newValue.addAll(mergedValues.values());
                    propertyAccessor.setProperty((PersistentProperty)persistentProperty, (Object)newValue);
                });
            }
            boolean bl2 = propertyAlreadyPopulated = populatedCollection || populatedMap || populatedScalarValue;
            if (propertyAlreadyPopulated) {
                return;
            }
            this.createInstanceOfRelationships(persistentProperty, queryResult, (RelationshipDescription)association, baseDescription, relationshipsFromResult, nodesFromResult).ifPresent(value -> propertyAccessor.setProperty((PersistentProperty)persistentProperty, value));
        };
    }

    private void mergeCollections(RelationshipDescription relationshipDescription, Collection<?> values, Map<Object, Object> mergedValues) {
        for (Object existingValueInCollection : values) {
            Object existingIdPropertyValue;
            if (relationshipDescription.hasRelationshipProperties()) {
                existingIdPropertyValue = ((Neo4jPersistentEntity)relationshipDescription.getRelationshipPropertiesEntity()).getPropertyAccessor(existingValueInCollection).getProperty(((Neo4jPersistentEntity)relationshipDescription.getRelationshipPropertiesEntity()).getIdProperty());
                mergedValues.put(existingIdPropertyValue, existingValueInCollection);
                continue;
            }
            if (relationshipDescription.isDynamic()) continue;
            existingIdPropertyValue = ((Neo4jPersistentEntity)relationshipDescription.getTarget()).getPropertyAccessor(existingValueInCollection).getProperty(((Neo4jPersistentEntity)relationshipDescription.getTarget()).getIdProperty());
            mergedValues.put(existingIdPropertyValue, existingValueInCollection);
        }
    }

    private Optional<Object> createInstanceOfRelationships(Neo4jPersistentProperty persistentProperty, MapAccessor values, RelationshipDescription relationshipDescription, NodeDescription<?> baseDescription, Collection<Relationship> relationshipsFromResult, Collection<Node> nodesFromResult) {
        return this.createInstanceOfRelationships(persistentProperty, values, relationshipDescription, baseDescription, relationshipsFromResult, nodesFromResult, true);
    }

    private Optional<Object> createInstanceOfRelationships(Neo4jPersistentProperty persistentProperty, MapAccessor values, RelationshipDescription relationshipDescription, NodeDescription<?> baseDescription, Collection<Relationship> relationshipsFromResult, Collection<Node> nodesFromResult, boolean fetchMore) {
        boolean hasIdValue;
        BiConsumer<String, Object> mappedObjectHandler;
        String typeOfRelationship = relationshipDescription.getType();
        String targetLabel = relationshipDescription.getTarget().getPrimaryLabel();
        Neo4jPersistentEntity genericTargetNodeDescription = (Neo4jPersistentEntity)relationshipDescription.getTarget();
        ArrayList value = new ArrayList();
        HashMap dynamicValue = new HashMap();
        Function<Object, Object> keyTransformer = persistentProperty.isDynamicAssociation() && persistentProperty.getComponentType().isEnum() ? f -> this.conversionService.convert(f, persistentProperty.getComponentType()) : Function.identity();
        if (persistentProperty.isDynamicOneToManyAssociation()) {
            TypeInformation actualType = persistentProperty.getTypeInformation().getRequiredActualType();
            mappedObjectHandler = (type, mappedObject) -> {
                List bucket = (List)dynamicValue.computeIfAbsent(keyTransformer.apply(type), s -> CollectionFactory.createCollection((Class)actualType.getType(), (Class)persistentProperty.getAssociationTargetType(), (int)values.size()));
                bucket.add(mappedObject);
            };
        } else {
            mappedObjectHandler = persistentProperty.isDynamicAssociation() ? (type, mappedObject) -> dynamicValue.put(keyTransformer.apply(type), mappedObject) : (type, mappedObject) -> value.add(mappedObject);
        }
        String collectionName = relationshipDescription.generateRelatedNodesCollectionName(baseDescription);
        Value list = values.get(collectionName);
        boolean relationshipListEmptyOrNull = Values.NULL.equals((Object)list);
        if (relationshipListEmptyOrNull) {
            collectionName = collectionName.replaceFirst("_" + relationshipDescription.isOutgoing() + "\\z", "");
        }
        list = values.get(collectionName);
        relationshipListEmptyOrNull = Values.NULL.equals((Object)list);
        ArrayList relationshipsAndProperties = new ArrayList();
        String elementId = IdentitySupport.getElementId(values);
        Long internalId = IdentitySupport.getInternalId(values);
        boolean bl = hasIdValue = elementId != null || internalId != null;
        if (relationshipListEmptyOrNull && hasIdValue) {
            Function<Relationship, String> sourceIdSelector;
            Object sourceNodeId;
            Function<Relationship, String> targetIdSelector;
            Function<Relationship, String> function = targetIdSelector = relationshipDescription.isIncoming() ? Relationship::startNodeElementId : Relationship::endNodeElementId;
            if (elementId != null) {
                sourceNodeId = elementId;
                sourceIdSelector = relationshipDescription.isIncoming() ? Relationship::endNodeElementId : Relationship::startNodeElementId;
            } else {
                sourceNodeId = Long.toString(internalId);
                Function<Relationship, Long> hlp = relationshipDescription.isIncoming() ? Relationship::endNodeId : Relationship::startNodeId;
                sourceIdSelector = hlp.andThen(l -> Long.toString(l));
            }
            Collection<Relationship> allMatchingTypeRelationshipsInResult = this.extractMatchingRelationships(relationshipsFromResult, relationshipDescription, typeOfRelationship, arg_0 -> DefaultNeo4jEntityConverter.lambda$createInstanceOfRelationships$14(sourceIdSelector, (String)sourceNodeId, arg_0));
            if (!allMatchingTypeRelationshipsInResult.isEmpty()) {
                Collection<Node> allNodesWithMatchingLabelInResult = this.extractMatchingNodes(nodesFromResult, targetLabel);
                for (Node possibleValueNode : allNodesWithMatchingLabelInResult) {
                    String targetNodeId = IdentitySupport.getElementId((Entity)possibleValueNode);
                    Neo4jPersistentEntity<?> concreteTargetNodeDescription = this.getMostConcreteTargetNodeDescription(genericTargetNodeDescription, (MapAccessor)possibleValueNode);
                    HashSet<Relationship> relationshipsProcessed = new HashSet<Relationship>();
                    for (Relationship possibleRelationship : allMatchingTypeRelationshipsInResult) {
                        Object mappedObject2;
                        if (!targetIdSelector.apply(possibleRelationship).equals(targetNodeId)) continue;
                        String direction = relationshipDescription.getDirection().name();
                        if (this.knownObjects.hasProcessedRelationshipCompletely("R" + direction + IdentitySupport.getElementId((Entity)possibleRelationship))) {
                            relationshipsFromResult.remove(possibleRelationship);
                        }
                        if (fetchMore) {
                            mappedObject2 = sourceNodeId != null && ((String)sourceNodeId).equals(targetNodeId) ? this.knownObjects.getObject("N" + (String)sourceNodeId) : this.map((MapAccessor)possibleValueNode, concreteTargetNodeDescription, baseDescription, null, null, relationshipsFromResult, nodesFromResult);
                        } else {
                            Object objectFromStore = this.knownObjects.getObject("N" + targetNodeId);
                            Object object = mappedObject2 = objectFromStore != null ? objectFromStore : this.map((MapAccessor)possibleValueNode, concreteTargetNodeDescription, baseDescription, null, null, relationshipsFromResult, nodesFromResult);
                        }
                        if (relationshipDescription.hasRelationshipProperties()) {
                            Object objectFromStore;
                            Neo4jPersistentEntity relationshipPropertiesEntity = (Neo4jPersistentEntity)relationshipDescription.getRelationshipPropertiesEntity();
                            Object relationshipProperties = fetchMore ? this.map((MapAccessor)possibleRelationship, relationshipPropertiesEntity, relationshipPropertiesEntity, mappedObject2, relationshipDescription, relationshipsFromResult, nodesFromResult) : ((objectFromStore = this.knownObjects.getObject(IdentitySupport.getPrefixedElementId((MapAccessor)possibleRelationship, relationshipDescription.getDirection().name()))) != null ? objectFromStore : this.map((MapAccessor)possibleRelationship, relationshipPropertiesEntity, relationshipPropertiesEntity, mappedObject2, relationshipDescription, relationshipsFromResult, nodesFromResult));
                            relationshipsAndProperties.add(relationshipProperties);
                            mappedObjectHandler.accept(possibleRelationship.type(), relationshipProperties);
                        } else {
                            mappedObjectHandler.accept(possibleRelationship.type(), mappedObject2);
                        }
                        relationshipsProcessed.add(possibleRelationship);
                    }
                    allMatchingTypeRelationshipsInResult.removeAll(relationshipsProcessed);
                }
            }
        } else if (!relationshipListEmptyOrNull) {
            for (Value relatedEntity : list.asList(Function.identity())) {
                Object valueEntry;
                Neo4jPersistentEntity<?> concreteTargetNodeDescription = this.getMostConcreteTargetNodeDescription(genericTargetNodeDescription, (MapAccessor)relatedEntity);
                if (fetchMore) {
                    valueEntry = this.map((MapAccessor)relatedEntity, concreteTargetNodeDescription, genericTargetNodeDescription, null, null, relationshipsFromResult, nodesFromResult);
                } else {
                    Object objectFromStore = this.knownObjects.getObject(IdentitySupport.getPrefixedElementId((MapAccessor)relatedEntity, null));
                    Object obj = valueEntry = objectFromStore != null ? objectFromStore : this.map((MapAccessor)relatedEntity, concreteTargetNodeDescription, genericTargetNodeDescription, null, null, relationshipsFromResult, nodesFromResult);
                }
                if (relationshipDescription.hasRelationshipProperties()) {
                    Object objectFromStore;
                    String sourceLabel = relationshipDescription.getSource().getMostAbstractParentLabel(baseDescription);
                    String relationshipSymbolicName = sourceLabel + "__relationship__" + targetLabel;
                    Relationship relatedEntityRelationship = relatedEntity.get(relationshipSymbolicName).asRelationship();
                    Neo4jPersistentEntity relationshipPropertiesEntity = (Neo4jPersistentEntity)relationshipDescription.getRelationshipPropertiesEntity();
                    Object relationshipProperties = fetchMore ? this.map((MapAccessor)relatedEntityRelationship, relationshipPropertiesEntity, relationshipPropertiesEntity, valueEntry, relationshipDescription, relationshipsFromResult, nodesFromResult) : ((objectFromStore = this.knownObjects.getObject(IdentitySupport.getPrefixedElementId((MapAccessor)relatedEntityRelationship, relationshipDescription.getDirection().name()))) != null ? objectFromStore : this.map((MapAccessor)relatedEntityRelationship, relationshipPropertiesEntity, relationshipPropertiesEntity, valueEntry, relationshipDescription, relationshipsFromResult, nodesFromResult));
                    relationshipsAndProperties.add(relationshipProperties);
                    mappedObjectHandler.accept(relatedEntity.get("__relationshipType__").asString(), relationshipProperties);
                    continue;
                }
                mappedObjectHandler.accept(relatedEntity.get("__relationshipType__").asString(), valueEntry);
            }
        }
        if (persistentProperty.getTypeInformation().isCollectionLike()) {
            ArrayList returnedValues = relationshipDescription.hasRelationshipProperties() ? relationshipsAndProperties : value;
            Collection target = CollectionFactory.createCollection((Class)persistentProperty.getRawType(), (Class)persistentProperty.getComponentType(), (int)returnedValues.size());
            target.addAll(returnedValues);
            return Optional.of(target);
        }
        if (relationshipDescription.isDynamic()) {
            return Optional.ofNullable(dynamicValue.isEmpty() ? null : dynamicValue);
        }
        if (relationshipDescription.hasRelationshipProperties()) {
            return Optional.ofNullable(relationshipsAndProperties.isEmpty() ? null : (Object)relationshipsAndProperties.get(0));
        }
        return Optional.ofNullable(value.isEmpty() ? null : (Object)value.get(0));
    }

    private Collection<Node> extractMatchingNodes(Collection<Node> allNodesInResult, String targetLabel) {
        return this.labelNodeCache.computeIfAbsent(targetLabel, label -> {
            Predicate<Node> onlyWithMatchingLabels = n -> n.hasLabel(label);
            return allNodesInResult.stream().filter(onlyWithMatchingLabels).collect(Collectors.toList());
        });
    }

    private Collection<Node> extractNodes(MapAccessor allValues) {
        LinkedHashSet<Node> allNodesInResult = new LinkedHashSet<Node>();
        StreamSupport.stream(allValues.values().spliterator(), false).filter(MappingSupport.isListContainingOnly(this.listType, this.nodeType)).flatMap(entry -> MappingSupport.extractNodesFromCollection(this.listType, entry).stream()).forEach(allNodesInResult::add);
        StreamSupport.stream(allValues.values().spliterator(), false).filter(arg_0 -> ((Type)this.nodeType).isTypeOf(arg_0)).map(Value::asNode).forEach(allNodesInResult::add);
        return allNodesInResult;
    }

    private Collection<Relationship> extractMatchingRelationships(Collection<Relationship> relationshipsFromResult, RelationshipDescription relationshipDescription, String typeOfRelationship, Predicate<Relationship> relationshipPredicate) {
        Predicate<Relationship> onlyWithMatchingType = r -> r.type().equals(typeOfRelationship) || relationshipDescription.isDynamic();
        return relationshipsFromResult.stream().filter(onlyWithMatchingType.and(relationshipPredicate)).collect(Collectors.toList());
    }

    private Collection<Relationship> extractRelationships(MapAccessor allValues) {
        LinkedHashSet<Relationship> allRelationshipsInResult = new LinkedHashSet<Relationship>();
        StreamSupport.stream(allValues.values().spliterator(), false).filter(MappingSupport.isListContainingOnly(this.listType, this.relationshipType)).flatMap(entry -> MappingSupport.extractRelationshipsFromCollection(this.listType, entry).stream()).forEach(allRelationshipsInResult::add);
        StreamSupport.stream(allValues.values().spliterator(), false).filter(arg_0 -> ((Type)this.relationshipType).isTypeOf(arg_0)).map(Value::asRelationship).forEach(allRelationshipsInResult::add);
        return allRelationshipsInResult;
    }

    private static Value extractValueOf(Neo4jPersistentProperty property, MapAccessor propertyContainer) {
        if (property.isInternalIdProperty()) {
            if (Neo4jPersistentEntity.DEPRECATED_GENERATED_ID_TYPES.contains(property.getType())) {
                return Values.value((Object)IdentitySupport.getInternalId(propertyContainer));
            }
            return Values.value((String)IdentitySupport.getElementId(propertyContainer));
        }
        if (property.isComposite()) {
            String prefix = property.computePrefixWithDelimiter();
            if (propertyContainer.containsKey("__allProperties__")) {
                return DefaultNeo4jEntityConverter.extractCompositePropertyValues((MapAccessor)propertyContainer.get("__allProperties__"), prefix);
            }
            return DefaultNeo4jEntityConverter.extractCompositePropertyValues(propertyContainer, prefix);
        }
        String graphPropertyName = property.getPropertyName();
        if (propertyContainer.containsKey(graphPropertyName)) {
            return propertyContainer.get(graphPropertyName);
        }
        if (propertyContainer.containsKey("__allProperties__")) {
            return propertyContainer.get("__allProperties__").get(graphPropertyName);
        }
        return Values.NULL;
    }

    private static Value extractCompositePropertyValues(MapAccessor propertyContainer, String prefix) {
        HashMap hlp = new HashMap(propertyContainer.size());
        propertyContainer.keys().forEach(k -> {
            if (k.startsWith(prefix)) {
                hlp.put(k, propertyContainer.get(k));
            }
        });
        return Values.value(hlp);
    }

    private static /* synthetic */ boolean lambda$createInstanceOfRelationships$14(Function sourceIdSelector, String sourceNodeId, Relationship possibleRelationship) {
        return ((String)sourceIdSelector.apply(possibleRelationship)).equals(sourceNodeId);
    }

    static class KnownObjects {
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private final Lock read = this.lock.readLock();
        private final Lock write = this.lock.writeLock();
        private final Map<String, Object> internalIdStore = new HashMap<String, Object>();
        private final Map<String, Boolean> internalCurrentRecord = new HashMap<String, Boolean>();
        private final Set<String> previousRecords = new HashSet<String>();
        private final Set<String> idsInCreation = new HashSet<String>();
        private final Map<String, Integer> processedRelationships = new HashMap<String, Integer>();
        private final Map<String, Set<Map<String, Object>>> mappedQueryResults = new HashMap<String, Set<Map<String, Object>>>();

        KnownObjects() {
        }

        private void storeObject(@Nullable String internalId, Object object) {
            if (internalId == null) {
                return;
            }
            try {
                this.write.lock();
                this.idsInCreation.remove(internalId);
                this.internalIdStore.put(internalId, object);
                this.internalCurrentRecord.put(internalId, false);
            }
            finally {
                this.write.unlock();
            }
        }

        private void setInCreation(@Nullable String internalId) {
            if (internalId == null) {
                return;
            }
            try {
                this.write.lock();
                this.idsInCreation.add(internalId);
            }
            finally {
                this.write.unlock();
            }
        }

        private boolean isInCreation(@Nullable String internalId) {
            if (internalId == null) {
                return false;
            }
            try {
                this.read.lock();
                boolean bl = this.idsInCreation.contains(internalId);
                return bl;
            }
            finally {
                this.read.unlock();
            }
        }

        private boolean containsNode(Node node) {
            try {
                this.read.lock();
                boolean bl = this.internalIdStore.containsKey(IdentitySupport.getElementId((Entity)node));
                return bl;
            }
            finally {
                this.read.unlock();
            }
        }

        @Nullable
        private Object getObject(@Nullable String internalId) {
            if (internalId == null) {
                return null;
            }
            try {
                this.read.lock();
                if (this.isInCreation(internalId)) {
                    throw new MappingException(String.format("The node with id %s has a logical cyclic mapping dependency; its creation caused the creation of another node that has a reference to this", internalId.substring(1)));
                }
                Object object = this.internalIdStore.get(internalId);
                return object;
            }
            finally {
                this.read.unlock();
            }
        }

        private void removeFromInCreation(@Nullable String internalId) {
            if (internalId == null) {
                return;
            }
            try {
                this.write.lock();
                this.idsInCreation.remove(internalId);
            }
            finally {
                this.write.unlock();
            }
        }

        private boolean alreadyMappedInPreviousRecord(@Nullable String internalId) {
            if (internalId == null) {
                return false;
            }
            try {
                this.read.lock();
                boolean bl = this.previousRecords.contains(internalId) || this.internalCurrentRecord.get(internalId) != false;
                return bl;
            }
            finally {
                this.read.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean hasProcessedRelationshipCompletely(String relationshipId) {
            try {
                this.write.lock();
                int processedAmount = this.processedRelationships.computeIfAbsent(relationshipId, s -> 0);
                if (processedAmount == 2) {
                    boolean bl = true;
                    return bl;
                }
                this.processedRelationships.put(relationshipId, processedAmount + 1);
                boolean bl = false;
                return bl;
            }
            finally {
                this.write.unlock();
            }
        }

        private void nextRecord() {
            this.previousRecords.addAll(this.internalCurrentRecord.keySet());
            this.internalCurrentRecord.clear();
        }

        private void mappedWithQueryResult(String internalId, MapAccessor queryResult) {
            try {
                this.write.lock();
                this.mappedQueryResults.computeIfAbsent(internalId, id -> ConcurrentHashMap.newKeySet()).add(queryResult.asMap());
            }
            finally {
                this.write.unlock();
            }
        }

        private Set<Map<String, Object>> getQueryResultsFor(String internalId) {
            try {
                this.read.lock();
                Set<Map<String, Object>> set = this.mappedQueryResults.get(internalId);
                return set;
            }
            finally {
                this.read.unlock();
            }
        }
    }
}

