/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import org.apiguardian.api.API;
import org.neo4j.driver.Driver;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.config.Neo4jConfigurationSupport;
import org.springframework.data.neo4j.core.DatabaseSelectionProvider;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jOperations;
import org.springframework.data.neo4j.core.Neo4jTemplate;
import org.springframework.data.neo4j.core.UserSelectionProvider;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.transaction.Neo4jBookmarkManager;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionManager;
import org.springframework.lang.Nullable;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@API(status=API.Status.STABLE, since="6.0")
public abstract class AbstractNeo4jConfig
extends Neo4jConfigurationSupport {
    @Autowired
    private ObjectProvider<UserSelectionProvider> userSelectionProviders;
    @Autowired
    private Neo4jBookmarkManager bookmarkManager;

    public abstract Driver driver();

    @Bean(value={"neo4jClient"})
    public Neo4jClient neo4jClient(Driver driver, DatabaseSelectionProvider databaseSelectionProvider) {
        return Neo4jClient.with(driver).withDatabaseSelectionProvider(databaseSelectionProvider).withUserSelectionProvider(this.getUserSelectionProvider()).withNeo4jBookmarkManager(this.bookmarkManager).build();
    }

    @Nullable
    private UserSelectionProvider getUserSelectionProvider() {
        return this.userSelectionProviders == null ? null : (UserSelectionProvider)this.userSelectionProviders.getIfUnique();
    }

    @Bean(value={"neo4jTemplate"})
    public Neo4jOperations neo4jTemplate(Neo4jClient neo4jClient, Neo4jMappingContext mappingContext) {
        return new Neo4jTemplate(neo4jClient, mappingContext);
    }

    @Bean(value={"transactionManager"})
    public PlatformTransactionManager transactionManager(Driver driver, DatabaseSelectionProvider databaseSelectionProvider) {
        return Neo4jTransactionManager.with(driver).withDatabaseSelectionProvider(databaseSelectionProvider).withUserSelectionProvider(this.getUserSelectionProvider()).withBookmarkManager(this.bookmarkManager).build();
    }

    @Bean
    public Neo4jBookmarkManager bookmarkManager() {
        return Neo4jBookmarkManager.create();
    }

    @Bean
    protected DatabaseSelectionProvider databaseSelectionProvider() {
        return DatabaseSelectionProvider.getDefaultSelectionProvider();
    }
}

