/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.transaction;

import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.neo4j.driver.Bookmark;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.neo4j.core.transaction.DefaultBookmarkManager;
import org.springframework.data.neo4j.core.transaction.NoopBookmarkManager;
import org.springframework.lang.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@API(status=API.Status.STABLE, since="6.1.1")
public interface Neo4jBookmarkManager {
    public static Neo4jBookmarkManager create() {
        return new DefaultBookmarkManager(null);
    }

    public static Neo4jBookmarkManager create(@Nullable Supplier<Set<Bookmark>> bookmarksSupplier) {
        return new DefaultBookmarkManager(bookmarksSupplier);
    }

    @API(status=API.Status.STABLE, since="6.1.11")
    public static Neo4jBookmarkManager noop() {
        return NoopBookmarkManager.INSTANCE;
    }

    public Collection<Bookmark> getBookmarks();

    public void updateBookmarks(Collection<Bookmark> var1, Collection<Bookmark> var2);

    default public void setApplicationEventPublisher(@Nullable ApplicationEventPublisher applicationEventPublisher) {
    }
}

