/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.core.log.LogAccessor;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.domain.Range;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metrics;
import org.springframework.data.neo4j.core.TemplateSupport;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverter;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.EntityInstanceWithSource;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.repository.query.BoundingBox;
import org.springframework.data.neo4j.repository.query.Neo4jNestedMapEntityWriter;
import org.springframework.data.neo4j.repository.query.Neo4jParameterAccessor;
import org.springframework.data.neo4j.repository.query.Neo4jQueryMethod;
import org.springframework.data.neo4j.repository.query.Neo4jQueryType;
import org.springframework.data.neo4j.repository.query.Neo4jSpelSupport;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

abstract class Neo4jQuerySupport {
    protected static final SpelExpressionParser SPEL_EXPRESSION_PARSER = new SpelExpressionParser();
    protected final Neo4jMappingContext mappingContext;
    protected final Neo4jQueryMethod queryMethod;
    protected final Neo4jQueryType queryType;
    private static final Set<Class<?>> VALID_RETURN_TYPES_FOR_DELETE = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Long.class, Long.TYPE, Void.class, Void.TYPE)));
    static final LogAccessor REPOSITORY_QUERY_LOG = new LogAccessor(LogFactory.getLog(Neo4jQuerySupport.class));

    static Class<?> getDomainType(QueryMethod queryMethod) {
        return queryMethod.getResultProcessor().getReturnedType().getDomainType();
    }

    Neo4jQuerySupport(Neo4jMappingContext mappingContext, Neo4jQueryMethod queryMethod, Neo4jQueryType queryType) {
        Assert.notNull((Object)mappingContext, (String)"The mapping context is required");
        Assert.notNull((Object)((Object)queryMethod), (String)"Query method must not be null");
        Assert.notNull((Object)((Object)queryType), (String)"Query type must not be null");
        Assert.isTrue((queryType != Neo4jQueryType.DELETE || Neo4jQuerySupport.hasValidReturnTypeForDelete(queryMethod) ? 1 : 0) != 0, (String)"A derived delete query can only return the number of deleted nodes as a long or void");
        this.mappingContext = mappingContext;
        this.queryMethod = queryMethod;
        this.queryType = queryType;
    }

    protected final Supplier<BiFunction<TypeSystem, MapAccessor, ?>> getMappingFunction(ResultProcessor resultProcessor) {
        return () -> {
            ReturnedType returnedTypeMetadata = resultProcessor.getReturnedType();
            Class returnedType = returnedTypeMetadata.getReturnedType();
            Class domainType = returnedTypeMetadata.getDomainType();
            BiFunction<TypeSystem, MapAccessor, ?> mappingFunction = this.mappingContext.getConversionService().isSimpleType(returnedType) ? null : (returnedTypeMetadata.isProjecting() ? EntityInstanceWithSource.decorateMappingFunction(this.mappingContext.getRequiredMappingFunctionFor(domainType)) : this.mappingContext.getRequiredMappingFunctionFor(domainType));
            return mappingFunction;
        };
    }

    private static boolean hasValidReturnTypeForDelete(Neo4jQueryMethod queryMethod) {
        return VALID_RETURN_TYPES_FOR_DELETE.contains(queryMethod.getResultProcessor().getReturnedType().getReturnedType());
    }

    static void logParameterIfNull(String name, Object value) {
        if (value != null || !REPOSITORY_QUERY_LOG.isDebugEnabled()) {
            return;
        }
        Supplier<CharSequence> messageSupplier = () -> {
            String pointer = name == null || name.trim().isEmpty() ? "An unknown parameter" : "$" + name;
            return String.format("%s points to a literal `null` value during a comparison. The comparisons will always resolve to false and probably lead to an empty result.", pointer);
        };
        REPOSITORY_QUERY_LOG.debug(messageSupplier);
    }

    final Object convertParameter(Object parameter) {
        return this.convertParameter(parameter, null);
    }

    final Object convertParameter(Object parameter, @Nullable Neo4jPersistentPropertyConverter<?> conversionOverride) {
        Collection col;
        Class<?> type;
        if (parameter == null) {
            return Values.NULL;
        }
        if (parameter instanceof Range) {
            Range v2 = (Range)parameter;
            return this.convertRange(v2);
        }
        if (parameter instanceof Distance) {
            Distance v3 = (Distance)parameter;
            return Neo4jQuerySupport.calculateDistanceInMeter(v3);
        }
        if (parameter instanceof Circle) {
            Circle v4 = (Circle)parameter;
            return this.convertCircle(v4);
        }
        if (parameter instanceof Instant) {
            Instant v5 = (Instant)parameter;
            return v5.atOffset(ZoneOffset.UTC);
        }
        if (parameter instanceof Box) {
            Box v6 = (Box)parameter;
            return this.convertBox(v6);
        }
        if (parameter instanceof BoundingBox) {
            BoundingBox v7 = (BoundingBox)parameter;
            return this.convertBoundingBox(v7);
        }
        if (parameter instanceof Collection && (type = TemplateSupport.findCommonElementType(col = (Collection)parameter)) != null && this.mappingContext.hasPersistentEntityFor(type)) {
            EntityWriter<Object, Map<String, Object>> objectMapEntityWriter = Neo4jNestedMapEntityWriter.forContext(this.mappingContext);
            return col.stream().map(v -> {
                HashMap result = new HashMap();
                objectMapEntityWriter.write(v, result);
                return result;
            }).collect(Collectors.toList());
        }
        if (this.mappingContext.hasPersistentEntityFor(parameter.getClass())) {
            HashMap result = new HashMap();
            Neo4jNestedMapEntityWriter.forContext(this.mappingContext).write(parameter, result);
            return result;
        }
        return this.mappingContext.getConversionService().writeValue(parameter, TypeInformation.of(parameter.getClass()), conversionOverride);
    }

    void replaceLiteralsIn(QueryContext queryContext) {
        String cypherQuery = queryContext.template;
        Iterator<Map.Entry<String, Object>> iterator = queryContext.boundParameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            Object value = entry.getValue();
            if (!(value instanceof Neo4jSpelSupport.LiteralReplacement)) continue;
            iterator.remove();
            String key = entry.getKey();
            cypherQuery = cypherQuery.replace("$" + key, ((Neo4jSpelSupport.LiteralReplacement)value).getValue());
            queryContext.hasLiteralReplacementForSort = queryContext.hasLiteralReplacementForSort || ((Neo4jSpelSupport.LiteralReplacement)value).getTarget() == Neo4jSpelSupport.LiteralReplacement.Target.SORT;
        }
        queryContext.query = cypherQuery;
    }

    void logWarningsIfNecessary(QueryContext queryContext, Neo4jParameterAccessor parameterAccessor) {
        if (!queryContext.hasLiteralReplacementForSort && !parameterAccessor.getSort().isUnsorted()) {
            REPOSITORY_QUERY_LOG.warn(() -> String.format("You passed a sorted request to the custom query for '%s'. SDN won't apply any sort information from that object to the query. Please specify the order in the query itself and use an unsorted request or use the SpEL extension `:#{orderBy(#sort)}`.", queryContext.repositoryMethodName));
            String fragment = CypherGenerator.INSTANCE.createOrderByFragment(parameterAccessor.getSort());
            if (fragment != null) {
                REPOSITORY_QUERY_LOG.warn(() -> String.format("One possible order clause matching your page request would be the following fragment:%n%s", fragment));
            }
        }
    }

    private Map<String, Object> convertRange(Range<?> range) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        range.getLowerBound().getValue().map(this::convertParameter).ifPresent(v -> map.put("lb", v));
        range.getUpperBound().getValue().map(this::convertParameter).ifPresent(v -> map.put("ub", v));
        return map;
    }

    private Map<String, Object> convertCircle(Circle circle) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x", this.convertParameter(circle.getCenter().getX()));
        map.put("y", this.convertParameter(circle.getCenter().getY()));
        map.put("radius", this.convertParameter(Neo4jQuerySupport.calculateDistanceInMeter(circle.getRadius())));
        return map;
    }

    private Map<String, Object> convertBox(Box box) {
        BoundingBox boundingBox = BoundingBox.of(box);
        return this.convertBoundingBox(boundingBox);
    }

    private Map<String, Object> convertBoundingBox(BoundingBox boundingBox) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("llx", this.convertParameter(boundingBox.getLowerLeft().getX()));
        map.put("lly", this.convertParameter(boundingBox.getLowerLeft().getY()));
        map.put("urx", this.convertParameter(boundingBox.getUpperRight().getX()));
        map.put("ury", this.convertParameter(boundingBox.getUpperRight().getY()));
        return map;
    }

    private static double calculateDistanceInMeter(Distance distance) {
        if (distance.getMetric() == Metrics.KILOMETERS) {
            double kilometersDivisor = 0.001;
            return distance.getValue() / kilometersDivisor;
        }
        if (distance.getMetric() == Metrics.MILES) {
            double milesDivisor = 6.2137E-4;
            return distance.getValue() / milesDivisor;
        }
        return distance.getValue();
    }

    static class QueryContext {
        final String repositoryMethodName;
        final String template;
        final Map<String, Object> boundParameters;
        String query;
        private boolean hasLiteralReplacementForSort = false;

        QueryContext(String repositoryMethodName, String template, Map<String, Object> boundParameters) {
            this.repositoryMethodName = repositoryMethodName;
            this.query = this.template = template;
            this.boundParameters = boundParameters;
        }
    }
}

