/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.apiguardian.api.API;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.schema.TargetNode;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL)
public final class PropertyTraverser {
    private final Neo4jMappingContext ctx;
    private final Set<Association<?>> pathsTraversed = new HashSet();

    public PropertyTraverser(Neo4jMappingContext ctx) {
        this.ctx = ctx;
    }

    public void traverse(Class<?> root, BiConsumer<PropertyPath, Neo4jPersistentProperty> sink) {
        this.traverse(root, (path, toProperty) -> true, sink);
    }

    public synchronized void traverse(Class<?> root, BiPredicate<PropertyPath, Neo4jPersistentProperty> predicate, BiConsumer<PropertyPath, Neo4jPersistentProperty> sink) {
        this.pathsTraversed.clear();
        this.traverseImpl((Neo4jPersistentEntity)this.ctx.getRequiredPersistentEntity(root), null, predicate, sink, false);
    }

    private void traverseImpl(Neo4jPersistentEntity<?> root, @Nullable PropertyPath base, BiPredicate<PropertyPath, Neo4jPersistentProperty> predicate, BiConsumer<PropertyPath, Neo4jPersistentProperty> sink, boolean pathAlreadyVisited) {
        TreeSet<Neo4jPersistentProperty> sortedProperties = new TreeSet<Neo4jPersistentProperty>(Comparator.comparing(PersistentProperty::getName));
        root.doWithAll(sortedProperties::add);
        sortedProperties.forEach(p -> {
            PropertyPath path;
            PropertyPath propertyPath = path = base == null ? PropertyPath.from((String)p.getName(), (Class)p.getOwner().getType()) : base.nested(p.getName());
            if (!predicate.test(path, (Neo4jPersistentProperty)p)) {
                return;
            }
            sink.accept(path, (Neo4jPersistentProperty)p);
            if (p.isAssociation() && !pathAlreadyVisited && !p.isAnnotationPresent(TargetNode.class)) {
                Class associationTargetType = p.getAssociationTargetType();
                if (associationTargetType == null) {
                    return;
                }
                Neo4jPersistentEntity targetEntity = (Neo4jPersistentEntity)this.ctx.getRequiredPersistentEntity(associationTargetType);
                boolean recalledForProperties = this.pathsTraversed.contains(p.getAssociation());
                this.pathsTraversed.add(p.getAssociation());
                this.traverseImpl(targetEntity, path, predicate, sink, recalledForProperties);
            }
        });
    }
}

