/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.schema.Property;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

@API(status=API.Status.INTERNAL)
public abstract class PropertyFilter {
    public static PropertyFilter from(Collection<ProjectedPath> projectedPaths, NodeDescription<?> nodeDescription) {
        return new FilteringPropertyFilter(projectedPaths, nodeDescription);
    }

    public static PropertyFilter acceptAll() {
        return new NonFilteringPropertyFilter();
    }

    public abstract boolean contains(String var1, Class<?> var2);

    public abstract boolean contains(RelaxedPropertyPath var1);

    public abstract boolean isNotFiltering();

    static String toDotPath(RelaxedPropertyPath propertyPath, @Nullable String lastSegment) {
        if (lastSegment == null) {
            return propertyPath.toDotPath();
        }
        return propertyPath.replaceLastSegment(lastSegment).toDotPath();
    }

    public static class ProjectedPath {
        final RelaxedPropertyPath propertyPath;
        final boolean isEntity;

        public ProjectedPath(RelaxedPropertyPath propertyPath, boolean isEntity) {
            this.propertyPath = propertyPath;
            this.isEntity = isEntity;
        }
    }

    public static class RelaxedPropertyPath {
        private final String dotPath;
        private final Class<?> type;

        public static RelaxedPropertyPath withRootType(Class<?> type) {
            return new RelaxedPropertyPath("", type);
        }

        public String toDotPath() {
            return this.dotPath;
        }

        public String toDotPath(@Nullable String lastSegment) {
            if (lastSegment == null) {
                return this.toDotPath();
            }
            int idx = this.dotPath.lastIndexOf(46);
            if (idx < 0) {
                return lastSegment;
            }
            return this.dotPath.substring(0, idx + 1) + lastSegment;
        }

        public Class<?> getType() {
            return this.type;
        }

        private RelaxedPropertyPath(String dotPath, Class<?> type) {
            this.dotPath = dotPath;
            this.type = type;
        }

        public RelaxedPropertyPath append(String pathPart) {
            return new RelaxedPropertyPath(this.appendToDotPath(pathPart), this.getType());
        }

        public RelaxedPropertyPath prepend(String pathPart) {
            return new RelaxedPropertyPath(this.prependDotPathWith(pathPart), this.getType());
        }

        private String appendToDotPath(String pathPart) {
            return this.dotPath.isEmpty() ? pathPart : this.dotPath + "." + pathPart;
        }

        private String prependDotPathWith(String pathPart) {
            return this.dotPath.isEmpty() ? pathPart : pathPart + "." + this.dotPath;
        }

        public String getSegment() {
            int idx = this.dotPath.indexOf(".");
            if (idx < 0) {
                idx = this.dotPath.length();
            }
            return this.dotPath.substring(0, idx);
        }

        public RelaxedPropertyPath getLeafProperty() {
            int idx = this.dotPath.lastIndexOf(46);
            if (idx < 0) {
                return this;
            }
            return new RelaxedPropertyPath(this.dotPath.substring(idx + 1), this.type);
        }

        public RelaxedPropertyPath replaceLastSegment(@Nullable String lastSegment) {
            if (lastSegment == null) {
                return this;
            }
            return new RelaxedPropertyPath(this.getSegment().equals(this.dotPath) ? lastSegment : this.getSegment() + "." + lastSegment, this.type);
        }
    }

    private static class NonFilteringPropertyFilter
    extends PropertyFilter {
        private NonFilteringPropertyFilter() {
        }

        @Override
        public boolean contains(String dotPath, Class<?> typeToCheck) {
            return true;
        }

        @Override
        public boolean contains(RelaxedPropertyPath propertyPath) {
            return true;
        }

        @Override
        public boolean isNotFiltering() {
            return true;
        }
    }

    private static class FilteringPropertyFilter
    extends PropertyFilter {
        private final Set<Class<?>> rootClasses;
        private final Collection<ProjectedPath> projectingPropertyPaths;

        private FilteringPropertyFilter(Collection<ProjectedPath> projectedPaths, NodeDescription<?> nodeDescription) {
            Class<?> domainClass = nodeDescription.getUnderlyingClass();
            this.rootClasses = new HashSet();
            this.rootClasses.add(domainClass);
            projectedPaths.stream().map(property -> property.propertyPath.getType()).forEach(this.rootClasses::add);
            nodeDescription.getChildNodeDescriptionsInHierarchy().stream().map(NodeDescription::getUnderlyingClass).forEach(this.rootClasses::add);
            Neo4jPersistentEntity entity = (Neo4jPersistentEntity)nodeDescription;
            this.projectingPropertyPaths = new HashSet<ProjectedPath>();
            projectedPaths.forEach(propertyPath -> {
                String lastSegment = null;
                Neo4jPersistentProperty property = (Neo4jPersistentProperty)entity.getPersistentProperty(propertyPath.propertyPath.dotPath);
                if (property != null && property.findAnnotation(Property.class) != null) {
                    lastSegment = property.getPropertyName();
                }
                this.projectingPropertyPaths.add(new ProjectedPath(propertyPath.propertyPath.replaceLastSegment(lastSegment), propertyPath.isEntity));
            });
        }

        @Override
        public boolean contains(String dotPath, Class<?> typeToCheck) {
            if (this.isNotFiltering()) {
                return true;
            }
            if (!this.rootClasses.contains(typeToCheck)) {
                return false;
            }
            Optional<String> candidate = this.projectingPropertyPaths.stream().map(pp -> pp.propertyPath.toDotPath()).sorted((o1, o2) -> {
                int depth1 = StringUtils.countOccurrencesOf((String)o1, (String)".");
                int depth2 = StringUtils.countOccurrencesOf((String)o2, (String)".");
                return Integer.compare(depth2, depth1);
            }).filter(d -> dotPath.contains((CharSequence)d) && dotPath.startsWith((String)d)).findFirst();
            return this.projectingPropertyPaths.stream().map(pp -> pp.propertyPath.toDotPath()).anyMatch(ppDotPath -> ppDotPath.contains(dotPath)) || dotPath.contains(".") && candidate.isPresent() && this.projectingPropertyPaths.stream().filter((Predicate<ProjectedPath>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$contains$7(java.util.Optional org.springframework.data.neo4j.core.mapping.PropertyFilter$ProjectedPath ), (Lorg/springframework/data/neo4j/core/mapping/PropertyFilter$ProjectedPath;)Z)(candidate)).findFirst().get().isEntity;
        }

        @Override
        public boolean contains(RelaxedPropertyPath propertyPath) {
            return this.contains(propertyPath.toDotPath(), propertyPath.getType());
        }

        @Override
        public boolean isNotFiltering() {
            return this.projectingPropertyPaths.isEmpty();
        }

        private static /* synthetic */ boolean lambda$contains$7(Optional candidate, ProjectedPath pp) {
            return pp.propertyPath.toDotPath().equals(candidate.get());
        }
    }
}

