/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.driver.Value;
import org.springframework.data.neo4j.core.mapping.MapValueWrapper;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.0")
final class NamedParameters {
    private final Map<String, Object> parameters = new HashMap<String, Object>();

    NamedParameters() {
    }

    void addAll(Map<String, Object> newParameters) {
        newParameters.forEach(this::add);
    }

    void add(String name, @Nullable Object value) {
        if (this.parameters.containsKey(name)) {
            Object previousValue = this.parameters.get(name);
            throw new IllegalArgumentException(String.format("Duplicate parameter name: '%s' already in the list of named parameters with value '%s'. New value would be '%s'", name, previousValue == null ? "null" : previousValue.toString(), value == null ? "null" : value.toString()));
        }
        if ("__properties__".equals(name) && value != null) {
            this.parameters.put(name, NamedParameters.unwrapMapValueWrapper((Map)value));
        } else if ("__entities__".equals(name) && value != null) {
            this.parameters.put(name, this.unwrapMapValueWrapperInListOfEntities((List)value));
        } else {
            this.parameters.put(name, value);
        }
    }

    private List<Map<String, Object>> unwrapMapValueWrapperInListOfEntities(List<Map<String, Object>> entityList) {
        boolean requiresChange = entityList.stream().anyMatch(entity -> {
            if (!entity.containsKey("__properties__")) return false;
            if (!((Map)entity.get("__properties__")).values().stream().anyMatch(MapValueWrapper.class::isInstance)) return false;
            return true;
        });
        if (!requiresChange) {
            return entityList;
        }
        ArrayList<Map<String, Object>> newEntityList = new ArrayList<Map<String, Object>>(entityList.size());
        for (Map<String, Object> entity2 : entityList) {
            if (entity2.containsKey("__properties__")) {
                HashMap<String, Object> newEntity = new HashMap<String, Object>(entity2);
                newEntity.put("__properties__", NamedParameters.unwrapMapValueWrapper((Map)entity2.get("__properties__")));
                newEntityList.add(newEntity);
                continue;
            }
            newEntityList.add(entity2);
        }
        return newEntityList;
    }

    private static Map<String, Object> unwrapMapValueWrapper(Map<String, Object> properties) {
        if (properties.values().stream().noneMatch(MapValueWrapper.class::isInstance)) {
            return properties;
        }
        HashMap<String, Object> newProperties = new HashMap<String, Object>(properties.size());
        properties.forEach((k, v) -> {
            if (v instanceof MapValueWrapper) {
                Value mapValue = ((MapValueWrapper)v).getMapValue();
                mapValue.keys().forEach(k2 -> newProperties.put((String)k2, mapValue.get(k2)));
            } else {
                newProperties.put((String)k, v);
            }
        });
        return newProperties;
    }

    Map<String, Object> get() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public String toString() {
        return this.parameters.entrySet().stream().map(e -> String.format("%s: %s", e.getKey(), NamedParameters.formatValue(e.getValue()))).collect(Collectors.joining(", ", ":params {", "}"));
    }

    @Nullable
    private static String formatValue(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return Cypher.quote((String)((String)value));
        }
        if (value instanceof Map) {
            return ((Map)value).entrySet().stream().map(e -> String.format("%s: %s", e.getKey(), NamedParameters.formatValue(e.getValue()))).collect(Collectors.joining(", ", "{", "}"));
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(NamedParameters::formatValue).collect(Collectors.joining(", ", "[", "]"));
        }
        return value.toString();
    }
}

