/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.neo4j.core.Neo4jOperations;
import org.springframework.data.neo4j.core.PreparedQuery;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.repository.query.AbstractNeo4jQuery;
import org.springframework.data.neo4j.repository.query.CypherAdapterUtils;
import org.springframework.data.neo4j.repository.query.Neo4jParameterAccessor;
import org.springframework.data.neo4j.repository.query.Neo4jQueryMethod;
import org.springframework.data.neo4j.repository.query.Neo4jQueryType;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.util.Assert;

final class CypherdslBasedQuery
extends AbstractNeo4jQuery {
    static CypherdslBasedQuery create(Neo4jOperations neo4jOperations, Neo4jMappingContext mappingContext, Neo4jQueryMethod queryMethod, ProjectionFactory projectionFactory) {
        return new CypherdslBasedQuery(neo4jOperations, mappingContext, queryMethod, Neo4jQueryType.DEFAULT, projectionFactory);
    }

    private CypherdslBasedQuery(Neo4jOperations neo4jOperations, Neo4jMappingContext mappingContext, Neo4jQueryMethod queryMethod, Neo4jQueryType queryType, ProjectionFactory projectionFactory) {
        super(neo4jOperations, mappingContext, queryMethod, queryType, projectionFactory);
    }

    @Override
    protected <T> PreparedQuery<T> prepareQuery(Class<T> returnedType, List<PropertyPath> includedProperties, Neo4jParameterAccessor parameterAccessor, Neo4jQueryType queryType, BiFunction<TypeSystem, MapAccessor, ?> mappingFunction, UnaryOperator<Integer> limitModifier) {
        Statement statement;
        Object[] parameters = parameterAccessor.getValues();
        Assert.notEmpty((Object[])parameters, (String)"Cypher based query methods must provide at least a statement parameter.");
        if (this.queryMethod.isPageQuery()) {
            Assert.isInstanceOf(StatementBuilder.OngoingReadingAndReturn.class, (Object)parameters[0], (String)"The first parameter to a Cypher based method must be an ongoing reading with a defined return clause.");
            Assert.isInstanceOf(Statement.class, (Object)parameters[1], (String)"The second parameter to a Cypher based method must be a statement.");
            Assert.isInstanceOf(Pageable.class, (Object)parameters[2], (String)"The third parameter to a Cypher based method must be a page request.");
            Pageable pageable = (Pageable)parameters[2];
            statement = ((StatementBuilder.OngoingReadingAndReturn)parameters[0]).orderBy(CypherAdapterUtils.toSortItems(this.mappingContext.getNodeDescription(CypherdslBasedQuery.getDomainType(this.queryMethod)), pageable.getSort())).skip((Number)pageable.getOffset()).limit((Number)limitModifier.apply(pageable.getPageSize())).build();
        } else {
            Assert.isInstanceOf(Statement.class, (Object)parameters[0], (String)"The first parameter to a Cypher based method must be a statement.");
            statement = (Statement)parameters[0];
        }
        Map boundParameters = statement.getParameters();
        return PreparedQuery.queryFor(returnedType).withCypherQuery(statement.getCypher()).withParameters(boundParameters).usingMappingFunction(mappingFunction).build();
    }

    @Override
    protected Optional<PreparedQuery<Long>> getCountQuery(Neo4jParameterAccessor parameterAccessor) {
        Statement countStatement = (Statement)parameterAccessor.getValues()[1];
        return Optional.of(PreparedQuery.queryFor(Long.class).withCypherQuery(countStatement.getCypher()).withParameters(countStatement.getParameters()).build());
    }
}

