/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.support;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverter;

final class DateStringConverter
implements Neo4jPersistentPropertyConverter<Date> {
    private final String format;

    DateStringConverter(String format) {
        this.format = format;
    }

    private SimpleDateFormat getFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.format);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat;
    }

    @Override
    public Value write(Date source) {
        return Values.value((String)this.getFormat().format(source));
    }

    @Override
    public Date read(Value source) {
        try {
            return this.getFormat().parse(source.asString());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

