/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.MapAccessor;

final class RecordMapAccessor
implements MapAccessor {
    private final Record delegate;

    RecordMapAccessor(Record delegate) {
        this.delegate = delegate;
    }

    public Iterable<String> keys() {
        return this.delegate.keys();
    }

    public boolean containsKey(String key) {
        return this.delegate.containsKey(key);
    }

    public Value get(String key) {
        return this.delegate.get(key);
    }

    public int size() {
        return this.delegate.size();
    }

    public Iterable<Value> values() {
        return this.delegate.values();
    }

    public <T> Iterable<T> values(Function<Value, T> mapFunction) {
        return this.delegate.values().stream().map(mapFunction).collect(Collectors.toList());
    }

    public Map<String, Object> asMap() {
        return this.delegate.asMap();
    }

    public <T> Map<String, T> asMap(Function<Value, T> mapFunction) {
        return this.delegate.asMap(mapFunction);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

