/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.reactive.RxQueryRunner;
import org.neo4j.driver.reactive.RxResult;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.types.TypeSystem;
import org.reactivestreams.Publisher;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.DataAccessException;
import org.springframework.data.neo4j.core.DatabaseSelection;
import org.springframework.data.neo4j.core.DelegatingMappingFunctionWithNullCheck;
import org.springframework.data.neo4j.core.NamedParameters;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jPersistenceExceptionTranslator;
import org.springframework.data.neo4j.core.ReactiveDatabaseSelectionProvider;
import org.springframework.data.neo4j.core.ReactiveNeo4jClient;
import org.springframework.data.neo4j.core.ResultSummaries;
import org.springframework.data.neo4j.core.SingleValueMappingFunction;
import org.springframework.data.neo4j.core.convert.Neo4jConversions;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionUtils;
import org.springframework.data.neo4j.core.transaction.ReactiveNeo4jTransactionManager;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

class DefaultReactiveNeo4jClient
implements ReactiveNeo4jClient {
    private final Driver driver;
    private final TypeSystem typeSystem;
    private final ReactiveDatabaseSelectionProvider databaseSelectionProvider;
    private final ConversionService conversionService;
    private final Neo4jPersistenceExceptionTranslator persistenceExceptionTranslator = new Neo4jPersistenceExceptionTranslator();

    DefaultReactiveNeo4jClient(Driver driver, @Nullable ReactiveDatabaseSelectionProvider databaseSelectionProvider) {
        this.driver = driver;
        this.typeSystem = driver.defaultTypeSystem();
        this.databaseSelectionProvider = databaseSelectionProvider;
        this.conversionService = new DefaultConversionService();
        new Neo4jConversions().registerConvertersIn((ConverterRegistry)this.conversionService);
    }

    Mono<RxStatementRunnerHolder> retrieveRxStatementRunnerHolder(String targetDatabase) {
        return ReactiveNeo4jTransactionManager.retrieveReactiveTransaction(this.driver, targetDatabase).map(rxTransaction -> new RxStatementRunnerHolder((RxQueryRunner)rxTransaction, (Publisher<Void>)Mono.empty(), (Publisher<Void>)Mono.empty())).switchIfEmpty(Mono.using(() -> this.driver.rxSession(Neo4jTransactionUtils.defaultSessionConfig(targetDatabase)), session -> Mono.from((Publisher)session.beginTransaction()).map(tx -> new RxStatementRunnerHolder((RxQueryRunner)tx, (Publisher<Void>)tx.commit(), (Publisher<Void>)tx.rollback())), RxSession::close));
    }

    <T> Mono<T> doInQueryRunnerForMono(String targetDatabase, Function<RxQueryRunner, Mono<T>> func) {
        return Mono.usingWhen(this.retrieveRxStatementRunnerHolder(targetDatabase), holder -> (Mono)func.apply(holder.getRxQueryRunner()), RxStatementRunnerHolder::getCommit, (holder, ex) -> holder.getRollback(), RxStatementRunnerHolder::getCommit);
    }

    <T> Flux<T> doInStatementRunnerForFlux(String targetDatabase, Function<RxQueryRunner, Flux<T>> func) {
        return Flux.usingWhen(this.retrieveRxStatementRunnerHolder(targetDatabase), holder -> (Flux)func.apply(holder.getRxQueryRunner()), RxStatementRunnerHolder::getCommit, (holder, ex) -> holder.getRollback(), RxStatementRunnerHolder::getCommit);
    }

    @Override
    public ReactiveNeo4jClient.RunnableSpec query(String cypher) {
        return this.query(() -> cypher);
    }

    @Override
    public ReactiveNeo4jClient.RunnableSpec query(Supplier<String> cypherSupplier) {
        return new DefaultRunnableSpec(cypherSupplier);
    }

    @Override
    public <T> ReactiveNeo4jClient.OngoingDelegation<T> delegateTo(Function<RxQueryRunner, Mono<T>> callback) {
        return new DefaultRunnableDelegation<T>(callback);
    }

    @Override
    public ReactiveDatabaseSelectionProvider getDatabaseSelectionProvider() {
        return this.databaseSelectionProvider;
    }

    private RuntimeException potentiallyConvertRuntimeException(RuntimeException ex) {
        DataAccessException resolved = this.persistenceExceptionTranslator.translateExceptionIfPossible(ex);
        return resolved == null ? ex : resolved;
    }

    final class RxStatementRunnerHolder {
        private final RxQueryRunner rxQueryRunner;
        private final Publisher<Void> commit;
        private final Publisher<Void> rollback;

        RxStatementRunnerHolder(RxQueryRunner rxQueryRunner, Publisher<Void> commit, Publisher<Void> rollback) {
            this.rxQueryRunner = rxQueryRunner;
            this.commit = commit;
            this.rollback = rollback;
        }

        public RxQueryRunner getRxQueryRunner() {
            return this.rxQueryRunner;
        }

        public Publisher<Void> getCommit() {
            return this.commit;
        }

        public Publisher<Void> getRollback() {
            return this.rollback;
        }
    }

    class DefaultRunnableDelegation<T>
    implements ReactiveNeo4jClient.RunnableDelegation<T>,
    ReactiveNeo4jClient.OngoingDelegation<T> {
        private final Function<RxQueryRunner, Mono<T>> callback;
        private String targetDatabase;

        DefaultRunnableDelegation(Function<RxQueryRunner, Mono<T>> callback) {
            this(callback, null);
        }

        DefaultRunnableDelegation(@Nullable Function<RxQueryRunner, Mono<T>> callback, String targetDatabase) {
            this.callback = callback;
            this.targetDatabase = targetDatabase;
        }

        @Override
        public ReactiveNeo4jClient.RunnableDelegation in(@Nullable String targetDatabase) {
            this.targetDatabase = Neo4jClient.verifyDatabaseName(targetDatabase);
            return this;
        }

        @Override
        public Mono<T> run() {
            return DefaultReactiveNeo4jClient.this.doInQueryRunnerForMono(this.targetDatabase, this.callback);
        }
    }

    class DefaultRecordFetchSpec<T>
    implements ReactiveNeo4jClient.RecordFetchSpec<T>,
    ReactiveNeo4jClient.MappingSpec<T> {
        private final Mono<DatabaseSelection> targetDatabase = Mono.defer(() -> Mono.justOrEmpty((Object)parameterTargetDatabase).flatMap(db -> ReactiveDatabaseSelectionProvider.createStaticDatabaseSelectionProvider(db).getDatabaseSelection()).switchIfEmpty((Mono)(DefaultReactiveNeo4jClient.this.databaseSelectionProvider == null ? Mono.empty() : DefaultReactiveNeo4jClient.this.databaseSelectionProvider.getDatabaseSelection())).switchIfEmpty(Mono.just((Object)DatabaseSelection.undecided())));
        private final Supplier<String> cypherSupplier;
        private final NamedParameters parameters;
        private BiFunction<TypeSystem, Record, T> mappingFunction;

        DefaultRecordFetchSpec(String targetDatabase, Supplier<String> cypherSupplier, NamedParameters parameters) {
            this(targetDatabase, cypherSupplier, parameters, null);
        }

        DefaultRecordFetchSpec(String parameterTargetDatabase, Supplier<String> cypherSupplier, @Nullable NamedParameters parameters, BiFunction<TypeSystem, Record, T> mappingFunction) {
            this.cypherSupplier = cypherSupplier;
            this.parameters = parameters;
            this.mappingFunction = mappingFunction;
        }

        @Override
        public ReactiveNeo4jClient.RecordFetchSpec<T> mappedBy(BiFunction<TypeSystem, Record, T> mappingFunction) {
            this.mappingFunction = new DelegatingMappingFunctionWithNullCheck<T>(mappingFunction);
            return this;
        }

        Mono<Tuple2<String, Map<String, Object>>> prepareStatement() {
            if (ReactiveNeo4jClient.cypherLog.isDebugEnabled()) {
                String cypher = this.cypherSupplier.get();
                ReactiveNeo4jClient.cypherLog.debug(() -> String.format("Executing:%s%s", System.lineSeparator(), cypher));
                if (ReactiveNeo4jClient.cypherLog.isTraceEnabled() && !this.parameters.isEmpty()) {
                    ReactiveNeo4jClient.cypherLog.trace(() -> String.format("with parameters:%s%s", System.lineSeparator(), this.parameters));
                }
            }
            return Mono.fromSupplier(this.cypherSupplier).zipWith(Mono.just(this.parameters.get()));
        }

        Flux<T> executeWith(Tuple2<String, Map<String, Object>> t, RxQueryRunner runner) {
            return Flux.usingWhen((Publisher)Flux.just((Object)runner.run((String)t.getT1(), (Map)t.getT2())), result -> Flux.from((Publisher)result.records()).map(r -> this.mappingFunction.apply(DefaultReactiveNeo4jClient.this.typeSystem, (Record)r)), result -> Flux.from((Publisher)result.consume()).doOnNext(ResultSummaries::process));
        }

        @Override
        public Mono<T> one() {
            return this.targetDatabase.flatMap(databaseSelection -> DefaultReactiveNeo4jClient.this.doInQueryRunnerForMono(databaseSelection.getValue(), runner -> this.prepareStatement().flatMapMany(t -> this.executeWith((Tuple2<String, Map<String, Object>>)t, (RxQueryRunner)runner)).singleOrEmpty())).onErrorMap(RuntimeException.class, x$0 -> DefaultReactiveNeo4jClient.this.potentiallyConvertRuntimeException(x$0));
        }

        @Override
        public Mono<T> first() {
            return this.targetDatabase.flatMap(databaseSelection -> DefaultReactiveNeo4jClient.this.doInQueryRunnerForMono(databaseSelection.getValue(), runner -> this.prepareStatement().flatMapMany(t -> this.executeWith((Tuple2<String, Map<String, Object>>)t, (RxQueryRunner)runner)).next())).onErrorMap(RuntimeException.class, x$0 -> DefaultReactiveNeo4jClient.this.potentiallyConvertRuntimeException(x$0));
        }

        @Override
        public Flux<T> all() {
            return this.targetDatabase.flatMapMany(databaseSelection -> DefaultReactiveNeo4jClient.this.doInStatementRunnerForFlux(databaseSelection.getValue(), runner -> this.prepareStatement().flatMapMany(t -> this.executeWith((Tuple2<String, Map<String, Object>>)t, (RxQueryRunner)runner)))).onErrorMap(RuntimeException.class, x$0 -> DefaultReactiveNeo4jClient.this.potentiallyConvertRuntimeException(x$0));
        }

        Mono<ResultSummary> run() {
            return this.targetDatabase.flatMap(databaseSelection -> DefaultReactiveNeo4jClient.this.doInQueryRunnerForMono(databaseSelection.getValue(), runner -> this.prepareStatement().flatMap(t -> {
                RxResult rxResult = runner.run((String)t.getT1(), (Map)t.getT2());
                return Flux.from((Publisher)rxResult.records()).then(Mono.from((Publisher)rxResult.consume()).map(ResultSummaries::process));
            }))).onErrorMap(RuntimeException.class, x$0 -> DefaultReactiveNeo4jClient.this.potentiallyConvertRuntimeException(x$0));
        }
    }

    class DefaultRunnableSpec
    implements ReactiveNeo4jClient.RunnableSpec {
        private final Supplier<String> cypherSupplier;
        private String targetDatabase;
        private final NamedParameters parameters = new NamedParameters();

        DefaultRunnableSpec(Supplier<String> cypherSupplier) {
            this.cypherSupplier = cypherSupplier;
        }

        @Override
        public ReactiveNeo4jClient.RunnableSpecTightToDatabase in(String targetDatabase) {
            this.targetDatabase = Neo4jClient.verifyDatabaseName(targetDatabase);
            return this;
        }

        @Override
        public Neo4jClient.OngoingBindSpec<?, ReactiveNeo4jClient.RunnableSpecTightToDatabase> bind(@Nullable Object value) {
            return new DefaultOngoingBindSpec<Object>(value);
        }

        @Override
        public ReactiveNeo4jClient.RunnableSpecTightToDatabase bindAll(Map<String, Object> newParameters) {
            this.parameters.addAll(newParameters);
            return this;
        }

        public <R> ReactiveNeo4jClient.MappingSpec<R> fetchAs(Class<R> targetClass) {
            return new DefaultRecordFetchSpec(this.targetDatabase, this.cypherSupplier, this.parameters, new SingleValueMappingFunction<R>(DefaultReactiveNeo4jClient.this.conversionService, targetClass));
        }

        @Override
        public ReactiveNeo4jClient.RecordFetchSpec<Map<String, Object>> fetch() {
            return new DefaultRecordFetchSpec<Map<String, Object>>(this.targetDatabase, this.cypherSupplier, this.parameters, (t, r) -> r.asMap());
        }

        @Override
        public Mono<ResultSummary> run() {
            return new DefaultRecordFetchSpec(this.targetDatabase, this.cypherSupplier, this.parameters).run();
        }

        class DefaultOngoingBindSpec<T>
        implements Neo4jClient.OngoingBindSpec<T, ReactiveNeo4jClient.RunnableSpecTightToDatabase> {
            @Nullable
            private final T value;

            DefaultOngoingBindSpec(T value) {
                this.value = value;
            }

            @Override
            public ReactiveNeo4jClient.RunnableSpecTightToDatabase to(String name) {
                DefaultRunnableSpec.this.parameters.add(name, this.value);
                return DefaultRunnableSpec.this;
            }

            @Override
            public ReactiveNeo4jClient.RunnableSpecTightToDatabase with(Function<T, Map<String, Object>> binder) {
                Assert.notNull(binder, (String)"Binder is required.");
                return DefaultRunnableSpec.this.bindAll((Map)binder.apply(this.value));
            }
        }
    }
}

