/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.neo4j.config.Neo4jConfigurationSupport;
import org.springframework.data.neo4j.core.schema.Node;
import org.springframework.data.neo4j.core.schema.RelationshipProperties;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@API(status=API.Status.STABLE, since="6.0.2")
public final class Neo4jEntityScanner {
    @Nullable
    private final ResourceLoader resourceLoader;

    public static Neo4jEntityScanner get() {
        return new Neo4jEntityScanner(null);
    }

    public static Neo4jEntityScanner get(@Nullable ResourceLoader resourceLoader) {
        return new Neo4jEntityScanner(resourceLoader);
    }

    private Neo4jEntityScanner(@Nullable ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @SafeVarargs
    public final Set<Class<?>> scan(String ... basePackages) throws ClassNotFoundException {
        return this.scan(Arrays.stream(basePackages).collect(Collectors.toList()));
    }

    public Set<Class<?>> scan(Collection<String> packages) throws ClassNotFoundException {
        if (packages.isEmpty()) {
            return Collections.emptySet();
        }
        ClassPathScanningCandidateComponentProvider scanner = Neo4jEntityScanner.createClassPathScanningCandidateComponentProvider(this.resourceLoader);
        ClassLoader classLoader = this.resourceLoader == null ? Neo4jConfigurationSupport.class.getClassLoader() : this.resourceLoader.getClassLoader();
        HashSet entitySet = new HashSet();
        for (String basePackage : packages) {
            if (!StringUtils.hasText((String)basePackage)) continue;
            for (BeanDefinition candidate : scanner.findCandidateComponents(basePackage)) {
                entitySet.add(ClassUtils.forName((String)candidate.getBeanClassName(), (ClassLoader)classLoader));
            }
        }
        return entitySet;
    }

    private static ClassPathScanningCandidateComponentProvider createClassPathScanningCandidateComponentProvider(ResourceLoader resourceLoader) {
        ClassPathScanningCandidateComponentProvider delegate = new ClassPathScanningCandidateComponentProvider(false);
        if (resourceLoader != null) {
            delegate.setResourceLoader(resourceLoader);
        }
        delegate.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Node.class));
        delegate.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Persistent.class));
        delegate.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(RelationshipProperties.class));
        return delegate;
    }
}

