/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.List;
import java.util.Optional;
import java.util.function.LongSupplier;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.core.Neo4jOperations;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.repository.query.CypherAdapterUtils;
import org.springframework.data.neo4j.repository.query.Predicate;
import org.springframework.data.repository.query.QueryByExampleExecutor;
import org.springframework.data.repository.support.PageableExecutionUtils;

@API(status=API.Status.INTERNAL, since="6.0")
public final class SimpleQueryByExampleExecutor<T>
implements QueryByExampleExecutor<T> {
    private final Neo4jOperations neo4jOperations;
    private final Neo4jMappingContext mappingContext;
    private final CypherGenerator cypherGenerator;

    public SimpleQueryByExampleExecutor(Neo4jOperations neo4jOperations, Neo4jMappingContext mappingContext) {
        this.neo4jOperations = neo4jOperations;
        this.mappingContext = mappingContext;
        this.cypherGenerator = CypherGenerator.INSTANCE;
    }

    public <S extends T> Optional<S> findOne(Example<S> example) {
        Predicate predicate = Predicate.create(this.mappingContext, example);
        Statement statement = predicate.useWithReadingFragment(this.cypherGenerator::prepareMatchOf).returning(new Expression[]{this.cypherGenerator.createReturnStatementForMatch(predicate.getNeo4jPersistentEntity())}).build();
        return this.neo4jOperations.findOne(statement, predicate.getParameters(), example.getProbeType());
    }

    public <S extends T> List<S> findAll(Example<S> example) {
        Predicate predicate = Predicate.create(this.mappingContext, example);
        Statement statement = predicate.useWithReadingFragment(this.cypherGenerator::prepareMatchOf).returning(new Expression[]{this.cypherGenerator.createReturnStatementForMatch(predicate.getNeo4jPersistentEntity())}).build();
        return this.neo4jOperations.findAll(statement, predicate.getParameters(), example.getProbeType());
    }

    public <S extends T> List<S> findAll(Example<S> example, Sort sort) {
        Predicate predicate = Predicate.create(this.mappingContext, example);
        Statement statement = predicate.useWithReadingFragment(this.cypherGenerator::prepareMatchOf).returning(new Expression[]{this.cypherGenerator.createReturnStatementForMatch(predicate.getNeo4jPersistentEntity())}).orderBy(CypherAdapterUtils.toSortItems(predicate.getNeo4jPersistentEntity(), sort)).build();
        return this.neo4jOperations.findAll(statement, predicate.getParameters(), example.getProbeType());
    }

    public <S extends T> long count(Example<S> example) {
        Predicate predicate = Predicate.create(this.mappingContext, example);
        Statement statement = predicate.useWithReadingFragment(this.cypherGenerator::prepareMatchOf).returning(new Expression[]{Functions.count((Expression)Cypher.asterisk())}).build();
        return this.neo4jOperations.count(statement, predicate.getParameters());
    }

    public <S extends T> boolean exists(Example<S> example) {
        return this.findAll((Example)example).iterator().hasNext();
    }

    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        Predicate predicate = Predicate.create(this.mappingContext, example);
        StatementBuilder.OngoingReadingAndReturn returning = predicate.useWithReadingFragment(this.cypherGenerator::prepareMatchOf).returning(new Expression[]{this.cypherGenerator.createReturnStatementForMatch(predicate.getNeo4jPersistentEntity())});
        StatementBuilder.BuildableStatement returningWithPaging = CypherAdapterUtils.addPagingParameter(predicate.getNeo4jPersistentEntity(), pageable, returning);
        Statement statement = returningWithPaging.build();
        List page = this.neo4jOperations.findAll(statement, predicate.getParameters(), example.getProbeType());
        LongSupplier totalCountSupplier = () -> this.count(example);
        return PageableExecutionUtils.getPage(page, (Pageable)pageable, (LongSupplier)totalCountSupplier);
    }
}

