/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.support;

import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.event.EventListener;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.neo4j.repository.config.Neo4jAuditingEventListener;
import org.springframework.util.Assert;

public class Neo4jAuditingBeanPostProcessor
implements BeanPostProcessor {
    private final ObjectFactory<IsNewAwareAuditingHandler> isNewAwareHandler;

    public Neo4jAuditingBeanPostProcessor(ObjectFactory<IsNewAwareAuditingHandler> isNewAwareHandler) {
        Assert.notNull(isNewAwareHandler, (String)"IsNewAwareHandler must not be null!");
        this.isNewAwareHandler = isNewAwareHandler;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!SessionFactory.class.isInstance(bean)) {
            return bean;
        }
        SessionFactory sessionFactory = (SessionFactory)bean;
        sessionFactory.register((EventListener)new Neo4jAuditingEventListener(this.isNewAwareHandler));
        return sessionFactory;
    }
}

