/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.neo4j.repository.query.AbstractGraphRepositoryQuery;
import org.springframework.data.neo4j.repository.query.GraphParametersParameterAccessor;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.neo4j.repository.query.Query;
import org.springframework.data.neo4j.repository.query.TemplatedQuery;
import org.springframework.data.neo4j.repository.query.TemplatedQueryCreator;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeNeo4jQuery
extends AbstractGraphRepositoryQuery {
    private static final Logger LOG = LoggerFactory.getLogger(PartTreeNeo4jQuery.class);
    private final GraphQueryMethod graphQueryMethod;
    private final PartTree tree;
    private final TemplatedQuery queryTemplate;

    public PartTreeNeo4jQuery(GraphQueryMethod graphQueryMethod, Session session) {
        super(graphQueryMethod, session);
        Class domainType = graphQueryMethod.getEntityInformation().getJavaType();
        this.graphQueryMethod = graphQueryMethod;
        this.tree = new PartTree(graphQueryMethod.getName(), domainType);
        this.queryTemplate = (TemplatedQuery)new TemplatedQueryCreator(this.tree, domainType).createQuery();
    }

    @Override
    protected Object doExecute(Query params, Object[] parameters) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing query for method {}", (Object)this.graphQueryMethod.getName());
        }
        GraphParametersParameterAccessor accessor = new GraphParametersParameterAccessor(this.graphQueryMethod, parameters);
        Class<?> returnType = this.graphQueryMethod.getMethod().getReturnType();
        if (returnType.equals(Void.class)) {
            throw new RuntimeException("Derived Queries must have a return type");
        }
        ResultProcessor processor = this.graphQueryMethod.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        Object results = this.getExecution(accessor).execute(params, processor.getReturnedType().getDomainType());
        return processor.processResult(results);
    }

    @Override
    protected Query getQuery(Object[] parameters) {
        Map<Integer, Object> resolvedParameters = this.resolveParameters(parameters);
        return this.queryTemplate.createExecutableQuery(resolvedParameters);
    }

    @Override
    protected boolean isCountQuery() {
        return this.tree.isCountProjection();
    }

    @Override
    protected boolean isExistsQuery() {
        return this.tree.isExistsProjection();
    }

    @Override
    protected boolean isDeleteQuery() {
        return this.tree.isDelete();
    }

    private Map<Integer, Object> resolveParameters(Object[] parameters) {
        HashMap<Integer, Object> resolvedParameters = new HashMap<Integer, Object>();
        for (int i = 0; i < parameters.length; ++i) {
            if (this.graphQueryMethod.getQueryDepthParamIndex() != null && (this.graphQueryMethod.getQueryDepthParamIndex() == null || this.graphQueryMethod.getQueryDepthParamIndex() == i)) continue;
            resolvedParameters.put(i, parameters[i]);
        }
        return resolvedParameters;
    }
}

