/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.template;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.neo4j.template.Neo4jCallback;
import org.springframework.data.neo4j.template.Neo4jOperations;
import org.springframework.data.neo4j.transaction.SessionFactoryUtils;
import org.springframework.data.neo4j.util.IterableUtils;
import org.springframework.util.Assert;

@Deprecated
public class Neo4jTemplate
implements Neo4jOperations,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(Neo4jTemplate.class);
    private SessionFactory sessionFactory;

    public Neo4jTemplate() {
    }

    @Autowired
    public Neo4jTemplate(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"Cannot create a Neo4jTemplate without a SessionFactory!");
        this.sessionFactory = sessionFactory;
        this.afterPropertiesSet();
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void afterPropertiesSet() {
        if (this.getSessionFactory() == null) {
            throw new IllegalArgumentException("Property 'sessionFactory' is required");
        }
    }

    @Override
    public <T> T execute(Neo4jCallback<T> action) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        Session session = null;
        boolean isNew = false;
        try {
            session = SessionFactoryUtils.getSession(this.getSessionFactory());
        }
        catch (IllegalStateException ex) {
            logger.debug("Could not retrieve pre-bound OGM session", (Throwable)ex);
        }
        if (session == null) {
            session = this.getSessionFactory().openSession();
            isNew = true;
        }
        try {
            T ex = action.doInNeo4jOgm(session);
            return ex;
        }
        catch (RuntimeException ex) {
            throw SessionFactoryUtils.convertOgmAccessException(ex);
        }
        finally {
            if (isNew) {
                SessionFactoryUtils.closeSession(session);
            }
        }
    }

    @Override
    public <T> T load(final Class<T> type, final Long id) {
        return this.execute(new Neo4jCallback<T>(){

            @Override
            public T doInNeo4jOgm(Session session) {
                return session.load(type, (Serializable)id);
            }
        });
    }

    @Override
    public <T> T load(final Class<T> type, final Long id, final int depth) {
        return this.execute(new Neo4jCallback<T>(){

            @Override
            public T doInNeo4jOgm(Session session) {
                return session.load(type, (Serializable)id, depth);
            }
        });
    }

    public <T> Collection<T> loadAll(final Class<T> type, final Collection<Long> ids) {
        return (Collection)this.execute(new Neo4jCallback<Collection<T>>(){

            @Override
            public Collection<T> doInNeo4jOgm(Session session) {
                return session.loadAll(type, ids);
            }
        });
    }

    @Override
    public <T> Collection<T> loadAll(final Class<T> type, final Collection<Long> ids, final int depth) {
        return (Collection)this.execute(new Neo4jCallback<Collection<T>>(){

            @Override
            public Collection<T> doInNeo4jOgm(Session session) {
                return session.loadAll(type, ids, depth);
            }
        });
    }

    @Override
    public <T> Collection<T> loadAll(final Class<T> type) {
        return (Collection)this.execute(new Neo4jCallback<Collection<T>>(){

            @Override
            public Collection<T> doInNeo4jOgm(Session session) {
                return session.loadAll(type);
            }
        });
    }

    @Override
    public <T> Collection<T> loadAll(final Class<T> type, final int depth) {
        return (Collection)this.execute(new Neo4jCallback<Collection<T>>(){

            @Override
            public Collection<T> doInNeo4jOgm(Session session) {
                return session.loadAll(type, depth);
            }
        });
    }

    @Override
    public <T> Collection<T> loadAll(final Class<T> type, final SortOrder sortOrder, final int depth) {
        return (Collection)this.execute(new Neo4jCallback<Collection<T>>(){

            @Override
            public Collection<T> doInNeo4jOgm(Session session) {
                return session.loadAll(type, sortOrder, depth);
            }
        });
    }

    @Override
    public <T> Collection<T> loadAll(final Class<T> type, final SortOrder sortOrder, final Pagination pagination, final int depth) {
        return (Collection)this.execute(new Neo4jCallback<Collection<T>>(){

            @Override
            public Collection<T> doInNeo4jOgm(Session session) {
                return session.loadAll(type, sortOrder, pagination, depth);
            }
        });
    }

    public <T> Collection<T> loadAll(final Collection<T> objects) {
        return (Collection)this.execute(new Neo4jCallback<Collection<T>>(){

            @Override
            public Collection<T> doInNeo4jOgm(Session session) {
                return session.loadAll(objects);
            }
        });
    }

    @Override
    public <T> Collection<T> loadAll(final Collection<T> objects, final int depth) {
        return (Collection)this.execute(new Neo4jCallback<Collection<T>>(){

            @Override
            public Collection<T> doInNeo4jOgm(Session session) {
                return session.loadAll(objects, depth);
            }
        });
    }

    @Override
    public <T> Collection<T> loadAll(final Class<T> type, final Collection<Long> ids, final SortOrder sortOrder, final int depth) {
        return (Collection)this.execute(new Neo4jCallback<Collection<T>>(){

            @Override
            public Collection<T> doInNeo4jOgm(Session session) {
                return session.loadAll(type, ids, sortOrder, depth);
            }
        });
    }

    @Override
    public <T> Collection<T> loadAll(final Class<T> type, final Filter filter) {
        return (Collection)this.execute(new Neo4jCallback<Collection<T>>(){

            @Override
            public Collection<T> doInNeo4jOgm(Session session) {
                return session.loadAll(type, filter);
            }
        });
    }

    @Override
    public <T> Collection<T> loadAll(final Class<T> type, final Pagination pagination, final int depth) {
        return (Collection)this.execute(new Neo4jCallback<Collection<T>>(){

            @Override
            public Collection<T> doInNeo4jOgm(Session session) {
                return session.loadAll(type, pagination, depth);
            }
        });
    }

    @Override
    public <T> Collection<T> loadAll(final Class<T> type, final Filter filter, final int depth) {
        return (Collection)this.execute(new Neo4jCallback<Collection<T>>(){

            @Override
            public Collection<T> doInNeo4jOgm(Session session) {
                return session.loadAll(type, filter, depth);
            }
        });
    }

    @Override
    public <T> T loadByProperty(final Class<T> type, final String propertyName, final Object propertyValue) {
        return this.execute(new Neo4jCallback<T>(){

            @Override
            public T doInNeo4jOgm(Session session) {
                return Neo4jTemplate.this.loadByProperty(type, propertyName, propertyValue, 1);
            }
        });
    }

    @Override
    public <T> T loadByProperty(final Class<T> type, final String propertyName, final Object propertyValue, final int depth) {
        return this.execute(new Neo4jCallback<T>(){

            @Override
            public T doInNeo4jOgm(Session session) {
                return IterableUtils.getSingle(Neo4jTemplate.this.loadAllByProperty(type, propertyName, propertyValue, depth));
            }
        });
    }

    public <T> T loadByPropertyOrNull(Class<T> type, String propertyName, Object propertyValue) {
        return IterableUtils.getSingleOrNull(this.loadAllByProperty(type, propertyName, propertyValue));
    }

    @Override
    public <T> Collection<T> loadAllByProperty(final Class<T> type, final String name, final Object value) {
        return (Collection)this.execute(new Neo4jCallback<Collection<T>>(){

            @Override
            public Collection<T> doInNeo4jOgm(Session session) {
                return session.loadAll(type, new Filter(name, value));
            }
        });
    }

    @Override
    public <T> T loadByProperties(Class<T> type, Filters parameters) {
        return this.loadByProperties(type, parameters, 1);
    }

    @Override
    public <T> T loadByProperties(Class<T> type, Filters parameters, int depth) {
        return IterableUtils.getSingle(this.loadAllByProperties(type, parameters, depth));
    }

    @Override
    public <T> Collection<T> loadAllByProperties(Class<T> type, Filters parameters) {
        return this.loadAllByProperties(type, parameters, 1);
    }

    @Override
    public <T> Collection<T> loadAllByProperties(final Class<T> type, final Filters parameters, final int depth) {
        return (Collection)this.execute(new Neo4jCallback<Collection<T>>(){

            @Override
            public Collection<T> doInNeo4jOgm(Session session) {
                return session.loadAll(type, parameters, depth);
            }
        });
    }

    @Override
    public <T> Collection<T> loadAllByProperty(final Class<T> type, final String name, final Object value, final int depth) {
        return (Collection)this.execute(new Neo4jCallback<Collection<T>>(){

            @Override
            public Collection<T> doInNeo4jOgm(Session session) {
                return session.loadAll(type, new Filter(name, value), depth);
            }
        });
    }

    @Override
    public void delete(final Object entity) {
        this.execute(new Neo4jCallback<Object>(){

            @Override
            public Object doInNeo4jOgm(Session session) {
                session.delete(entity);
                return null;
            }
        });
    }

    @Override
    public void clear() {
        this.execute(new Neo4jCallback<Object>(){

            @Override
            public Object doInNeo4jOgm(Session session) {
                session.clear();
                return null;
            }
        });
    }

    @Override
    public <T> void deleteAll(final Class<T> type) {
        this.execute(new Neo4jCallback<Object>(){

            @Override
            public Object doInNeo4jOgm(Session session) {
                session.deleteAll(type);
                return null;
            }
        });
    }

    @Override
    public <T> T save(final T entity) {
        return this.execute(new Neo4jCallback<T>(){

            @Override
            public T doInNeo4jOgm(Session session) {
                session.save(entity);
                return entity;
            }
        });
    }

    @Override
    public <T> T save(final T entity, final int depth) {
        return this.execute(new Neo4jCallback<T>(){

            @Override
            public T doInNeo4jOgm(Session session) {
                session.save(entity, depth);
                return entity;
            }
        });
    }

    @Override
    public Result query(final String cypher, final Map<String, ?> parameters) {
        return this.execute(new Neo4jCallback<Result>(){

            @Override
            public Result doInNeo4jOgm(Session session) {
                return session.query(cypher, parameters);
            }
        });
    }

    @Override
    public <T> Iterable<T> queryForObjects(final Class<T> objectType, final String cypher, final Map<String, ?> parameters) {
        return (Iterable)this.execute(new Neo4jCallback<Iterable<T>>(){

            @Override
            public Iterable<T> doInNeo4jOgm(Session session) {
                return session.query(objectType, cypher, parameters);
            }
        });
    }

    @Override
    public Result query(final String cypher, final Map<String, ?> parameters, final boolean readOnly) {
        return this.execute(new Neo4jCallback<Result>(){

            @Override
            public Result doInNeo4jOgm(Session session) {
                return session.query(cypher, parameters, readOnly);
            }
        });
    }

    @Override
    public <T> T queryForObject(final Class<T> objectType, final String cypher, final Map<String, ?> parameters) {
        return this.execute(new Neo4jCallback<T>(){

            @Override
            public T doInNeo4jOgm(Session session) {
                return session.queryForObject(objectType, cypher, parameters);
            }
        });
    }

    @Override
    public long count(final Class<?> entityClass) {
        return this.execute(new Neo4jCallback<Long>(){

            @Override
            public Long doInNeo4jOgm(Session session) {
                return session.countEntitiesOfType(entityClass);
            }
        });
    }
}

