/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.client.gridfs.model.GridFSFile;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.data.mongodb.gridfs.GridFsObject;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ReactiveGridFsUpload<ID>
implements GridFsObject<ID, Publisher<DataBuffer>> {
    @Nullable
    private final ID id;
    private final Publisher<DataBuffer> dataStream;
    private final String filename;
    private final GridFsObject.Options options;

    private ReactiveGridFsUpload(@Nullable ID id, Publisher<DataBuffer> dataStream, String filename, GridFsObject.Options options) {
        Assert.notNull(dataStream, (String)"Data Stream must not be null");
        Assert.notNull((Object)filename, (String)"Filename must not be null");
        Assert.notNull((Object)options, (String)"Options must not be null");
        this.id = id;
        this.dataStream = dataStream;
        this.filename = filename;
        this.options = options;
    }

    @Override
    @Nullable
    public ID getFileId() {
        return this.id;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public Publisher<DataBuffer> getContent() {
        return this.dataStream;
    }

    @Override
    public GridFsObject.Options getOptions() {
        return this.options;
    }

    public static ReactiveGridFsUploadBuilder<ObjectId> fromPublisher(Publisher<DataBuffer> source) {
        return new ReactiveGridFsUploadBuilder().content(source);
    }

    public static class ReactiveGridFsUploadBuilder<T> {
        @Nullable
        private Object id;
        private Publisher<DataBuffer> dataStream;
        private String filename;
        private GridFsObject.Options options = GridFsObject.Options.none();

        private ReactiveGridFsUploadBuilder() {
        }

        public ReactiveGridFsUploadBuilder<T> content(Publisher<DataBuffer> source) {
            this.dataStream = source;
            return this;
        }

        public <T1> ReactiveGridFsUploadBuilder<T1> id(T1 id) {
            this.id = id;
            return this;
        }

        public ReactiveGridFsUploadBuilder<T> filename(String filename) {
            this.filename = filename;
            return this;
        }

        public ReactiveGridFsUploadBuilder<T> options(GridFsObject.Options options) {
            Assert.notNull((Object)options, (String)"Options must not be null");
            this.options = options;
            return this;
        }

        public ReactiveGridFsUploadBuilder<T> metadata(Document metadata) {
            this.options = this.options.metadata(metadata);
            return this;
        }

        public ReactiveGridFsUploadBuilder<T> chunkSize(int chunkSize) {
            this.options = this.options.chunkSize(chunkSize);
            return this;
        }

        public ReactiveGridFsUploadBuilder<T> gridFsFile(GridFSFile gridFSFile) {
            Assert.notNull((Object)gridFSFile, (String)"GridFSFile must not be null");
            this.id = gridFSFile.getId();
            this.filename = gridFSFile.getFilename();
            this.options = this.options.metadata(gridFSFile.getMetadata());
            this.options = this.options.chunkSize(gridFSFile.getChunkSize());
            return this;
        }

        public ReactiveGridFsUploadBuilder<T> contentType(String contentType) {
            this.options = this.options.contentType(contentType);
            return this;
        }

        public ReactiveGridFsUpload<T> build() {
            return new ReactiveGridFsUpload<Object>(this.id, this.dataStream, this.filename, this.options);
        }
    }
}

