/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.mongodb.core.mapping.BasicMongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.DocumentReference;
import org.springframework.data.mongodb.core.mapping.Encrypted;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.data.mongodb.core.mapping.FieldType;
import org.springframework.data.mongodb.core.mapping.Language;
import org.springframework.data.mongodb.core.mapping.MongoField;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.TextScore;
import org.springframework.data.mongodb.util.encryption.EncryptionUtils;
import org.springframework.data.util.Lazy;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BasicMongoPersistentProperty
extends AnnotationBasedPersistentProperty<MongoPersistentProperty>
implements MongoPersistentProperty {
    private static final Log LOG = LogFactory.getLog(BasicMongoPersistentProperty.class);
    public static final String ID_FIELD_NAME = FieldName.ID.name();
    private static final String LANGUAGE_FIELD_NAME = "language";
    private static final Set<String> SUPPORTED_ID_PROPERTY_NAMES = Set.of("id", ID_FIELD_NAME);
    private final FieldNamingStrategy fieldNamingStrategy;

    public BasicMongoPersistentProperty(Property property, MongoPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder, @Nullable FieldNamingStrategy fieldNamingStrategy) {
        super(property, owner, simpleTypeHolder);
        this.fieldNamingStrategy = fieldNamingStrategy == null ? PropertyNameFieldNamingStrategy.INSTANCE : fieldNamingStrategy;
    }

    public boolean isIdProperty() {
        if (super.isIdProperty()) {
            return true;
        }
        return SUPPORTED_ID_PROPERTY_NAMES.contains(this.getName()) && !this.hasExplicitFieldName();
    }

    @Override
    public boolean isExplicitIdProperty() {
        return super.isIdProperty();
    }

    @Override
    public String getFieldName() {
        return this.getMongoField().getName().name();
    }

    @Override
    public Class<?> getFieldType() {
        Field fieldAnnotation = (Field)this.findAnnotation(Field.class);
        if (!this.isIdProperty()) {
            if (fieldAnnotation == null || fieldAnnotation.targetType() == FieldType.IMPLICIT) {
                return this.getType();
            }
            return fieldAnnotation.targetType().getJavaClass();
        }
        if (fieldAnnotation == null) {
            return FieldType.OBJECT_ID.getJavaClass();
        }
        FieldType fieldType = this.getMongoField().getFieldType();
        if (fieldType == FieldType.IMPLICIT) {
            if (this.isEntity()) {
                return Document.class;
            }
            return this.getType();
        }
        return fieldType.getJavaClass();
    }

    @Override
    public boolean hasExplicitFieldName() {
        return StringUtils.hasText((String)this.getAnnotatedFieldName());
    }

    @Nullable
    private String getAnnotatedFieldName() {
        Field annotation = (Field)this.findAnnotation(Field.class);
        return annotation != null ? annotation.value() : null;
    }

    @Override
    public int getFieldOrder() {
        return this.getMongoField().getOrder();
    }

    @Override
    public boolean writeNullValues() {
        Field annotation = (Field)this.findAnnotation(Field.class);
        return annotation != null && annotation.write() == Field.Write.ALWAYS;
    }

    protected Association<MongoPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    @Override
    public boolean isDbReference() {
        return this.isAnnotationPresent(DBRef.class);
    }

    @Override
    public boolean isDocumentReference() {
        return this.isAnnotationPresent(DocumentReference.class);
    }

    @Override
    @Nullable
    public DBRef getDBRef() {
        return (DBRef)this.findAnnotation(DBRef.class);
    }

    @Override
    @Nullable
    public DocumentReference getDocumentReference() {
        return (DocumentReference)this.findAnnotation(DocumentReference.class);
    }

    @Override
    public boolean isLanguageProperty() {
        return this.getFieldName().equals(LANGUAGE_FIELD_NAME) || this.isExplicitLanguageProperty();
    }

    @Override
    public boolean isExplicitLanguageProperty() {
        return this.isAnnotationPresent(Language.class);
    }

    @Override
    public boolean isTextScoreProperty() {
        return this.isAnnotationPresent(TextScore.class);
    }

    public EvaluationContext getEvaluationContext(@Nullable Object rootObject) {
        PersistentEntity persistentEntity = this.getOwner();
        if (persistentEntity instanceof BasicMongoPersistentEntity) {
            BasicMongoPersistentEntity mongoPersistentEntity = (BasicMongoPersistentEntity)persistentEntity;
            return mongoPersistentEntity.getEvaluationContext(rootObject);
        }
        return rootObject != null ? new StandardEvaluationContext(rootObject) : new StandardEvaluationContext();
    }

    public ValueEvaluationContext getValueEvaluationContext(@Nullable Object rootObject) {
        PersistentEntity persistentEntity = this.getOwner();
        if (persistentEntity instanceof BasicMongoPersistentEntity) {
            BasicMongoPersistentEntity mongoPersistentEntity = (BasicMongoPersistentEntity)persistentEntity;
            return mongoPersistentEntity.getValueEvaluationContext(rootObject);
        }
        StandardEvaluationContext standardEvaluationContext = rootObject != null ? new StandardEvaluationContext(rootObject) : new StandardEvaluationContext();
        return ValueEvaluationContext.of((Environment)new StandardEnvironment(), (EvaluationContext)standardEvaluationContext);
    }

    @Override
    public MongoField getMongoField() {
        return this.doGetMongoField();
    }

    @Override
    public Collection<Object> getEncryptionKeyIds() {
        Encrypted encrypted = (Encrypted)this.findAnnotation(Encrypted.class);
        if (encrypted == null) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object[])encrypted.keyId())) {
            return Collections.emptySet();
        }
        Lazy evaluationContext = Lazy.of(() -> {
            EvaluationContext ctx = this.getEvaluationContext(null);
            ctx.setVariable("target", (Object)(this.getOwner().getType().getSimpleName() + "." + this.getName()));
            return ctx;
        });
        ArrayList<Object> target = new ArrayList<Object>();
        for (String keyId : encrypted.keyId()) {
            target.add(EncryptionUtils.resolveKeyId(keyId, (Supplier<EvaluationContext>)evaluationContext));
        }
        return target;
    }

    protected MongoField doGetMongoField() {
        MongoField.MongoFieldBuilder builder = MongoField.builder();
        if (this.isAnnotationPresent(Field.class) && FieldName.Type.KEY.equals((Object)((Field)this.findAnnotation(Field.class)).nameType())) {
            builder.name(this.doGetFieldName());
        } else {
            builder.path(this.doGetFieldName());
        }
        builder.fieldType(this.doGetFieldType());
        builder.order(this.doGetFieldOrder());
        return builder.build();
    }

    private String doGetFieldName() {
        if (this.isIdProperty()) {
            if (this.getOwner().getIdProperty() == null) {
                return ID_FIELD_NAME;
            }
            if (this.getOwner().isIdProperty((PersistentProperty)this)) {
                return ID_FIELD_NAME;
            }
        }
        if (this.hasExplicitFieldName()) {
            return this.getAnnotatedFieldName();
        }
        String fieldName = this.fieldNamingStrategy.getFieldName((PersistentProperty)this);
        if (!StringUtils.hasText((String)fieldName)) {
            throw new MappingException(String.format("Invalid (null or empty) field name returned for property %s by %s", this, this.fieldNamingStrategy.getClass()));
        }
        return fieldName;
    }

    private FieldType doGetFieldType() {
        Field fieldAnnotation = (Field)this.findAnnotation(Field.class);
        return fieldAnnotation != null ? fieldAnnotation.targetType() : FieldType.IMPLICIT;
    }

    private int doGetFieldOrder() {
        Field annotation = (Field)this.findAnnotation(Field.class);
        return annotation != null ? annotation.order() : Integer.MAX_VALUE;
    }

    protected void validate() {
        String annotatedName;
        if (this.isIdProperty() && this.hasExplicitFieldName() && !ID_FIELD_NAME.equals(annotatedName = this.getAnnotatedFieldName()) && LOG.isWarnEnabled()) {
            LOG.warn((Object)String.format("Customizing field name for id property '%s.%s' is not allowed; Custom name ('%s') will not be considered", this.getOwner().getName(), this.getName(), annotatedName));
        }
    }
}

