/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mongodb.core.ExecutableFindOperation;
import org.springframework.data.mongodb.core.ExecutableUpdateOperation;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationUpdate;
import org.springframework.data.mongodb.core.query.BasicUpdate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.mongodb.repository.Update;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.DefaultSpELExpressionEvaluator;
import org.springframework.data.mongodb.repository.query.MongoParametersParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryExecution;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.mongodb.repository.query.QueryUtils;
import org.springframework.data.mongodb.util.json.ParameterBindingContext;
import org.springframework.data.mongodb.util.json.ParameterBindingDocumentCodec;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.data.util.Lazy;
import org.springframework.expression.ExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractMongoQuery
implements RepositoryQuery {
    private final MongoQueryMethod method;
    private final MongoOperations operations;
    private final ExecutableFindOperation.ExecutableFind<?> executableFind;
    private final ExecutableUpdateOperation.ExecutableUpdate<?> executableUpdate;
    private final ExpressionParser expressionParser;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private final Lazy<ParameterBindingDocumentCodec> codec = Lazy.of(() -> new ParameterBindingDocumentCodec(this.getCodecRegistry()));

    public AbstractMongoQuery(MongoQueryMethod method, MongoOperations operations, ExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        Assert.notNull((Object)operations, (String)"MongoOperations must not be null");
        Assert.notNull((Object)((Object)method), (String)"MongoQueryMethod must not be null");
        Assert.notNull((Object)expressionParser, (String)"SpelExpressionParser must not be null");
        Assert.notNull((Object)evaluationContextProvider, (String)"QueryMethodEvaluationContextProvider must not be null");
        this.method = method;
        this.operations = operations;
        EntityMetadata metadata = method.getEntityInformation();
        Class type = metadata.getCollectionEntity().getType();
        this.executableFind = operations.query(type);
        this.executableUpdate = operations.update(type);
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    public MongoQueryMethod getQueryMethod() {
        return this.method;
    }

    public Object execute(Object[] parameters) {
        ConvertingParameterAccessor accessor = new ConvertingParameterAccessor(this.operations.getConverter(), new MongoParametersParameterAccessor(this.method, parameters));
        ResultProcessor processor = this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        Class typeToRead = processor.getReturnedType().getTypeToRead();
        return processor.processResult(this.doExecute(this.method, processor, accessor, typeToRead));
    }

    @Nullable
    protected Object doExecute(MongoQueryMethod method, ResultProcessor processor, ConvertingParameterAccessor accessor, @Nullable Class<?> typeToRead) {
        Query query = this.createQuery(accessor);
        this.applyQueryMetaAttributesWhenPresent(query);
        query = this.applyAnnotatedDefaultSortIfPresent(query);
        query = this.applyAnnotatedCollationIfPresent(query, accessor);
        query = this.applyHintIfPresent(query);
        ExecutableFindOperation.ExecutableFind<?> find = typeToRead == null ? this.executableFind : this.executableFind.as(typeToRead);
        return this.getExecution(accessor, find).execute(query);
    }

    private MongoQueryExecution getExecution(ConvertingParameterAccessor accessor, ExecutableFindOperation.FindWithQuery<?> operation) {
        if (this.isDeleteQuery()) {
            return new MongoQueryExecution.DeleteExecution(this.operations, this.method);
        }
        if (this.method.isModifyingQuery()) {
            if (this.isLimiting()) {
                throw new IllegalStateException(String.format("Update method must not be limiting; Offending method: %s", new Object[]{this.method}));
            }
            return new MongoQueryExecution.UpdateExecution(this.executableUpdate, this.method, () -> this.createUpdate(accessor), accessor);
        }
        if (this.method.isGeoNearQuery() && this.method.isPageQuery()) {
            return new MongoQueryExecution.PagingGeoNearExecution(operation, this.method, accessor, this);
        }
        if (this.method.isGeoNearQuery()) {
            return new MongoQueryExecution.GeoNearExecution(operation, this.method, accessor);
        }
        if (this.method.isSliceQuery()) {
            return new MongoQueryExecution.SlicedExecution(operation, accessor.getPageable());
        }
        if (this.method.isStreamQuery()) {
            return q -> operation.matching(q).stream();
        }
        if (this.method.isCollectionQuery()) {
            return q -> operation.matching(q.with(accessor.getPageable()).with(accessor.getSort())).all();
        }
        if (this.method.isScrollQuery()) {
            return q -> operation.matching(q.with(accessor.getPageable()).with(accessor.getSort())).scroll(accessor.getScrollPosition());
        }
        if (this.method.isPageQuery()) {
            return new MongoQueryExecution.PagedExecution(operation, accessor.getPageable());
        }
        if (this.isCountQuery()) {
            return q -> operation.matching(q).count();
        }
        if (this.isExistsQuery()) {
            return q -> operation.matching(q).exists();
        }
        return q -> {
            ExecutableFindOperation.TerminatingFind find = operation.matching(q);
            return this.isLimiting() ? find.firstValue() : find.oneValue();
        };
    }

    Query applyQueryMetaAttributesWhenPresent(Query query) {
        if (this.method.hasQueryMetaAttributes()) {
            query.setMeta(this.method.getQueryMetaAttributes());
        }
        return query;
    }

    Query applyAnnotatedDefaultSortIfPresent(Query query) {
        if (!this.method.hasAnnotatedSort()) {
            return query;
        }
        return QueryUtils.decorateSort(query, Document.parse((String)this.method.getAnnotatedSort()));
    }

    Query applyAnnotatedCollationIfPresent(Query query, ConvertingParameterAccessor accessor) {
        return QueryUtils.applyCollation(query, this.method.hasAnnotatedCollation() ? this.method.getAnnotatedCollation() : null, accessor, this.getQueryMethod().getParameters(), this.expressionParser, this.evaluationContextProvider);
    }

    Query applyHintIfPresent(Query query) {
        if (!this.method.hasAnnotatedHint()) {
            return query;
        }
        return query.withHint(this.method.getAnnotatedHint());
    }

    protected Query createCountQuery(ConvertingParameterAccessor accessor) {
        return this.applyQueryMetaAttributesWhenPresent(this.createQuery(accessor));
    }

    protected UpdateDefinition createUpdate(ConvertingParameterAccessor accessor) {
        if (accessor.getUpdate() != null) {
            return accessor.getUpdate();
        }
        if (this.method.hasAnnotatedUpdate()) {
            Update updateSource = this.method.getUpdateSource();
            if (StringUtils.hasText((String)updateSource.update())) {
                return new BasicUpdate(this.bindParameters(updateSource.update(), accessor));
            }
            if (!ObjectUtils.isEmpty((Object[])updateSource.pipeline())) {
                return AggregationUpdate.from(this.parseAggregationPipeline(updateSource.pipeline(), accessor));
            }
        }
        throw new IllegalStateException(String.format("No Update provided for method %s.", new Object[]{this.method}));
    }

    protected List<AggregationOperation> parseAggregationPipeline(String[] sourcePipeline, ConvertingParameterAccessor accessor) {
        ArrayList<AggregationOperation> stages = new ArrayList<AggregationOperation>(sourcePipeline.length);
        for (String source : sourcePipeline) {
            stages.add(this.computePipelineStage(source, accessor));
        }
        return stages;
    }

    private AggregationOperation computePipelineStage(String source, ConvertingParameterAccessor accessor) {
        return ctx -> ctx.getMappedObject(this.bindParameters(source, accessor), this.getQueryMethod().getDomainClass());
    }

    protected Document decode(String source, ParameterBindingContext bindingContext) {
        return this.getParameterBindingCodec().decode(source, bindingContext);
    }

    private Document bindParameters(String source, ConvertingParameterAccessor accessor) {
        return this.decode(source, this.prepareBindingContext(source, accessor));
    }

    protected ParameterBindingContext prepareBindingContext(String source, ConvertingParameterAccessor accessor) {
        ExpressionDependencies dependencies = this.getParameterBindingCodec().captureExpressionDependencies(source, accessor::getBindableValue, this.expressionParser);
        SpELExpressionEvaluator evaluator = this.getSpELExpressionEvaluatorFor(dependencies, accessor);
        return new ParameterBindingContext(accessor::getBindableValue, evaluator);
    }

    protected ParameterBindingDocumentCodec getParameterBindingCodec() {
        return (ParameterBindingDocumentCodec)this.codec.get();
    }

    protected SpELExpressionEvaluator getSpELExpressionEvaluatorFor(ExpressionDependencies dependencies, ConvertingParameterAccessor accessor) {
        return new DefaultSpELExpressionEvaluator(this.expressionParser, this.evaluationContextProvider.getEvaluationContext((Parameters)this.getQueryMethod().getParameters(), accessor.getValues(), dependencies));
    }

    protected CodecRegistry getCodecRegistry() {
        return this.operations.execute(MongoDatabase::getCodecRegistry);
    }

    protected abstract Query createQuery(ConvertingParameterAccessor var1);

    protected abstract boolean isCountQuery();

    protected abstract boolean isExistsQuery();

    protected abstract boolean isDeleteQuery();

    protected abstract boolean isLimiting();
}

