/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.ArrayList;
import java.util.List;
import java.util.function.LongUnaryOperator;
import java.util.stream.Stream;
import org.bson.Document;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.mongodb.InvalidMongoDbApiUsageException;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.aggregation.AggregationPipeline;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.AbstractMongoQuery;
import org.springframework.data.mongodb.repository.query.AggregationUtils;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.expression.ExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class StringBasedAggregation
extends AbstractMongoQuery {
    private final MongoOperations mongoOperations;
    private final MongoConverter mongoConverter;
    private final ExpressionParser expressionParser;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;

    public StringBasedAggregation(MongoQueryMethod method, MongoOperations mongoOperations, ExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, mongoOperations, expressionParser, evaluationContextProvider);
        if (method.isPageQuery()) {
            throw new InvalidMongoDbApiUsageException(String.format("Repository aggregation method '%s' does not support '%s' return type; Please use 'Slice' or 'List' instead", method.getName(), method.getReturnType().getType().getSimpleName()));
        }
        this.mongoOperations = mongoOperations;
        this.mongoConverter = mongoOperations.getConverter();
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    @Override
    @Nullable
    protected Object doExecute(MongoQueryMethod method, ResultProcessor resultProcessor, ConvertingParameterAccessor accessor, Class<?> typeToRead) {
        Class<?> sourceType = method.getDomainClass();
        Class targetType = typeToRead;
        AggregationPipeline pipeline = this.computePipeline(method, accessor);
        AggregationUtils.appendSortIfPresent(pipeline, accessor, typeToRead);
        if (method.isSliceQuery()) {
            AggregationUtils.appendLimitAndOffsetIfPresent(pipeline, accessor, LongUnaryOperator.identity(), limit -> limit + 1);
        } else {
            AggregationUtils.appendLimitAndOffsetIfPresent(pipeline, accessor);
        }
        boolean isSimpleReturnType = this.isSimpleReturnType(typeToRead);
        boolean isRawAggregationResult = ClassUtils.isAssignable(AggregationResults.class, typeToRead);
        if (isSimpleReturnType) {
            targetType = Document.class;
        } else if (isRawAggregationResult) {
            targetType = method.getReturnType().getRequiredActualType().getRequiredComponentType().getType();
        }
        AggregationOptions options = this.computeOptions(method, accessor, pipeline);
        TypedAggregation aggregation = new TypedAggregation(sourceType, pipeline.getOperations(), options);
        if (method.isStreamQuery()) {
            Stream stream = this.mongoOperations.aggregateStream(aggregation, targetType);
            if (isSimpleReturnType) {
                return stream.map(it -> AggregationUtils.extractSimpleTypeResult((Document)it, typeToRead, this.mongoConverter));
            }
            return stream;
        }
        AggregationResults result = this.mongoOperations.aggregate(aggregation, targetType);
        if (ReflectionUtils.isVoid(typeToRead)) {
            return null;
        }
        if (isRawAggregationResult) {
            return result;
        }
        List<Object> results = result.getMappedResults();
        if (method.isCollectionQuery()) {
            return isSimpleReturnType ? this.convertResults(typeToRead, results) : results;
        }
        if (method.isSliceQuery()) {
            Pageable pageable = accessor.getPageable();
            int pageSize = pageable.getPageSize();
            List<Object> resultsToUse = isSimpleReturnType ? this.convertResults(typeToRead, results) : results;
            boolean hasNext = resultsToUse.size() > pageSize;
            return new SliceImpl(hasNext ? resultsToUse.subList(0, pageSize) : resultsToUse, pageable, hasNext);
        }
        Object uniqueResult = result.getUniqueMappedResult();
        return isSimpleReturnType ? AggregationUtils.extractSimpleTypeResult((Document)uniqueResult, typeToRead, this.mongoConverter) : uniqueResult;
    }

    private List<Object> convertResults(Class<?> typeToRead, List<Object> mappedResults) {
        ArrayList<Object> list = new ArrayList<Object>(mappedResults.size());
        for (Object it : mappedResults) {
            Object extractSimpleTypeResult = AggregationUtils.extractSimpleTypeResult((Document)it, typeToRead, this.mongoConverter);
            list.add(extractSimpleTypeResult);
        }
        return list;
    }

    private boolean isSimpleReturnType(Class<?> targetType) {
        return MongoSimpleTypes.HOLDER.isSimpleType(targetType);
    }

    AggregationPipeline computePipeline(MongoQueryMethod method, ConvertingParameterAccessor accessor) {
        return new AggregationPipeline(this.parseAggregationPipeline(method.getAnnotatedAggregation(), accessor));
    }

    private AggregationOptions computeOptions(MongoQueryMethod method, ConvertingParameterAccessor accessor, AggregationPipeline pipeline) {
        AggregationOptions.Builder builder = Aggregation.newAggregationOptions();
        AggregationUtils.applyCollation(builder, method.getAnnotatedCollation(), accessor, method.getParameters(), this.expressionParser, this.evaluationContextProvider);
        AggregationUtils.applyMeta(builder, method);
        if (ReflectionUtils.isVoid((Class)method.getReturnType().getType()) && pipeline.isOutOrMerge()) {
            builder.skipOutput();
        }
        return builder.build();
    }

    @Override
    protected Query createQuery(ConvertingParameterAccessor accessor) {
        throw new UnsupportedOperationException("No query support for aggregation");
    }

    @Override
    protected boolean isCountQuery() {
        return false;
    }

    @Override
    protected boolean isExistsQuery() {
        return false;
    }

    @Override
    protected boolean isDeleteQuery() {
        return false;
    }

    @Override
    protected boolean isLimiting() {
        return false;
    }
}

