/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.spel;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.data.mongodb.core.spel.ExpressionNode;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.ast.OpAnd;
import org.springframework.expression.spel.ast.OpDivide;
import org.springframework.expression.spel.ast.OpEQ;
import org.springframework.expression.spel.ast.OpGE;
import org.springframework.expression.spel.ast.OpGT;
import org.springframework.expression.spel.ast.OpLE;
import org.springframework.expression.spel.ast.OpLT;
import org.springframework.expression.spel.ast.OpMinus;
import org.springframework.expression.spel.ast.OpModulus;
import org.springframework.expression.spel.ast.OpMultiply;
import org.springframework.expression.spel.ast.OpNE;
import org.springframework.expression.spel.ast.OpOr;
import org.springframework.expression.spel.ast.OpPlus;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.OperatorPower;

public class OperatorNode
extends ExpressionNode {
    private static final Map<String, String> OPERATORS;
    private static final Set<Class> SUPPORTED_MATH_OPERATORS;
    private final Operator operator;

    OperatorNode(Operator node, ExpressionState state) {
        super((SpelNode)node, state);
        this.operator = node;
    }

    @Override
    public boolean isMathematicalOperation() {
        return SUPPORTED_MATH_OPERATORS.contains(this.operator.getClass());
    }

    @Override
    public boolean isLogicalOperator() {
        return this.operator instanceof OpOr || this.operator instanceof OpAnd;
    }

    public boolean isUnaryOperator() {
        return this.operator.getChildCount() == 1;
    }

    public String getMongoOperator() {
        if (!OPERATORS.containsKey(this.operator.getOperatorName())) {
            throw new IllegalArgumentException(String.format("Unknown operator name. Cannot translate %s into its MongoDB aggregation function representation.", this.operator.getOperatorName()));
        }
        return OPERATORS.get(this.operator.getOperatorName());
    }

    public boolean isUnaryMinus() {
        return this.isUnaryOperator() && this.operator instanceof OpMinus;
    }

    public ExpressionNode getLeft() {
        return this.from((SpelNode)this.operator.getLeftOperand());
    }

    public ExpressionNode getRight() {
        return this.from((SpelNode)this.operator.getRightOperand());
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>(14, 1.0f);
        map.put("+", "$add");
        map.put("-", "$subtract");
        map.put("*", "$multiply");
        map.put("/", "$divide");
        map.put("%", "$mod");
        map.put("^", "$pow");
        map.put("==", "$eq");
        map.put("!=", "$ne");
        map.put(">", "$gt");
        map.put(">=", "$gte");
        map.put("<", "$lt");
        map.put("<=", "$lte");
        map.put("and", "$and");
        map.put("or", "$or");
        OPERATORS = Collections.unmodifiableMap(map);
        HashSet<Class> set = new HashSet<Class>(12, 1.0f);
        set.add(OpMinus.class);
        set.add(OpPlus.class);
        set.add(OpMultiply.class);
        set.add(OpDivide.class);
        set.add(OpModulus.class);
        set.add(OperatorPower.class);
        set.add(OpNE.class);
        set.add(OpEQ.class);
        set.add(OpGT.class);
        set.add(OpGE.class);
        set.add(OpLT.class);
        set.add(OpLE.class);
        SUPPORTED_MATH_OPERATORS = Collections.unmodifiableSet(set);
    }
}

