/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.util.Assert;

@Deprecated
public enum AggregationFunctionExpressions {
    SIZE,
    CMP,
    EQ,
    GT,
    GTE,
    LT,
    LTE,
    NE,
    SUBTRACT,
    ADD,
    MULTIPLY;


    public AggregationExpression of(Object ... parameters) {
        Assert.notNull((Object)parameters, (String)"Parameters must not be null!");
        return new FunctionExpression(this.name().toLowerCase(), parameters);
    }

    static class FunctionExpression
    implements AggregationExpression {
        private final String name;
        private final List<Object> values;

        public FunctionExpression(String name, Object[] values) {
            Assert.hasText((String)name, (String)"Name must not be null!");
            Assert.notNull((Object)values, (String)"Values must not be null!");
            this.name = name;
            this.values = Arrays.asList(values);
        }

        @Override
        public Document toDocument(AggregationOperationContext context) {
            ArrayList<Object> args = new ArrayList<Object>(this.values.size());
            for (Object value : this.values) {
                args.add(FunctionExpression.unpack(value, context));
            }
            return new Document("$" + this.name, args);
        }

        private static Object unpack(Object value, AggregationOperationContext context) {
            if (value instanceof AggregationExpression) {
                return ((AggregationExpression)value).toDocument(context);
            }
            if (value instanceof Field) {
                return context.getReference((Field)value).toString();
            }
            return value;
        }
    }
}

