/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.math.BigInteger;
import java.util.Date;
import org.bson.types.Code;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.ConverterBuilder;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverters;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractMongoConverter
implements MongoConverter,
InitializingBean {
    protected final GenericConversionService conversionService;
    protected CustomConversions conversions = new MongoCustomConversions();
    protected EntityInstantiators instantiators = new EntityInstantiators();

    public AbstractMongoConverter(@Nullable GenericConversionService conversionService) {
        this.conversionService = conversionService == null ? new DefaultConversionService() : conversionService;
    }

    public void setCustomConversions(CustomConversions conversions) {
        Assert.notNull((Object)conversions, (String)"Conversions must not be null!");
        this.conversions = conversions;
    }

    public void setInstantiators(@Nullable EntityInstantiators instantiators) {
        this.instantiators = instantiators == null ? new EntityInstantiators() : instantiators;
    }

    private void initializeConverters() {
        this.conversionService.addConverter((Converter)MongoConverters.ObjectIdToStringConverter.INSTANCE);
        this.conversionService.addConverter((Converter)MongoConverters.StringToObjectIdConverter.INSTANCE);
        if (!this.conversionService.canConvert(ObjectId.class, BigInteger.class)) {
            this.conversionService.addConverter((Converter)MongoConverters.ObjectIdToBigIntegerConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(BigInteger.class, ObjectId.class)) {
            this.conversionService.addConverter((Converter)MongoConverters.BigIntegerToObjectIdConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(Date.class, Long.class)) {
            this.conversionService.addConverter(ConverterBuilder.writing(Date.class, Long.class, Date::getTime).getWritingConverter());
        }
        if (!this.conversionService.canConvert(Long.class, Date.class)) {
            this.conversionService.addConverter(ConverterBuilder.reading(Long.class, Date.class, Date::new).getReadingConverter());
        }
        if (!this.conversionService.canConvert(ObjectId.class, Date.class)) {
            this.conversionService.addConverter(ConverterBuilder.reading(ObjectId.class, Date.class, objectId -> new Date(objectId.getTimestamp())).getReadingConverter());
        }
        this.conversionService.addConverter(ConverterBuilder.reading(Code.class, String.class, Code::getCode).getReadingConverter());
        this.conversions.registerConvertersIn((ConverterRegistry)this.conversionService);
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void afterPropertiesSet() {
        this.initializeConverters();
    }
}

