/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Collection;
import java.util.stream.Collectors;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.ReplaceRootOperation;
import org.springframework.util.Assert;

public class ReplaceWithOperation
extends ReplaceRootOperation {
    public ReplaceWithOperation(ReplaceRootOperation.Replacement replacement) {
        super(replacement);
    }

    public static ReplaceWithOperation replaceWithValue(Object value) {
        return new ReplaceWithOperation(ctx -> value);
    }

    public static ReplaceWithOperation replaceWithValueOf(Object value) {
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return new ReplaceWithOperation(ctx -> {
            Object target = value instanceof String ? Fields.field((String)value) : value;
            return ReplaceWithOperation.computeValue(target, ctx);
        });
    }

    private static Object computeValue(Object value, AggregationOperationContext context) {
        if (value instanceof Field) {
            return context.getReference((Field)value).toString();
        }
        if (value instanceof AggregationExpression) {
            return ((AggregationExpression)value).toDocument(context);
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(it -> ReplaceWithOperation.computeValue(it, context)).collect(Collectors.toList());
        }
        return value;
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        return context.getMappedObject(new Document("$replaceWith", this.getReplacement().toDocumentExpression(context)));
    }
}

