/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import com.mongodb.ServerAddress;
import java.beans.PropertyEditorSupport;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ServerAddressPropertyEditor
extends PropertyEditorSupport {
    private static final String HOST_PORT_SPLIT_PATTERN = "(?<!:):(?=[123456789]\\d*$)";
    private static final String COULD_NOT_PARSE_ADDRESS_MESSAGE = "Could not parse address {} '{}'. Check your replica set configuration!";
    private static final Logger LOG = LoggerFactory.getLogger(ServerAddressPropertyEditor.class);

    @Override
    public void setAsText(@Nullable String replicaSetString) {
        if (!StringUtils.hasText((String)replicaSetString)) {
            this.setValue(null);
            return;
        }
        String[] replicaSetStringArray = StringUtils.commaDelimitedListToStringArray((String)replicaSetString);
        HashSet<ServerAddress> serverAddresses = new HashSet<ServerAddress>(replicaSetStringArray.length);
        for (String element : replicaSetStringArray) {
            ServerAddress address = this.parseServerAddress(element);
            if (address == null) continue;
            serverAddresses.add(address);
        }
        if (serverAddresses.isEmpty()) {
            throw new IllegalArgumentException("Could not resolve at least one server of the replica set configuration! Validate your config!");
        }
        this.setValue(serverAddresses.toArray(new ServerAddress[serverAddresses.size()]));
    }

    @Nullable
    private ServerAddress parseServerAddress(String source) {
        if (!StringUtils.hasText((String)source)) {
            LOG.warn(COULD_NOT_PARSE_ADDRESS_MESSAGE, (Object)"source", (Object)source);
            return null;
        }
        String[] hostAndPort = this.extractHostAddressAndPort(source.trim());
        if (hostAndPort.length > 2) {
            LOG.warn(COULD_NOT_PARSE_ADDRESS_MESSAGE, (Object)"source", (Object)source);
            return null;
        }
        try {
            InetAddress hostAddress = InetAddress.getByName(hostAndPort[0]);
            Integer port = hostAndPort.length == 1 ? null : Integer.valueOf(Integer.parseInt(hostAndPort[1]));
            return port == null ? new ServerAddress(hostAddress) : new ServerAddress(hostAddress, port.intValue());
        }
        catch (UnknownHostException e) {
            LOG.warn(COULD_NOT_PARSE_ADDRESS_MESSAGE, (Object)"host", (Object)hostAndPort[0]);
        }
        catch (NumberFormatException e) {
            LOG.warn(COULD_NOT_PARSE_ADDRESS_MESSAGE, (Object)"port", (Object)hostAndPort[1]);
        }
        return null;
    }

    private String[] extractHostAddressAndPort(String addressAndPortSource) {
        Assert.notNull((Object)addressAndPortSource, (String)"Address and port source must not be null!");
        String[] hostAndPort = addressAndPortSource.split(HOST_PORT_SPLIT_PATTERN);
        String hostAddress = hostAndPort[0];
        if (this.isHostAddressInIPv6BracketNotation(hostAddress)) {
            hostAndPort[0] = hostAddress.substring(1, hostAddress.length() - 1);
        }
        return hostAndPort;
    }

    private boolean isHostAddressInIPv6BracketNotation(String hostAddress) {
        return hostAddress.startsWith("[") && hostAddress.endsWith("]");
    }
}

