/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.KPropertyPathKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u001a\u0019\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0086\u0004\u001a'\u0010\u0005\u001a\u00020\u0001*\u00020\u00012\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\"\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\t\u001a\u001e\u0010\u0005\u001a\u00020\u0001\"\u0004\b\u0000\u0010\n*\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\f\u001a\u0014\u0010\r\u001a\u00020\u0001*\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\b\u00a8\u0006\u000e"}, d2={"where", "Lorg/springframework/data/mongodb/core/query/Criteria;", "key", "Lkotlin/reflect/KProperty;", "and", "inValues", "o", "", "", "(Lorg/springframework/data/mongodb/core/query/Criteria;[Ljava/lang/Object;)Lorg/springframework/data/mongodb/core/query/Criteria;", "T", "c", "", "isEqualTo", "spring-data-mongodb"})
public final class CriteriaExtensionsKt {
    @NotNull
    public static final Criteria isEqualTo(@NotNull Criteria $this$isEqualTo, @Nullable Object o) {
        Intrinsics.checkNotNullParameter((Object)$this$isEqualTo, (String)"$this$isEqualTo");
        Criteria criteria = $this$isEqualTo.is(o);
        Intrinsics.checkNotNullExpressionValue((Object)criteria, (String)"`is`(o)");
        return criteria;
    }

    @NotNull
    public static final <T> Criteria inValues(@NotNull Criteria $this$inValues, @NotNull Collection<? extends T> c) {
        Intrinsics.checkNotNullParameter((Object)$this$inValues, (String)"$this$inValues");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Criteria criteria = $this$inValues.in(c);
        Intrinsics.checkNotNullExpressionValue((Object)criteria, (String)"`in`(c)");
        return criteria;
    }

    @NotNull
    public static final Criteria inValues(@NotNull Criteria $this$inValues, Object ... o) {
        Intrinsics.checkNotNullParameter((Object)$this$inValues, (String)"$this$inValues");
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Criteria criteria = $this$inValues.in(Arrays.copyOf(o, o.length));
        Intrinsics.checkNotNullExpressionValue((Object)criteria, (String)"`in`(*o)");
        return criteria;
    }

    @NotNull
    public static final Criteria where(@NotNull KProperty<?> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Criteria criteria = Criteria.where(KPropertyPathKt.asString(key));
        Intrinsics.checkNotNullExpressionValue((Object)criteria, (String)"Criteria.where(asString(key))");
        return criteria;
    }

    @NotNull
    public static final Criteria and(@NotNull Criteria $this$and, @NotNull KProperty<?> key) {
        Intrinsics.checkNotNullParameter((Object)$this$and, (String)"$this$and");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Criteria criteria = $this$and.and(KPropertyPathKt.asString(key));
        Intrinsics.checkNotNullExpressionValue((Object)criteria, (String)"and(asString(key))");
        return criteria;
    }
}

