/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Arrays;
import java.util.List;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.AggregationPipeline;
import org.springframework.data.mongodb.core.aggregation.ExposedFieldsAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.TypeBasedAggregationOperationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class UnionWithOperation
implements AggregationOperation {
    private final String collection;
    @Nullable
    private final AggregationPipeline pipeline;
    @Nullable
    private final Class<?> domainType;

    public UnionWithOperation(String collection, @Nullable AggregationPipeline pipeline, @Nullable Class<?> domainType) {
        Assert.notNull((Object)collection, (String)"Collection must not be null!");
        this.collection = collection;
        this.pipeline = pipeline;
        this.domainType = domainType;
    }

    public static UnionWithOperation unionWith(String collection) {
        return new UnionWithOperation(collection, null, null);
    }

    public UnionWithOperation pipeline(AggregationPipeline pipeline) {
        return new UnionWithOperation(this.collection, pipeline, this.domainType);
    }

    public UnionWithOperation pipeline(List<AggregationOperation> aggregationStages) {
        return new UnionWithOperation(this.collection, new AggregationPipeline(aggregationStages), this.domainType);
    }

    public UnionWithOperation pipeline(AggregationOperation ... aggregationStages) {
        return new UnionWithOperation(this.collection, new AggregationPipeline(Arrays.asList(aggregationStages)), this.domainType);
    }

    public UnionWithOperation mapFieldsTo(Class<?> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new UnionWithOperation(this.collection, this.pipeline, domainType);
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        Document $unionWith = new Document("coll", (Object)this.collection);
        if (this.pipeline == null || this.pipeline.isEmpty()) {
            return new Document(this.getOperator(), (Object)$unionWith);
        }
        $unionWith.append("pipeline", this.pipeline.toDocuments(this.computeContext(context)));
        return new Document(this.getOperator(), (Object)$unionWith);
    }

    private AggregationOperationContext computeContext(AggregationOperationContext source) {
        if (this.domainType == null) {
            return Aggregation.DEFAULT_CONTEXT;
        }
        if (source instanceof TypeBasedAggregationOperationContext) {
            return ((TypeBasedAggregationOperationContext)source).continueOnMissingFieldReference(this.domainType);
        }
        if (source instanceof ExposedFieldsAggregationOperationContext) {
            return this.computeContext(((ExposedFieldsAggregationOperationContext)source).getRootContext());
        }
        return source;
    }

    @Override
    public String getOperator() {
        return "$unionWith";
    }
}

