/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.ProcessBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.ldap.repository.cdi.LdapRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryExtensionSupport;
import org.springframework.ldap.core.LdapOperations;

public class LdapRepositoryExtension
extends CdiRepositoryExtensionSupport {
    private static final Log LOG = LogFactory.getLog(LdapRepositoryExtension.class);
    private final Map<Set<Annotation>, Bean<LdapOperations>> ldapOperations = new HashMap<Set<Annotation>, Bean<LdapOperations>>();

    public LdapRepositoryExtension() {
        LOG.info((Object)"Activating CDI extension for Spring Data LDAP repositories.");
    }

    <X> void processBean(@Observes ProcessBean<X> processBean) {
        Bean bean = processBean.getBean();
        for (Type type : bean.getTypes()) {
            if (!(type instanceof Class) || !LdapOperations.class.isAssignableFrom((Class)type)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Discovered %s with qualifiers %s.", LdapOperations.class.getName(), bean.getQualifiers()));
            }
            this.ldapOperations.put(new HashSet(bean.getQualifiers()), (Bean<LdapOperations>)bean);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (Map.Entry entry : this.getRepositoryTypes()) {
            Class repositoryType = (Class)entry.getKey();
            Set qualifiers = (Set)entry.getValue();
            CdiRepositoryBean repositoryBean = this.createRepositoryBean(repositoryType, qualifiers, beanManager);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)String.format("Registering bean for %s with qualifiers %s.", repositoryType.getName(), qualifiers));
            }
            this.registerBean(repositoryBean);
            afterBeanDiscovery.addBean(repositoryBean);
        }
    }

    private <T> CdiRepositoryBean<T> createRepositoryBean(Class<T> repositoryType, Set<Annotation> qualifiers, BeanManager beanManager) {
        Bean<LdapOperations> LdapOperations2 = this.ldapOperations.get(qualifiers);
        if (LdapOperations2 == null) {
            throw new UnsatisfiedResolutionException(String.format("Unable to resolve a bean for '%s' with qualifiers %s.", LdapOperations.class.getName(), qualifiers));
        }
        return new LdapRepositoryBean<T>(LdapOperations2, qualifiers, repositoryType, beanManager, Optional.of(this.getCustomImplementationDetector()));
    }
}

