/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.Tree;
import org.springframework.data.jpa.repository.query.HqlBaseVisitor;
import org.springframework.data.jpa.repository.query.HqlParser;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryTokenStream;
import org.springframework.data.jpa.repository.query.QueryTokens;
import org.springframework.util.CollectionUtils;

class HqlQueryRenderer
extends HqlBaseVisitor<QueryTokenStream> {
    HqlQueryRenderer() {
    }

    static boolean isSubquery(ParserRuleContext ctx) {
        if (ctx instanceof HqlParser.SubqueryContext || ctx instanceof HqlParser.CteContext) {
            return true;
        }
        if (ctx instanceof HqlParser.SelectStatementContext) {
            return false;
        }
        if (ctx instanceof HqlParser.InsertStatementContext) {
            return false;
        }
        if (ctx instanceof HqlParser.DeleteStatementContext) {
            return false;
        }
        if (ctx instanceof HqlParser.UpdateStatementContext) {
            return false;
        }
        return ctx.getParent() != null && HqlQueryRenderer.isSubquery(ctx.getParent());
    }

    static boolean isSetQuery(ParserRuleContext ctx) {
        HqlParser.QueryExpressionContext qec;
        ParserRuleContext parserRuleContext;
        if (ctx instanceof HqlParser.OrderedQueryContext && (parserRuleContext = ctx.getParent()) instanceof HqlParser.QueryExpressionContext && (qec = (HqlParser.QueryExpressionContext)parserRuleContext).orderedQuery().indexOf(ctx) != 0) {
            return true;
        }
        return ctx.getParent() != null && HqlQueryRenderer.isSetQuery(ctx.getParent());
    }

    @Override
    public QueryTokenStream visitStart(HqlParser.StartContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.ql_statement());
    }

    @Override
    public QueryTokenStream visitWithClause(HqlParser.WithClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.WITH()));
        builder.append(QueryTokenStream.concatExpressions(ctx.cte(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitCte(HqlParser.CteContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        builder.append(QueryTokens.TOKEN_AS);
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        if (ctx.MATERIALIZED() != null) {
            builder.append(QueryTokens.TOKEN_MATERIALIZED);
        }
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.queryExpression()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        if (ctx.searchClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.searchClause()));
        }
        if (ctx.cycleClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.cycleClause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitCteAttributes(HqlParser.CteAttributesContext ctx) {
        return QueryTokenStream.concat(ctx.identifier(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA);
    }

    @Override
    public QueryTokenStream visitOrderedQuery(HqlParser.OrderedQueryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.query() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.query()));
        } else if (ctx.queryExpression() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.queryExpression()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        if (ctx.queryOrder() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.queryOrder()));
        }
        if (ctx.limitClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.limitClause()));
        }
        if (ctx.offsetClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.offsetClause()));
        }
        if (ctx.fetchClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.fetchClause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFromClause(HqlParser.FromClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.FROM()));
        builder.appendExpression(QueryTokenStream.concat(ctx.entityWithJoins(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitEntityWithJoins(HqlParser.EntityWithJoinsContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.fromRoot()));
        builder.appendInline(QueryTokenStream.concat(ctx.joinSpecifier(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.EMPTY_TOKEN));
        return builder;
    }

    @Override
    public QueryTokenStream visitRootSubquery(HqlParser.RootSubqueryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.LATERAL() != null) {
            builder.append(QueryTokens.expression(ctx.LATERAL()));
        }
        builder.appendExpression(QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.subquery())));
        if (ctx.variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSimpleSetReturningFunction(HqlParser.SimpleSetReturningFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        if (ctx.genericFunctionArguments() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.genericFunctionArguments()));
        }
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitJoin(HqlParser.JoinContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_SPACE);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.joinType()));
        builder.append(QueryTokens.expression(ctx.JOIN()));
        if (ctx.FETCH() != null) {
            builder.append(QueryTokens.expression(ctx.FETCH()));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.joinTarget()));
        if (ctx.joinRestriction() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.joinRestriction()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitJoinSubquery(HqlParser.JoinSubqueryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.LATERAL() != null) {
            builder.append(QueryTokens.expression(ctx.LATERAL()));
        }
        builder.append(QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.subquery())));
        if (ctx.variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSetClause(HqlParser.SetClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.SET()));
        return builder.append(QueryTokenStream.concat(ctx.assignment(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
    }

    @Override
    public QueryTokenStream visitAssignment(HqlParser.AssignmentContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
        builder.append(QueryTokens.TOKEN_EQUALS);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate()));
        return builder;
    }

    @Override
    public QueryTokenStream visitTargetFields(HqlParser.TargetFieldsContext ctx) {
        return QueryTokenStream.group(QueryTokenStream.concat(ctx.simplePath(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
    }

    @Override
    public QueryTokenStream visitValuesList(HqlParser.ValuesListContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.VALUES()));
        builder.append(QueryTokenStream.concat(ctx.values(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitValues(HqlParser.ValuesContext ctx) {
        return QueryTokenStream.group(QueryTokenStream.concat(ctx.expression(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
    }

    @Override
    public QueryTokenStream visitConflictTarget(HqlParser.ConflictTargetContext ctx) {
        if (ctx.identifier() != null) {
            return QueryTokenStream.concatExpressions(ctx.children, arg_0 -> ((HqlQueryRenderer)this).visit(arg_0));
        }
        return QueryTokenStream.group(QueryTokenStream.concat(ctx.simplePath(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
    }

    @Override
    public QueryTokenStream visitInstantiation(HqlParser.InstantiationContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.NEW()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.instantiationTarget()));
        builder.append(QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.instantiationArguments())));
        return builder;
    }

    @Override
    public QueryTokenStream visitSelectionList(HqlParser.SelectionListContext ctx) {
        return QueryTokenStream.concat(ctx.selection(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA);
    }

    @Override
    public QueryTokenStream visitMapEntrySelection(HqlParser.MapEntrySelectionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.ENTRY()));
        builder.append(QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.path())));
        return builder;
    }

    @Override
    public QueryTokenStream visitJpaSelectObjectSyntax(HqlParser.JpaSelectObjectSyntaxContext ctx) {
        return QueryTokenStream.ofFunction(ctx.OBJECT(), (QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public QueryTokenStream visitWhereClause(HqlParser.WhereClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.WHERE()));
        builder.append(QueryTokenStream.concatExpressions(ctx.predicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitJpaCollectionJoin(HqlParser.JpaCollectionJoinContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_COMMA);
        builder.append(QueryTokens.token(ctx.IN()));
        builder.append(QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.path())));
        if (ctx.variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitGroupByClause(HqlParser.GroupByClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.GROUP()));
        builder.append(QueryTokens.expression(ctx.BY()));
        builder.append(QueryTokenStream.concat(ctx.groupedItem(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitOrderByClause(HqlParser.OrderByClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.ORDER()));
        builder.append(QueryTokens.expression(ctx.BY()));
        builder.appendExpression(QueryTokenStream.concat(ctx.sortedItem(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitHavingClause(HqlParser.HavingClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.HAVING()));
        builder.appendExpression(QueryTokenStream.concat(ctx.predicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitLocalDateTimeLiteral(HqlParser.LocalDateTimeLiteralContext ctx) {
        if (ctx.DATETIME() == null) {
            return QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.localDateTime()));
        }
        return QueryTokenStream.concatExpressions(ctx.children, arg_0 -> ((HqlQueryRenderer)this).visit(arg_0));
    }

    @Override
    public QueryTokenStream visitZonedDateTimeLiteral(HqlParser.ZonedDateTimeLiteralContext ctx) {
        if (ctx.DATETIME() == null) {
            return QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.zonedDateTime()));
        }
        return QueryTokenStream.concatExpressions(ctx.children, arg_0 -> ((HqlQueryRenderer)this).visit(arg_0));
    }

    @Override
    public QueryTokenStream visitOffsetDateTimeLiteral(HqlParser.OffsetDateTimeLiteralContext ctx) {
        if (ctx.DATETIME() == null) {
            return QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.offsetDateTime()));
        }
        return QueryTokenStream.concatExpressions(ctx.children, arg_0 -> ((HqlQueryRenderer)this).visit(arg_0));
    }

    @Override
    public QueryTokenStream visitDateLiteral(HqlParser.DateLiteralContext ctx) {
        if (ctx.DATE() == null) {
            return QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.date()));
        }
        return QueryTokenStream.concatExpressions(ctx.children, arg_0 -> ((HqlQueryRenderer)this).visit(arg_0));
    }

    @Override
    public QueryTokenStream visitTimeLiteral(HqlParser.TimeLiteralContext ctx) {
        if (ctx.TIME() == null) {
            return QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.time()));
        }
        return QueryTokenStream.concatExpressions(ctx.children, arg_0 -> ((HqlQueryRenderer)this).visit(arg_0));
    }

    @Override
    public QueryTokenStream visitOffsetDateTime(HqlParser.OffsetDateTimeContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.date()));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.time()));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.offset()));
        return builder;
    }

    @Override
    public QueryTokenStream visitOffsetDateTimeWithMinutes(HqlParser.OffsetDateTimeWithMinutesContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.date()));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.time()));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.offsetWithMinutes()));
        return builder;
    }

    @Override
    public QueryTokenStream visitJdbcTimestampLiteral(HqlParser.JdbcTimestampLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_BRACE);
        builder.append(QueryTokens.token("ts"));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)(ctx.dateTime() != null ? ctx.dateTime() : ctx.genericTemporalLiteralText())));
        builder.append(QueryTokens.TOKEN_CLOSE_BRACE);
        return builder;
    }

    @Override
    public QueryTokenStream visitJdbcDateLiteral(HqlParser.JdbcDateLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_BRACE);
        builder.append(QueryTokens.token("d"));
        builder.append((QueryTokenStream)this.visit((ParseTree)(ctx.date() != null ? ctx.date() : ctx.genericTemporalLiteralText())));
        builder.append(QueryTokens.TOKEN_CLOSE_BRACE);
        return builder;
    }

    @Override
    public QueryTokenStream visitJdbcTimeLiteral(HqlParser.JdbcTimeLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_BRACE);
        builder.append(QueryTokens.token("t"));
        builder.append((QueryTokenStream)this.visit((ParseTree)(ctx.time() != null ? ctx.time() : ctx.genericTemporalLiteralText())));
        builder.append(QueryTokens.TOKEN_CLOSE_BRACE);
        return builder;
    }

    @Override
    public QueryTokenStream visitArrayLiteral(HqlParser.ArrayLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_SQUARE_BRACKET);
        builder.append(QueryTokenStream.concat(ctx.expression(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        builder.append(QueryTokens.TOKEN_CLOSE_SQUARE_BRACKET);
        return builder;
    }

    @Override
    public QueryTokenStream visitGeneralizedLiteral(HqlParser.GeneralizedLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.generalizedLiteralType()));
        builder.append(QueryTokens.TOKEN_COLON);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.generalizedLiteralText()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitDate(HqlParser.DateContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.year()));
        builder.append(QueryTokens.TOKEN_DASH);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.month()));
        builder.append(QueryTokens.TOKEN_DASH);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.day()));
        return builder;
    }

    @Override
    public QueryTokenStream visitTime(HqlParser.TimeContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.hour()));
        builder.append(QueryTokens.TOKEN_COLON);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.minute()));
        if (ctx.second() != null) {
            builder.append(QueryTokens.TOKEN_COLON);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.second()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitOffset(HqlParser.OffsetContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.MINUS() != null) {
            builder.append(QueryTokens.token(ctx.MINUS()));
        } else if (ctx.PLUS() != null) {
            builder.append(QueryTokens.token(ctx.PLUS()));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.hour()));
        if (ctx.minute() != null) {
            builder.append(QueryTokens.TOKEN_COLON);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.minute()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitOffsetWithMinutes(HqlParser.OffsetWithMinutesContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.MINUS() != null) {
            builder.append(QueryTokens.token(ctx.MINUS()));
        } else if (ctx.PLUS() != null) {
            builder.append(QueryTokens.token(ctx.PLUS()));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.hour()));
        builder.append(QueryTokens.TOKEN_COLON);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.minute()));
        return builder;
    }

    @Override
    public QueryTokenStream visitBinaryLiteral(HqlParser.BinaryLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.BINARY_LITERAL() != null) {
            builder.append(QueryTokens.expression(ctx.BINARY_LITERAL()));
        } else if (ctx.HEX_LITERAL() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_BRACE);
            builder.append(QueryTokenStream.concat(ctx.HEX_LITERAL(), QueryTokens::token, QueryTokens.TOKEN_COMMA));
            builder.append(QueryTokens.TOKEN_CLOSE_BRACE);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitTupleExpression(HqlParser.TupleExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append(QueryTokenStream.concat(ctx.expressionOrPredicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitHqlConcatenationExpression(HqlParser.HqlConcatenationExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        builder.append(QueryTokens.TOKEN_DOUBLE_PIPE);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        return builder;
    }

    @Override
    public QueryTokenStream visitGroupedExpression(HqlParser.GroupedExpressionContext ctx) {
        return QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
    }

    @Override
    public QueryTokenStream visitSignedNumericLiteral(HqlParser.SignedNumericLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.op));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.numericLiteral()));
        return builder;
    }

    @Override
    public QueryTokenStream visitSubqueryExpression(HqlParser.SubqueryExpressionContext ctx) {
        return QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
    }

    @Override
    public QueryTokenStream visitSignedExpression(HqlParser.SignedExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.op));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        return builder;
    }

    @Override
    public QueryTokenStream visitSyntacticPathExpression(HqlParser.SyntacticPathExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.syntacticDomainPath()));
        if (ctx.pathContinuation() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.pathContinuation()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitPathContinuation(HqlParser.PathContinuationContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_DOT);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
        return builder;
    }

    @Override
    public QueryTokenStream visitEntityTypeReference(HqlParser.EntityTypeReferenceContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.path() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        }
        if (ctx.parameter() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.parameter()));
        }
        return QueryTokenStream.ofFunction(ctx.TYPE(), builder);
    }

    @Override
    public QueryTokenStream visitEntityIdReference(HqlParser.EntityIdReferenceContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.ID()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        if (ctx.pathContinuation() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.pathContinuation()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitEntityVersionReference(HqlParser.EntityVersionReferenceContext ctx) {
        return QueryTokenStream.ofFunction(ctx.VERSION(), (QueryTokenStream)this.visit((ParseTree)ctx.path()));
    }

    @Override
    public QueryTokenStream visitEntityNaturalIdReference(HqlParser.EntityNaturalIdReferenceContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.NATURALID()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        if (ctx.pathContinuation() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.pathContinuation()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSyntacticDomainPath(HqlParser.SyntacticDomainPathContext ctx) {
        if (ctx.treatedNavigablePath() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.treatedNavigablePath());
        }
        if (ctx.collectionValueNavigablePath() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.collectionValueNavigablePath());
        }
        if (ctx.mapKeyNavigablePath() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.mapKeyNavigablePath());
        }
        if (ctx.toOneFkReference() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.toOneFkReference());
        }
        if (ctx.function() != null) {
            QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.function()));
            if (ctx.indexedPathAccessFragment() != null) {
                builder.append((QueryTokenStream)this.visit((ParseTree)ctx.indexedPathAccessFragment()));
            }
            if (ctx.slicedPathAccessFragment() != null) {
                builder.append((QueryTokenStream)this.visit((ParseTree)ctx.slicedPathAccessFragment()));
            }
            if (ctx.pathContinuation() != null) {
                builder.append((QueryTokenStream)this.visit((ParseTree)ctx.pathContinuation()));
            }
            return builder;
        }
        if (ctx.indexedPathAccessFragment() != null) {
            QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.indexedPathAccessFragment()));
            return builder;
        }
        if (ctx.slicedPathAccessFragment() != null) {
            QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.slicedPathAccessFragment()));
            return builder;
        }
        return QueryRenderer.empty();
    }

    @Override
    public QueryTokenStream visitSlicedPathAccessFragment(HqlParser.SlicedPathAccessFragmentContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_SQUARE_BRACKET);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        builder.append(QueryTokens.TOKEN_COLON);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        builder.append(QueryTokens.TOKEN_CLOSE_SQUARE_BRACKET);
        return builder;
    }

    @Override
    public QueryTokenStream visitSubstringFunction(HqlParser.SubstringFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.FROM() == null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
            builder.append(QueryTokens.TOKEN_COMMA);
        } else {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
            builder.append(QueryTokens.expression(ctx.FROM()));
        }
        if (ctx.substringFunctionLengthArgument() != null) {
            if (ctx.FOR() == null) {
                builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.substringFunctionStartArgument()));
                builder.append(QueryTokens.TOKEN_COMMA);
            } else {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.substringFunctionStartArgument()));
                builder.append(QueryTokens.expression(ctx.FOR()));
            }
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.substringFunctionLengthArgument()));
        } else {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.substringFunctionStartArgument()));
        }
        return QueryTokenStream.ofFunction(ctx.SUBSTRING(), builder);
    }

    @Override
    public QueryTokenStream visitPadFunction(HqlParser.PadFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.append(QueryTokens.expression(ctx.WITH()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.padLength()));
        if (ctx.padCharacter() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.padSpecification()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.padCharacter()));
        } else {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.padSpecification()));
        }
        return QueryTokenStream.ofFunction(ctx.PAD(), builder);
    }

    @Override
    public QueryTokenStream visitPositionFunction(HqlParser.PositionFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.positionFunctionPatternArgument()));
        nested.append(QueryTokens.expression(ctx.IN()));
        nested.append((QueryTokenStream)this.visit((ParseTree)ctx.positionFunctionStringArgument()));
        return QueryTokenStream.ofFunction(ctx.POSITION(), nested);
    }

    @Override
    public QueryTokenStream visitOverlayFunction(HqlParser.OverlayFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.OVERLAY()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.overlayFunctionStringArgument()));
        builder.append(QueryTokens.expression(ctx.PLACING()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.overlayFunctionReplacementArgument()));
        builder.append(QueryTokens.expression(ctx.FROM()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.overlayFunctionStartArgument()));
        if (ctx.overlayFunctionLengthArgument() != null) {
            builder.append(QueryTokens.expression(ctx.FOR()));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.overlayFunctionLengthArgument()));
        }
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitCurrentDateFunction(HqlParser.CurrentDateFunctionContext ctx) {
        if (ctx.CURRENT_DATE() != null) {
            return QueryTokenStream.ofFunction(ctx.CURRENT_DATE(), QueryTokenStream.empty());
        }
        return QueryTokenStream.concatExpressions(ctx.children, arg_0 -> ((HqlQueryRenderer)this).visit(arg_0));
    }

    @Override
    public QueryTokenStream visitCurrentTimeFunction(HqlParser.CurrentTimeFunctionContext ctx) {
        if (ctx.CURRENT_TIME() != null) {
            return QueryTokenStream.ofFunction(ctx.CURRENT_TIME(), QueryTokenStream.empty());
        }
        return QueryTokenStream.concatExpressions(ctx.children, arg_0 -> ((HqlQueryRenderer)this).visit(arg_0));
    }

    @Override
    public QueryTokenStream visitCurrentTimestampFunction(HqlParser.CurrentTimestampFunctionContext ctx) {
        if (ctx.CURRENT_TIMESTAMP() != null) {
            return QueryTokenStream.ofFunction(ctx.CURRENT_TIMESTAMP(), QueryTokenStream.empty());
        }
        return QueryTokenStream.concatExpressions(ctx.children, arg_0 -> ((HqlQueryRenderer)this).visit(arg_0));
    }

    @Override
    public QueryTokenStream visitInstantFunction(HqlParser.InstantFunctionContext ctx) {
        if (ctx.CURRENT_INSTANT() != null) {
            return QueryTokenStream.ofFunction(ctx.CURRENT_INSTANT(), QueryTokenStream.empty());
        }
        return QueryTokenStream.concatExpressions(ctx.children, arg_0 -> ((HqlQueryRenderer)this).visit(arg_0));
    }

    @Override
    public QueryTokenStream visitLocalDateTimeFunction(HqlParser.LocalDateTimeFunctionContext ctx) {
        if (ctx.LOCAL_DATETIME() != null) {
            return QueryTokenStream.ofFunction(ctx.LOCAL_DATETIME(), QueryTokenStream.empty());
        }
        return QueryTokenStream.concatExpressions(ctx.children, arg_0 -> ((HqlQueryRenderer)this).visit(arg_0));
    }

    @Override
    public QueryTokenStream visitOffsetDateTimeFunction(HqlParser.OffsetDateTimeFunctionContext ctx) {
        if (ctx.OFFSET_DATETIME() != null) {
            return QueryTokenStream.ofFunction(ctx.OFFSET_DATETIME(), QueryTokenStream.empty());
        }
        return QueryTokenStream.concatExpressions(ctx.children, arg_0 -> ((HqlQueryRenderer)this).visit(arg_0));
    }

    @Override
    public QueryTokenStream visitLocalDateFunction(HqlParser.LocalDateFunctionContext ctx) {
        if (ctx.LOCAL_DATE() != null) {
            return QueryTokenStream.ofFunction(ctx.LOCAL_DATE(), QueryTokenStream.empty());
        }
        return QueryTokenStream.concatExpressions(ctx.children, arg_0 -> ((HqlQueryRenderer)this).visit(arg_0));
    }

    @Override
    public QueryTokenStream visitLocalTimeFunction(HqlParser.LocalTimeFunctionContext ctx) {
        if (ctx.LOCAL_TIME() != null) {
            return QueryTokenStream.ofFunction(ctx.LOCAL_TIME(), QueryTokenStream.empty());
        }
        return QueryTokenStream.concatExpressions(ctx.children, arg_0 -> ((HqlQueryRenderer)this).visit(arg_0));
    }

    @Override
    public QueryTokenStream visitFormatFunction(HqlParser.FormatFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder args = QueryRenderer.builder();
        args.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        args.append(QueryTokens.expression(ctx.AS()));
        args.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.format()));
        return QueryTokenStream.ofFunction(ctx.FORMAT(), args);
    }

    @Override
    public QueryTokenStream visitCollateFunction(HqlParser.CollateFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder args = QueryRenderer.builder();
        args.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        args.append(QueryTokens.expression(ctx.AS()));
        args.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.collation()));
        return QueryTokenStream.ofFunction(ctx.COLLATE(), args);
    }

    @Override
    public QueryTokenStream visitCube(HqlParser.CubeContext ctx) {
        return QueryTokenStream.ofFunction(ctx.CUBE(), QueryTokenStream.concat(ctx.expressionOrPredicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
    }

    @Override
    public QueryTokenStream visitRollup(HqlParser.RollupContext ctx) {
        return QueryTokenStream.ofFunction(ctx.ROLLUP(), QueryTokenStream.concat(ctx.expressionOrPredicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
    }

    @Override
    public QueryTokenStream visitTruncFunction(HqlParser.TruncFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.TRUNC() != null) {
            builder.append(QueryTokens.token(ctx.TRUNC()));
        } else {
            builder.append(QueryTokens.token(ctx.TRUNCATE()));
        }
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        if (ctx.datetimeField() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.datetimeField()));
        } else {
            builder.append(QueryTokenStream.concat(ctx.expression(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        }
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitJpaNonstandardFunction(HqlParser.JpaNonstandardFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.FUNCTION()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.jpaNonstandardFunctionName()));
        if (ctx.castTarget() != null) {
            nested.append(QueryTokens.expression(ctx.AS()));
            nested.append((QueryTokenStream)this.visit((ParseTree)ctx.castTarget()));
        }
        if (ctx.genericFunctionArguments() != null) {
            nested.append(QueryTokens.TOKEN_COMMA);
            nested.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.genericFunctionArguments()));
        }
        builder.appendInline(nested);
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitColumnFunction(HqlParser.ColumnFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.COLUMN()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        nested.append(QueryTokens.TOKEN_DOT);
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.jpaNonstandardFunctionName()));
        if (ctx.castTarget() != null) {
            nested.append(QueryTokens.expression(ctx.AS()));
            nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.jpaNonstandardFunctionName()));
        }
        builder.appendInline(nested);
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitGenericFunctionArguments(HqlParser.GenericFunctionArgumentsContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.DISTINCT() != null) {
            builder.append(QueryTokens.expression(ctx.DISTINCT()));
        }
        if (ctx.datetimeField() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.datetimeField()));
            builder.append(QueryTokens.TOKEN_COMMA);
        }
        builder.append(QueryTokenStream.concat(ctx.expressionOrPredicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitCollectionSizeFunction(HqlParser.CollectionSizeFunctionContext ctx) {
        return QueryTokenStream.ofFunction(ctx.SIZE(), (QueryTokenStream)this.visit((ParseTree)ctx.path()));
    }

    @Override
    public QueryTokenStream visitElementAggregateFunction(HqlParser.ElementAggregateFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.MAXELEMENT() != null || ctx.MINELEMENT() != null) {
            builder.append(QueryTokens.token(ctx.MAXELEMENT() != null ? ctx.MAXELEMENT() : ctx.MINELEMENT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.path()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else {
            if (ctx.MAX() != null) {
                builder.append(QueryTokens.token(ctx.MAX()));
            }
            if (ctx.MIN() != null) {
                builder.append(QueryTokens.token(ctx.MIN()));
            }
            if (ctx.SUM() != null) {
                builder.append(QueryTokens.token(ctx.SUM()));
            }
            if (ctx.AVG() != null) {
                builder.append(QueryTokens.token(ctx.AVG()));
            }
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.elementsValuesQuantifier()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            if (ctx.path() != null) {
                builder.append((QueryTokenStream)this.visit((ParseTree)ctx.path()));
            }
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitIndexAggregateFunction(HqlParser.IndexAggregateFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.MAXINDEX() != null || ctx.MININDEX() != null) {
            builder.append(QueryTokens.token(ctx.MAXINDEX() != null ? ctx.MAXINDEX() : ctx.MININDEX()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.path()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else {
            if (ctx.MAX() != null) {
                builder.append(QueryTokens.token(ctx.MAX()));
            }
            if (ctx.MIN() != null) {
                builder.append(QueryTokens.token(ctx.MIN()));
            }
            if (ctx.SUM() != null) {
                builder.append(QueryTokens.token(ctx.SUM()));
            }
            if (ctx.AVG() != null) {
                builder.append(QueryTokens.token(ctx.AVG()));
            }
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.indicesKeysQuantifier()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            if (ctx.path() != null) {
                builder.append((QueryTokenStream)this.visit((ParseTree)ctx.path()));
            }
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitCollectionFunctionMisuse(HqlParser.CollectionFunctionMisuseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)(ctx.elementsValuesQuantifier() != null ? ctx.elementsValuesQuantifier() : ctx.indicesKeysQuantifier())));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitListaggFunction(HqlParser.ListaggFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.LISTAGG()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        if (ctx.DISTINCT() != null) {
            builder.append(QueryTokens.expression(ctx.DISTINCT()));
        }
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate(0)));
        builder.append(QueryTokens.TOKEN_COMMA);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate(1)));
        if (ctx.onOverflowClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.onOverflowClause()));
        }
        builder.appendInline(nested);
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        if (ctx.withinGroupClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.withinGroupClause()));
        }
        if (ctx.filterClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.filterClause()));
        }
        if (ctx.overClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.overClause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitWithinGroupClause(HqlParser.WithinGroupClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.WITHIN()));
        builder.append(QueryTokens.expression(ctx.GROUP()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.orderByClause()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitJsonArrayFunction(HqlParser.JsonArrayFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression(QueryTokenStream.concat(ctx.expressionOrPredicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        if (ctx.jsonNullClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.jsonNullClause()));
        }
        return QueryTokenStream.ofFunction(ctx.JSON_ARRAY(), builder);
    }

    @Override
    public QueryTokenStream visitJsonExistsFunction(HqlParser.JsonExistsFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression(QueryTokenStream.concat(ctx.expression(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        if (ctx.jsonPassingClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.jsonPassingClause()));
        }
        if (ctx.jsonExistsOnErrorClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.jsonExistsOnErrorClause()));
        }
        return QueryTokenStream.ofFunction(ctx.JSON_EXISTS(), builder);
    }

    @Override
    public QueryTokenStream visitJsonObjectFunction(HqlParser.JsonObjectFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression(QueryTokenStream.concat(ctx.jsonObjectFunctionEntry(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        if (ctx.jsonNullClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.jsonNullClause()));
        }
        return QueryTokenStream.ofFunction(ctx.JSON_OBJECT(), builder);
    }

    @Override
    public QueryTokenStream visitJsonQueryFunction(HqlParser.JsonQueryFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression(QueryTokenStream.concat(ctx.expression(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        if (ctx.jsonPassingClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.jsonPassingClause()));
        }
        if (ctx.jsonQueryWrapperClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.jsonQueryWrapperClause()));
        }
        builder.append(QueryTokenStream.concat(ctx.jsonQueryOnErrorOrEmptyClause(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_SPACE));
        return QueryTokenStream.ofFunction(ctx.JSON_QUERY(), builder);
    }

    @Override
    public QueryTokenStream visitJsonValueFunction(HqlParser.JsonValueFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokenStream.concat(ctx.expression(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        if (ctx.jsonPassingClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.jsonPassingClause()));
        }
        if (ctx.jsonValueReturningClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.jsonValueReturningClause()));
        }
        builder.append(QueryTokenStream.concat(ctx.jsonValueOnErrorOrEmptyClause(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_SPACE));
        return QueryTokenStream.ofFunction(ctx.JSON_VALUE(), builder);
    }

    @Override
    public QueryTokenStream visitJsonArrayAggFunction(HqlParser.JsonArrayAggFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate()));
        if (ctx.jsonNullClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.jsonNullClause()));
        }
        if (ctx.orderByClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.orderByClause()));
        }
        QueryTokenStream function = QueryTokenStream.ofFunction(ctx.JSON_ARRAYAGG(), builder);
        if (ctx.filterClause() == null) {
            return function;
        }
        QueryRenderer.QueryRendererBuilder functionWithFilter = QueryRenderer.builder();
        functionWithFilter.appendExpression(function);
        functionWithFilter.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.filterClause()));
        return functionWithFilter.build();
    }

    @Override
    public QueryTokenStream visitJsonObjectAggFunction(HqlParser.JsonObjectAggFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.KEY() != null) {
            builder.append(QueryTokens.expression(ctx.KEY()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate(0)));
        if (ctx.VALUE() != null) {
            builder.append(QueryTokens.expression(ctx.VALUE()));
        } else {
            builder.append(QueryTokens.TOKEN_COLON);
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate(1)));
        if (ctx.jsonNullClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.jsonNullClause()));
        }
        if (ctx.jsonUniqueKeysClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.jsonUniqueKeysClause()));
        }
        QueryTokenStream function = QueryTokenStream.ofFunction(ctx.JSON_OBJECTAGG(), builder);
        if (ctx.filterClause() == null) {
            return function;
        }
        QueryRenderer.QueryRendererBuilder functionWithFilter = QueryRenderer.builder();
        functionWithFilter.appendExpression(function);
        functionWithFilter.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.filterClause()));
        return functionWithFilter.build();
    }

    @Override
    public QueryTokenStream visitJsonPassingClause(HqlParser.JsonPassingClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.PASSING()));
        builder.append(QueryTokenStream.concat(ctx.aliasedExpressionOrPredicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitJsonTableFunction(HqlParser.JsonTableFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression(QueryTokenStream.concat(ctx.expression(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        if (ctx.jsonPassingClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.jsonPassingClause()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.jsonTableColumnsClause()));
        if (ctx.jsonTableErrorClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.jsonTableErrorClause()));
        }
        return QueryTokenStream.ofFunction(ctx.JSON_TABLE(), builder);
    }

    @Override
    public QueryTokenStream visitJsonTableColumnsClause(HqlParser.JsonTableColumnsClauseContext ctx) {
        return QueryTokenStream.ofFunction(ctx.COLUMNS(), (QueryTokenStream)this.visit((ParseTree)ctx.jsonTableColumns()));
    }

    @Override
    public QueryTokenStream visitJsonTableColumns(HqlParser.JsonTableColumnsContext ctx) {
        return QueryTokenStream.concat(ctx.jsonTableColumn(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA);
    }

    @Override
    public QueryTokenStream visitXmlElementFunction(HqlParser.XmlElementFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.NAME()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        if (ctx.xmlAttributesFunction() != null) {
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.xmlAttributesFunction()));
        }
        if (!CollectionUtils.isEmpty(ctx.expressionOrPredicate())) {
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.append(QueryTokenStream.concat(ctx.expressionOrPredicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        }
        return QueryTokenStream.ofFunction(ctx.XMLELEMENT(), builder);
    }

    @Override
    public QueryTokenStream visitXmlAttributesFunction(HqlParser.XmlAttributesFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression(QueryTokenStream.concat(ctx.aliasedExpressionOrPredicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return QueryTokenStream.ofFunction(ctx.XMLATTRIBUTES(), builder);
    }

    @Override
    public QueryTokenStream visitXmlForestFunction(HqlParser.XmlForestFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression(QueryTokenStream.concat(ctx.potentiallyAliasedExpressionOrPredicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return QueryTokenStream.ofFunction(ctx.XMLFOREST(), builder);
    }

    @Override
    public QueryTokenStream visitXmlPiFunction(HqlParser.XmlPiFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.NAME()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        if (ctx.expression() != null) {
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        }
        return QueryTokenStream.ofFunction(ctx.XMLPI(), builder);
    }

    @Override
    public QueryTokenStream visitXmlQueryFunction(HqlParser.XmlQueryFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        builder.append(QueryTokens.expression(ctx.PASSING()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        return QueryTokenStream.ofFunction(ctx.XMLQUERY(), builder);
    }

    @Override
    public QueryTokenStream visitXmlExistsFunction(HqlParser.XmlExistsFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        builder.append(QueryTokens.expression(ctx.PASSING()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        return QueryTokenStream.ofFunction(ctx.XMLEXISTS(), builder);
    }

    @Override
    public QueryTokenStream visitXmlAggFunction(HqlParser.XmlAggFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder args = QueryRenderer.builder();
        args.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        if (ctx.orderByClause() != null) {
            args.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.orderByClause()));
        }
        QueryTokenStream function = QueryTokenStream.ofFunction(ctx.XMLAGG(), args);
        if (ctx.filterClause() == null && ctx.overClause() == null) {
            return function;
        }
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression(function);
        if (ctx.filterClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.filterClause()));
        }
        if (ctx.overClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.overClause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitXmlTableFunction(HqlParser.XmlTableFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder args = QueryRenderer.builder();
        args.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        args.append(QueryTokens.expression(ctx.PASSING()));
        args.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        args.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.xmlTableColumnsClause()));
        return QueryTokenStream.ofFunction(ctx.XMLTABLE(), args);
    }

    @Override
    public QueryTokenStream visitXmlTableColumnsClause(HqlParser.XmlTableColumnsClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.COLUMNS()));
        builder.append(QueryTokenStream.concat(ctx.xmlTableColumn(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitPath(HqlParser.PathContext ctx) {
        return QueryTokenStream.concat(ctx.children, arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.EMPTY_TOKEN);
    }

    @Override
    public QueryTokenStream visitGeneralPathFragment(HqlParser.GeneralPathFragmentContext ctx) {
        return QueryTokenStream.concat(ctx.children, arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.EMPTY_TOKEN);
    }

    @Override
    public QueryTokenStream visitIndexedPathAccessFragment(HqlParser.IndexedPathAccessFragmentContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_SQUARE_BRACKET);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.append(QueryTokens.TOKEN_CLOSE_SQUARE_BRACKET);
        if (ctx.generalPathFragment() != null) {
            builder.append(QueryTokens.TOKEN_DOT);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.generalPathFragment()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSimplePath(HqlParser.SimplePathContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        if (!ctx.simplePathElement().isEmpty()) {
            builder.append(QueryTokens.TOKEN_DOT);
        }
        builder.append(QueryTokenStream.concat(ctx.simplePathElement(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT));
        return builder;
    }

    @Override
    public QueryTokenStream visitSimplePathElement(HqlParser.SimplePathElementContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.identifier());
    }

    @Override
    public QueryTokenStream visitGenericFunction(HqlParser.GenericFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.append((QueryTokenStream)this.visit((ParseTree)ctx.genericFunctionName()));
        nested.append(QueryTokens.TOKEN_OPEN_PAREN);
        if (ctx.genericFunctionArguments() != null) {
            nested.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.genericFunctionArguments()));
        } else if (ctx.ASTERISK() != null) {
            nested.append(QueryTokens.token(ctx.ASTERISK()));
        }
        nested.append(QueryTokens.TOKEN_CLOSE_PAREN);
        builder.append(nested);
        if (ctx.pathContinuation() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.pathContinuation()));
        }
        if (ctx.nthSideClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.nthSideClause()));
        }
        if (ctx.nullsClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.nullsClause()));
        }
        if (ctx.withinGroupClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.withinGroupClause()));
        }
        if (ctx.filterClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.filterClause()));
        }
        if (ctx.overClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.overClause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFilterClause(HqlParser.FilterClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.FILTER()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.whereClause()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitOverClause(HqlParser.OverClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.OVER()));
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        ArrayList<ParserRuleContext> trees = new ArrayList<ParserRuleContext>();
        if (ctx.partitionClause() != null) {
            trees.add(ctx.partitionClause());
        }
        if (ctx.orderByClause() != null) {
            trees.add(ctx.orderByClause());
        }
        if (ctx.frameClause() != null) {
            trees.add(ctx.frameClause());
        }
        nested.appendInline(QueryTokenStream.concat(trees, arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_SPACE));
        builder.appendInline(QueryTokenStream.group(nested));
        return builder;
    }

    @Override
    public QueryTokenStream visitPartitionClause(HqlParser.PartitionClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.PARTITION()));
        builder.append(QueryTokens.expression(ctx.BY()));
        builder.append(QueryTokenStream.concat(ctx.expression(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitCastFunction(HqlParser.CastFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        nested.append(QueryTokens.expression(ctx.AS()));
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.castTarget()));
        return QueryTokenStream.ofFunction(ctx.CAST(), nested);
    }

    @Override
    public QueryTokenStream visitCastTarget(HqlParser.CastTargetContext ctx) {
        List<TerminalNode> literals = ctx.INTEGER_LITERAL();
        if (!CollectionUtils.isEmpty(literals)) {
            QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.castTargetType()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            QueryRenderer.QueryRendererBuilder args = QueryRenderer.builder();
            int i = 0;
            while (i < literals.size()) {
                if (i > 0) {
                    args.append(QueryTokens.TOKEN_COMMA);
                }
                args.append(QueryTokens.token(literals.get(i)));
                ++i;
            }
            builder.appendInline(args.build());
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
            return builder.build();
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.castTargetType());
    }

    @Override
    public QueryTokenStream visitCastTargetType(HqlParser.CastTargetTypeContext ctx) {
        return QueryTokens.token(ctx.fullTargetName);
    }

    @Override
    public QueryTokenStream visitExtractFunction(HqlParser.ExtractFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.EXTRACT() != null) {
            builder.append(QueryTokens.token(ctx.EXTRACT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
            nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.extractField()));
            nested.append(QueryTokens.expression(ctx.FROM()));
            nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
            builder.appendInline(nested);
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.datetimeField() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.datetimeField()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitTrimFunction(HqlParser.TrimFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.trimSpecification() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.trimSpecification()));
        }
        if (ctx.trimCharacter() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.trimCharacter()));
        }
        if (ctx.FROM() != null) {
            builder.append(QueryTokens.expression(ctx.FROM()));
        }
        if (ctx.expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        }
        return QueryTokenStream.ofFunction(ctx.TRIM(), builder);
    }

    @Override
    public QueryTokenStream visitEveryFunction(HqlParser.EveryFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.everyAllQuantifier()));
        if (ctx.predicate() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.predicate()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
            if (ctx.filterClause() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.filterClause()));
            }
            if (ctx.overClause() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.overClause()));
            }
        } else if (ctx.subquery() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.collectionQuantifier()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitAnyFunction(HqlParser.AnyFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.anySomeQuantifier()));
        if (ctx.predicate() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.predicate()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
            if (ctx.filterClause() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.filterClause()));
            }
            if (ctx.overClause() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.overClause()));
            }
        } else if (ctx.subquery() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.collectionQuantifier()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitTreatedNavigablePath(HqlParser.TreatedNavigablePathContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        nested.append(QueryTokens.expression(ctx.AS()));
        nested.append((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
        builder.append(QueryTokenStream.ofFunction(ctx.TREAT(), nested));
        if (ctx.pathContinuation() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.pathContinuation()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitCollectionValueNavigablePath(HqlParser.CollectionValueNavigablePathContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.elementValueQuantifier()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        if (ctx.pathContinuation() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.pathContinuation()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitMapKeyNavigablePath(HqlParser.MapKeyNavigablePathContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.indexKeyQuantifier()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        if (ctx.pathContinuation() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.pathContinuation()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitToOneFkReference(HqlParser.ToOneFkReferenceContext ctx) {
        return QueryTokenStream.ofFunction(ctx.FK(), (QueryTokenStream)this.visit((ParseTree)ctx.path()));
    }

    @Override
    public QueryTokenStream visitGroupedPredicate(HqlParser.GroupedPredicateContext ctx) {
        return QueryTokenStream.group((QueryTokenStream)this.visit((ParseTree)ctx.predicate()));
    }

    @Override
    public QueryTokenStream visitInList(HqlParser.InListContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.simplePath() != null) {
            if (ctx.ELEMENTS() != null) {
                builder.append(QueryTokens.token(ctx.ELEMENTS()));
            } else if (ctx.INDICES() != null) {
                builder.append(QueryTokens.token(ctx.INDICES()));
            }
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.subquery() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.parameter() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.parameter()));
        } else if (ctx.expressionOrPredicate() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline(QueryTokenStream.concat(ctx.expressionOrPredicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitExistsExpression(HqlParser.ExistsExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.simplePath() != null) {
            builder.append(QueryTokens.expression(ctx.EXISTS()));
            if (ctx.ELEMENTS() != null) {
                builder.append(QueryTokens.token(ctx.ELEMENTS()));
            } else if (ctx.INDICES() != null) {
                builder.append(QueryTokens.token(ctx.INDICES()));
            }
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.expression() != null) {
            builder.append(QueryTokens.expression(ctx.EXISTS()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitInstantiationArguments(HqlParser.InstantiationArgumentsContext ctx) {
        return QueryTokenStream.concat(ctx.instantiationArgument(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA);
    }

    @Override
    public QueryTokenStream visitParameter(HqlParser.ParameterContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.prefix.getText().equals(":")) {
            builder.append(QueryTokens.TOKEN_COLON);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        } else if (ctx.prefix.getText().equals("?")) {
            builder.append(QueryTokens.TOKEN_QUESTION_MARK);
            if (ctx.INTEGER_LITERAL() != null) {
                builder.append(QueryTokens.token(ctx.INTEGER_LITERAL()));
            }
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitEntityName(HqlParser.EntityNameContext ctx) {
        return QueryTokenStream.concat(ctx.identifier(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT);
    }

    public QueryTokenStream visitChildren(RuleNode node) {
        ParseTree parseTree;
        ParseTree parseTree2;
        int childCount = node.getChildCount();
        if (childCount == 1 && (parseTree2 = node.getChild(0)) instanceof RuleContext) {
            RuleContext t = (RuleContext)parseTree2;
            return (QueryTokenStream)this.visit((ParseTree)t);
        }
        if (childCount == 1 && (parseTree = node.getChild(0)) instanceof TerminalNode) {
            TerminalNode t = (TerminalNode)parseTree;
            return QueryTokens.token(t);
        }
        return QueryTokenStream.concatExpressions((Tree)node, arg_0 -> ((HqlQueryRenderer)this).visit(arg_0));
    }
}

